/*
 * Decompiled with CFR 0.152.
 */
package com.sun.btrace;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public abstract class Profiler {
    public final long START_TIME = System.currentTimeMillis();

    public abstract void recordEntry(String var1);

    public abstract void recordExit(String var1, long var2);

    public final Snapshot snapshot() {
        return this.snapshot(false);
    }

    public abstract Snapshot snapshot(boolean var1);

    public abstract void reset();

    public static interface MBeanValueProvider {
        public Snapshot getMBeanValue();
    }

    public static final class Record {
        public static final Comparator<Record> COMPARATOR = new Comparator<Record>(){

            @Override
            public int compare(Record o1, Record o2) {
                if (o1 == null && o2 != null) {
                    return 1;
                }
                if (o1 != null && o2 == null) {
                    return -1;
                }
                if (o1 == null && o2 == null) {
                    return 0;
                }
                return o1.blockName.compareTo(o2.blockName);
            }
        };
        public final String blockName;
        public long threadId = Thread.currentThread().getId();
        public long wallTime = 0L;
        public long wallTimeMax = 0L;
        public long wallTimeMin = Long.MAX_VALUE;
        public long selfTime = 0L;
        public long selfTimeMax = 0L;
        public long selfTimeMin = Long.MAX_VALUE;
        public long invocations = 1L;
        public boolean onStack = false;

        public Record(String blockName) {
            this.blockName = blockName;
        }

        public Record duplicate() {
            Record r = new Record(this.blockName);
            r.threadId = this.threadId;
            r.invocations = this.invocations;
            r.selfTime = this.selfTime;
            r.selfTimeMax = this.selfTimeMax;
            r.selfTimeMin = this.selfTimeMin;
            r.wallTime = this.wallTime;
            r.wallTimeMax = this.wallTimeMax;
            r.wallTimeMin = this.wallTimeMin;
            return r;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Record other = (Record)obj;
            if (this.blockName == null ? other.blockName != null : !this.blockName.equals(other.blockName)) {
                return false;
            }
            if (this.wallTime != other.wallTime) {
                return false;
            }
            if (this.selfTime != other.selfTime) {
                return false;
            }
            return this.invocations == other.invocations;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.blockName != null ? this.blockName.hashCode() : 0);
            hash = 17 * hash + (int)(this.wallTime ^ this.wallTime >>> 32);
            hash = 17 * hash + (int)(this.selfTime ^ this.selfTime >>> 32);
            hash = 17 * hash + (int)(this.invocations ^ this.invocations >>> 32);
            return hash;
        }

        public String toString() {
            return "Record{\n\tblockName=" + this.blockName + "\n," + "\twallTime=" + this.wallTime + ",\n" + "\twallTime.min=" + this.wallTimeMin + ",\n" + "\twallTime.max=" + this.wallTimeMax + ",\n" + "\tselfTime=" + this.selfTime + ",\n" + "\tselfTime.min=" + this.selfTimeMin + ",\n" + "\tselfTime.max=" + this.selfTimeMax + ",\n" + "\tinvocations=" + this.invocations + ",\nonStack=" + this.onStack + '}';
        }
    }

    public static final class Snapshot {
        public final long timeStamp;
        public final long timeInterval;
        public final Record[] total;

        public Snapshot(Record[] data, long startTs, long stopTs) {
            this.timeStamp = stopTs;
            this.timeInterval = stopTs - startTs;
            this.total = data;
        }

        List<Object[]> getGridData() {
            ArrayList<Object[]> rslt = new ArrayList<Object[]>();
            Object[] titleRow = new Object[]{"Block", "Invocations", "SelfTime.Total", "SelfTime.Avg", "SelfTime.Min", "SelfTime.Max", "WallTime.Total", "WallTime.Avg", "WallTime.Min", "WallTime.Max"};
            rslt.add(titleRow);
            for (Record r : this.total) {
                if (r == null) continue;
                Object[] row = new Object[]{r.blockName, r.invocations, r.selfTime, r.selfTime / r.invocations, r.selfTimeMin < Long.MAX_VALUE ? Long.valueOf(r.selfTimeMin) : "N/A", r.selfTimeMax > 0L ? Long.valueOf(r.selfTimeMax) : "N/A", r.wallTime, r.wallTime / r.invocations, r.wallTimeMin < Long.MAX_VALUE ? Long.valueOf(r.wallTimeMin) : "N/A", r.wallTimeMax > 0L ? Long.valueOf(r.wallTimeMax) : "N/A"};
                rslt.add(row);
            }
            return rslt;
        }
    }
}

