/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.advice.AbstractAdvice;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;

public class PerInstanceAdvice
extends AbstractAdvice {
    private boolean initialized = false;
    AspectDefinition aspectDefinition;

    public PerInstanceAdvice(String adviceName, AspectDefinition a, Advisor advisor) {
        this.aspectDefinition = a;
        this.adviceName = adviceName;
        advisor.addPerInstanceAspect(a);
    }

    public String getName() {
        return this.aspectDefinition.getName() + "." + this.adviceName;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        ClassInstanceAdvisor advisor;
        Advised advised;
        Object aspect = null;
        if (invocation instanceof CallerInvocation) {
            Object callingObject = null;
            if (invocation instanceof ConstructorCalledByMethodInvocation) {
                callingObject = ((ConstructorCalledByMethodInvocation)invocation).getCallingObject();
            } else if (invocation instanceof MethodCalledByMethodInvocation) {
                callingObject = ((MethodCalledByMethodInvocation)invocation).getCallingObject();
            }
            if (callingObject == null) {
                return invocation.invokeNext();
            }
            advised = (Advised)callingObject;
            advisor = (ClassInstanceAdvisor)advised._getInstanceAdvisor();
            aspect = advisor.getPerInstanceAspect(this.aspectDefinition);
        } else {
            Object targetObject = invocation.getTargetObject();
            if (targetObject == null) {
                return invocation.invokeNext();
            }
            advised = (Advised)targetObject;
            advisor = (ClassInstanceAdvisor)advised._getInstanceAdvisor();
            aspect = advisor.getPerInstanceAspect(this.aspectDefinition);
        }
        if (!this.initialized) {
            this.init(this.adviceName, aspect.getClass());
            this.initialized = true;
        }
        Method advice = this.resolveAdvice(invocation);
        Object[] args = new Object[]{invocation};
        try {
            return advice.invoke(aspect, args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

