/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.reflect.Modifier;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.CallerInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodInvocation;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.FieldJoinpoint;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;
import org.jboss.aop.joinpoint.MethodCalledByMethodInvocation;
import org.jboss.aop.joinpoint.MethodCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;

public class PerJoinpointInterceptor
implements Interceptor {
    AspectDefinition aspectDefinition;
    Joinpoint joinpoint;

    public static Interceptor createInterceptor(Advisor advisor, Joinpoint joinpoint, AspectDefinition def) throws Exception {
        if (joinpoint instanceof MethodJoinpoint) {
            MethodJoinpoint method = (MethodJoinpoint)joinpoint;
            if (Modifier.isStatic(method.getMethod().getModifiers())) {
                return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
            }
        } else {
            FieldJoinpoint field;
            MethodCalledByMethodJoinpoint method;
            if (joinpoint instanceof ConstructorJoinpoint || joinpoint instanceof ConstructorCalledByConstructorJoinpoint || joinpoint instanceof MethodCalledByConstructorJoinpoint) {
                return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
            }
            if (joinpoint instanceof MethodCalledByMethodJoinpoint ? Modifier.isStatic((method = (MethodCalledByMethodJoinpoint)joinpoint).getCalling().getModifiers()) : (joinpoint instanceof ConstructorCalledByMethodJoinpoint ? Modifier.isStatic((method = (ConstructorCalledByMethodJoinpoint)joinpoint).getCalling().getModifiers()) : joinpoint instanceof FieldJoinpoint && Modifier.isStatic((field = (FieldJoinpoint)joinpoint).getField().getModifiers()))) {
                return (Interceptor)def.getFactory().createPerJoinpoint(advisor, joinpoint);
            }
        }
        return new PerJoinpointInterceptor(def, advisor, joinpoint);
    }

    public PerJoinpointInterceptor(AspectDefinition a, Advisor advisor, Joinpoint joinpoint) {
        this.aspectDefinition = a;
        advisor.addPerInstanceJoinpointAspect(joinpoint, a);
        this.joinpoint = joinpoint;
    }

    public String getName() {
        return this.aspectDefinition.getName();
    }

    public Object invoke(Invocation invocation) throws Throwable {
        if (invocation instanceof CallerInvocation) {
            Object callingObject = null;
            if (invocation instanceof ConstructorCalledByMethodInvocation) {
                callingObject = ((ConstructorCalledByMethodInvocation)invocation).getCallingObject();
            } else if (invocation instanceof MethodCalledByMethodInvocation) {
                callingObject = ((MethodCalledByMethodInvocation)invocation).getCallingObject();
            }
            if (callingObject == null) {
                return invocation.invokeNext();
            }
            Advised advised = (Advised)callingObject;
            ClassInstanceAdvisor advisor = (ClassInstanceAdvisor)advised._getInstanceAdvisor();
            Interceptor interceptor = (Interceptor)advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
            return interceptor.invoke(invocation);
        }
        Object targetObject = invocation.getTargetObject();
        if (targetObject == null) {
            return invocation.invokeNext();
        }
        Advised advised = (Advised)targetObject;
        ClassInstanceAdvisor advisor = (ClassInstanceAdvisor)advised._getInstanceAdvisor();
        Interceptor interceptor = (Interceptor)advisor.getPerInstanceJoinpointAspect(this.joinpoint, this.aspectDefinition);
        return interceptor.invoke(invocation);
    }
}

