/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.joinpoint;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorInvocationWrapper;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationBase;

public class ConstructorInvocation
extends InvocationBase {
    private static final long serialVersionUID = -7880020293056198584L;
    protected Object[] arguments = null;
    protected transient Constructor constructor = null;

    public ConstructorInvocation(Interceptor[] interceptors) {
        super(interceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeNext() throws Throwable {
        if (this.interceptors != null && this.currentInterceptor < this.interceptors.length) {
            try {
                Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                return object;
            }
            finally {
                --this.currentInterceptor;
            }
        }
        try {
            Constructor con = this.getConstructor();
            Object[] args = this.getArguments();
            this.setTargetObject(con.newInstance(args));
            return this.getTargetObject();
        }
        catch (InstantiationException in) {
            throw new RuntimeException("failed to call constructor", in);
        }
        catch (IllegalAccessException ill) {
            throw new RuntimeException("illegal access", ill);
        }
        catch (InvocationTargetException ite) {
            throw ite.getCause();
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
    }

    public Object resolveAnnotation(Class annotation) {
        Object val = super.resolveAnnotation(annotation);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().resolveAnnotation(this.constructor, annotation)) != null) {
            return val;
        }
        return null;
    }

    public Object getMetaData(Object group, Object attr) {
        Object val = super.getMetaData(group, attr);
        if (val != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getConstructorMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        if (this.getAdvisor() != null && (val = this.getAdvisor().getDefaultMetaData().resolve(this, group, attr)) != null) {
            return val;
        }
        return null;
    }

    public Invocation getWrapper(Interceptor[] newchain) {
        ConstructorInvocationWrapper wrapper = new ConstructorInvocationWrapper(this, newchain);
        return wrapper;
    }

    public Invocation copy() {
        ConstructorInvocation wrapper = new ConstructorInvocation(this.interceptors);
        wrapper.arguments = this.arguments;
        wrapper.constructor = this.constructor;
        wrapper.setAdvisor(this.getAdvisor());
        wrapper.currentInterceptor = this.currentInterceptor;
        wrapper.metadata = this.metadata;
        return wrapper;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }
}

