/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.metadata;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import javassist.CtMethod;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.metadata.SimpleMetaData;
import org.jboss.aop.util.PayloadKey;

public class MethodMetaData
implements MetaDataResolver {
    HashMap methodMetaData = new HashMap();

    public boolean hasTag(String group) {
        Iterator values = this.methodMetaData.values().iterator();
        while (values.hasNext()) {
            SimpleMetaData map = (SimpleMetaData)values.next();
            if (!map.hasTag(group)) continue;
            return true;
        }
        return false;
    }

    public void tagMethod(Method method, Object tag) {
        this.addMethodMetaData(method, tag, (Object)"$tagged$", new Object(), PayloadKey.TRANSIENT);
    }

    public void addMethodMetaData(Method method, Object tag, Object attr, Object value) {
        this.addMethodMetaData(method, tag, attr, value, PayloadKey.MARSHALLED);
    }

    public synchronized void addMethodMetaData(Method method, Object tag, Object attr, Object value, PayloadKey type) {
        this.addMethodMetaData(method.toString(), tag, attr, value, type);
    }

    private synchronized void addMethodMetaData(String key, Object tag, Object attr, Object value, PayloadKey type) {
        SimpleMetaData methodData = (SimpleMetaData)this.methodMetaData.get(key);
        if (methodData == null) {
            methodData = new SimpleMetaData();
            this.methodMetaData.put(key, methodData);
        }
        methodData.addMetaData(tag, attr, value, type);
    }

    public synchronized boolean hasTag(Method method, String tag) {
        SimpleMetaData meta = this.getMethodMetaData(method);
        if (meta == null) {
            return false;
        }
        return meta.hasTag(tag);
    }

    public synchronized Iterator getMethods() {
        return this.methodMetaData.keySet().iterator();
    }

    public synchronized SimpleMetaData getMethodMetaData(String method) {
        return (SimpleMetaData)this.methodMetaData.get(method);
    }

    public SimpleMetaData getMethodMetaData(Method method) {
        return this.getMethodMetaData(method.toString());
    }

    public synchronized Object getMethodMetaData(Method method, Object tag, Object attr) {
        SimpleMetaData methodData = (SimpleMetaData)this.methodMetaData.get(method.toString());
        if (methodData == null) {
            return null;
        }
        return methodData.getMetaData(tag, attr);
    }

    public synchronized void clear() {
        this.methodMetaData.clear();
    }

    public Object resolve(Invocation invocation, Object tag, Object attr) {
        MethodInvocation methodInvocation = (MethodInvocation)invocation;
        return this.getMethodMetaData(methodInvocation.getMethod(), tag, attr);
    }

    public synchronized SimpleMetaData getAllMetaData(Invocation invocation) {
        MethodInvocation methodInvocation = (MethodInvocation)invocation;
        return (SimpleMetaData)this.methodMetaData.get(methodInvocation.getMethod().toString());
    }

    private String getCtMethodKey(CtMethod method) {
        return method.getName() + ":" + method.getSignature();
    }

    public void tagMethod(CtMethod method, Object tag) {
        this.addMethodMetaData(method, tag, (Object)"$tagged$", (Object)PayloadKey.TRANSIENT);
    }

    public void addMethodMetaData(CtMethod method, Object tag, Object attr, Object value) {
        this.addMethodMetaData(this.getCtMethodKey(method), tag, attr, value, PayloadKey.MARSHALLED);
    }

    public void addMethodMetaData(CtMethod method, Object tag, Object attr, Object value, PayloadKey type) {
        this.addMethodMetaData(this.getCtMethodKey(method), tag, attr, value, type);
    }

    public synchronized boolean hasGroup(CtMethod method, String tag) {
        SimpleMetaData meta = this.getMethodMetaData(this.getCtMethodKey(method));
        if (meta == null) {
            return false;
        }
        return meta.hasTag(tag);
    }
}

