/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.providers;

import com.opensymphony.xwork2.ActionSupport;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ConfigurationUtil;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.config.entities.ExceptionMappingConfig;
import com.opensymphony.xwork2.config.entities.InterceptorConfig;
import com.opensymphony.xwork2.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork2.config.entities.PackageConfig;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import com.opensymphony.xwork2.config.entities.ResultTypeConfig;
import com.opensymphony.xwork2.config.impl.LocatableFactory;
import com.opensymphony.xwork2.config.providers.InterceptorBuilder;
import com.opensymphony.xwork2.config.providers.XmlHelper;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.DomHelper;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.location.Location;
import com.opensymphony.xwork2.util.location.LocationUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Log LOG = LogFactory.getLog(XmlConfigurationProvider.class);
    private List<Document> documents;
    private Set<String> includedFileNames;
    private String configFileName;
    private ObjectFactory objectFactory;
    private Set<String> loadedFileUrls = new HashSet<String>();
    private boolean errorIfMissing;
    private Map<String, String> dtdMappings;
    private Configuration configuration;

    public XmlConfigurationProvider() {
        this("xwork.xml", true);
    }

    public XmlConfigurationProvider(String filename) {
        this(filename, true);
    }

    public XmlConfigurationProvider(String filename, boolean errorIfMissing) {
        this.configFileName = filename;
        this.errorIfMissing = errorIfMissing;
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("-//OpenSymphony Group//XWork 2.0//EN", "xwork-2.0.dtd");
        mappings.put("-//OpenSymphony Group//XWork 1.1.1//EN", "xwork-1.1.1.dtd");
        mappings.put("-//OpenSymphony Group//XWork 1.1//EN", "xwork-1.1.dtd");
        mappings.put("-//OpenSymphony Group//XWork 1.0//EN", "xwork-1.0.dtd");
        this.setDtdMappings(mappings);
    }

    public void setDtdMappings(Map<String, String> mappings) {
        this.dtdMappings = Collections.unmodifiableMap(mappings);
    }

    @Inject
    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public Map<String, String> getDtdMappings() {
        return this.dtdMappings;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames = configuration.getLoadedFileNames();
        this.loadDocuments(this.configFileName);
    }

    @Override
    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    private void loadDocuments(String configFileName) {
        try {
            this.loadedFileUrls.clear();
            this.documents = this.loadConfigurationFiles(configFileName, null);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error loading configuration file " + configFileName, e);
        }
    }

    @Override
    public void register(ContainerBuilder containerBuilder, LocatableProperties props) throws ConfigurationException {
        LOG.info((Object)("Parsing configuration file [" + this.configFileName + "]"));
        HashMap<String, Element> loadedBeans = new HashMap<String, Element>();
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if (nodeName.equals("bean")) {
                    String type = child.getAttribute("type");
                    String name = child.getAttribute("name");
                    String impl = child.getAttribute("class");
                    String onlyStatic = child.getAttribute("static");
                    String scopeStr = child.getAttribute("scope");
                    boolean optional = "true".equals(child.getAttribute("optional"));
                    Scope scope = Scope.SINGLETON;
                    if ("default".equals(scopeStr)) {
                        scope = Scope.DEFAULT;
                    } else if ("request".equals(scopeStr)) {
                        scope = Scope.REQUEST;
                    } else if ("session".equals(scopeStr)) {
                        scope = Scope.SESSION;
                    } else if ("singleton".equals(scopeStr)) {
                        scope = Scope.SINGLETON;
                    } else if ("thread".equals(scopeStr)) {
                        scope = Scope.THREAD;
                    }
                    if (!TextUtils.stringSet(name)) {
                        name = "default";
                    }
                    try {
                        Class cimpl;
                        Class ctype = cimpl = ClassLoaderUtil.loadClass(impl, this.getClass());
                        if (TextUtils.stringSet(type)) {
                            ctype = ClassLoaderUtil.loadClass(type, this.getClass());
                        }
                        if ("true".equals(onlyStatic)) {
                            cimpl.getDeclaredClasses();
                            containerBuilder.injectStatics(cimpl);
                        } else {
                            if (containerBuilder.contains(ctype, name)) {
                                Location loc = LocationUtils.getLocation(loadedBeans.get(ctype.getName() + name));
                                throw new ConfigurationException("Bean type " + ctype + " with the name " + name + " has already been loaded by " + loc, (Object)child);
                            }
                            cimpl.getDeclaredConstructors();
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Loaded type:" + type + " name:" + name + " impl:" + impl));
                            }
                            containerBuilder.factory(ctype, name, new LocatableFactory(name, ctype, cimpl, scope, childNode), scope);
                        }
                        loadedBeans.put(ctype.getName() + name, child);
                    }
                    catch (Throwable ex) {
                        if (!optional) {
                            throw new ConfigurationException("Unable to load bean: type:" + type + " class:" + impl, ex, childNode);
                        }
                        LOG.debug((Object)("Unable to load optional class: " + ex));
                    }
                    continue;
                }
                if (!nodeName.equals("constant")) continue;
                String name = child.getAttribute("name");
                String value = child.getAttribute("value");
                props.setProperty(name, value, childNode);
            }
        }
    }

    @Override
    public void loadPackages() throws ConfigurationException {
        for (Document doc : this.documents) {
            Element rootElement = doc.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            for (int i = 0; i < childSize; ++i) {
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !(nodeName = (child = (Element)childNode).getNodeName()).equals("package")) continue;
                this.addPackage(child);
            }
            this.loadExtraConfiguration(doc);
        }
        this.documents.clear();
        this.configuration = null;
    }

    @Override
    public boolean needsReload() {
        for (String url : this.loadedFileUrls) {
            if (!FileManager.fileNeedsReloading(url)) continue;
            return true;
        }
        return false;
    }

    protected void addAction(Element actionElement, PackageConfig packageContext) throws ConfigurationException {
        Map results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = actionElement.getAttribute("method");
        Location location = DomHelper.getLocationObject(actionElement);
        if (location == null) {
            LOG.warn((Object)("location null for " + className));
        }
        String string = methodName = methodName.trim().length() > 0 ? methodName.trim() : null;
        if (!TextUtils.stringSet(className)) {
            className = TextUtils.stringSet(packageContext.getDefaultClassRef()) ? packageContext.getDefaultClassRef() : ActionSupport.class.getName();
        }
        if (!this.verifyAction(className, name, location)) {
            return;
        }
        Map actionParams = XmlHelper.getParams(actionElement);
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e, actionElement);
        }
        List interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List exceptionMappings = this.buildExceptionMappings(actionElement, packageContext);
        ActionConfig actionConfig = new ActionConfig(methodName, className, packageContext.getName(), actionParams, results, interceptorList, exceptionMappings);
        actionConfig.setLocation(location);
        packageContext.addActionConfig(name, actionConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + (TextUtils.stringSet(packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + actionConfig));
        }
    }

    protected boolean verifyAction(String className, String name, Location loc) {
        if (className.indexOf(123) > -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Action class [" + className + "] contains a wildcard " + "replacement value, so it can't be verified"));
            }
            return true;
        }
        try {
            Class clazz = this.objectFactory.getClassInstance(className);
            if (this.objectFactory.isNoArgConstructorRequired()) {
                if (!Modifier.isPublic(clazz.getModifiers())) {
                    throw new ConfigurationException("Action class [" + className + "] is not public", (Object)loc);
                }
                clazz.getConstructor(new Class[0]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Action class [" + className + "] not found", (Object)loc);
        }
        catch (NoSuchMethodException e) {
            throw new ConfigurationException("Action class [" + className + "] does not have a public no-arg constructor", e, loc);
        }
        catch (RuntimeException ex) {
            LOG.info((Object)("Unable to verify action class [" + className + "] exists at initialization"));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Action verification cause", (Throwable)ex);
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex, (Object)loc);
        }
        return true;
    }

    protected void addPackage(Element packageElement) throws ConfigurationException {
        PackageConfig newPackage = this.buildPackageContext(packageElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + newPackage));
        }
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadDefaultClassRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        this.loadGobalExceptionMappings(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.loadDefaultActionRef(newPackage, packageElement);
        this.configuration.addPackageConfig(newPackage.getName(), newPackage);
    }

    protected void addResultTypes(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            Location loc = DomHelper.getLocationObject(resultTypeElement);
            Class clazz = this.verifyResultType(className, loc);
            if (clazz == null) continue;
            String paramName = null;
            try {
                paramName = (String)clazz.getField("DEFAULT_PARAM").get(null);
            }
            catch (Throwable t) {
                // empty catch block
            }
            ResultTypeConfig resultType = new ResultTypeConfig(name, className, paramName);
            resultType.setLocation(DomHelper.getLocationObject(resultTypeElement));
            Map params = XmlHelper.getParams(resultTypeElement);
            if (!params.isEmpty()) {
                resultType.setParams(params);
            }
            packageContext.addResultTypeConfig(resultType);
            if (!"true".equals(def)) continue;
            packageContext.setDefaultResultType(name);
        }
    }

    protected Class verifyResultType(String className, Location loc) {
        try {
            return this.objectFactory.getClassInstance(className);
        }
        catch (ClassNotFoundException e) {
            LOG.warn((Object)("Result class [" + className + "] doesn't exist (ClassNotFoundException) at " + loc.toString() + ", ignoring"), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.warn((Object)("Result class [" + className + "] doesn't exist (NoClassDefFoundError) at " + loc.toString() + ", ignoring"), (Throwable)e);
        }
        return null;
    }

    protected List buildInterceptorList(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList interceptorList = new ArrayList();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element)) continue;
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.valueOf(abstractVal);
        String name = TextUtils.noNull(packageElement.getAttribute("name"));
        String namespace = TextUtils.noNull(packageElement.getAttribute("namespace"));
        if (TextUtils.stringSet(packageElement.getAttribute("externalReferenceResolver"))) {
            throw new ConfigurationException("The 'externalReferenceResolver' attribute has been removed.  Please use a custom ObjectFactory or Interceptor.", (Object)packageElement);
        }
        PackageConfig cfg = null;
        if (!TextUtils.stringSet(TextUtils.noNull(parent))) {
            cfg = new PackageConfig(name, namespace, isAbstract);
        } else {
            List parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent);
            if (parents.size() <= 0) {
                LOG.error((Object)("Unable to find parent packages " + parent));
                cfg = new PackageConfig(name, namespace, isAbstract);
            } else {
                cfg = new PackageConfig(name, namespace, isAbstract, parents);
            }
        }
        if (cfg != null) {
            cfg.setLocation(DomHelper.getLocationObject(packageElement));
        }
        return cfg;
    }

    protected Map buildResults(Element element, PackageConfig packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        LinkedHashMap<String, ResultConfig> results = new LinkedHashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element)) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (!TextUtils.stringSet(resultName)) {
                resultName = "success";
            }
            if (!TextUtils.stringSet(resultType) && !TextUtils.stringSet(resultType = packageContext.getFullDefaultResultType())) {
                throw new ConfigurationException("No result type specified for result named '" + resultName + "', perhaps the parent package does not specify the result type?", (Object)resultElement);
            }
            ResultTypeConfig config = packageContext.getAllResultTypeConfigs().get(resultType);
            if (config == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'", (Object)resultElement);
            }
            String resultClass = config.getClazz();
            if (resultClass == null) {
                throw new ConfigurationException("Result type '" + resultType + "' is invalid");
            }
            LinkedHashMap<String, String> resultParams = XmlHelper.getParams(resultElement);
            if (resultParams.size() == 0 && resultElement.getChildNodes().getLength() >= 1) {
                resultParams = new LinkedHashMap<String, String>();
                String paramName = config.getDefaultResultParam();
                if (paramName != null) {
                    StringBuffer paramValue = new StringBuffer();
                    for (int j = 0; j < resultElement.getChildNodes().getLength(); ++j) {
                        String val;
                        if (resultElement.getChildNodes().item(j).getNodeType() != 3 || (val = resultElement.getChildNodes().item(j).getNodeValue()) == null) continue;
                        paramValue.append(val);
                    }
                    String val = paramValue.toString().trim();
                    if (val.length() > 0) {
                        resultParams.put(paramName, val);
                    }
                } else {
                    LOG.warn((Object)("no default parameter defined for result of type " + config.getName()));
                }
            }
            LinkedHashMap params = new LinkedHashMap();
            Map configParams = config.getParams();
            if (configParams != null) {
                params.putAll(configParams);
            }
            params.putAll(resultParams);
            ResultConfig resultConfig = new ResultConfig(resultName, resultClass, params);
            resultConfig.setLocation(DomHelper.getLocationObject(element));
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    protected List buildExceptionMappings(Element element, PackageConfig packageContext) {
        NodeList exceptionMappingEls = element.getElementsByTagName("exception-mapping");
        ArrayList<ExceptionMappingConfig> exceptionMappings = new ArrayList<ExceptionMappingConfig>();
        for (int i = 0; i < exceptionMappingEls.getLength(); ++i) {
            Element ehElement = (Element)exceptionMappingEls.item(i);
            if (!ehElement.getParentNode().equals(element)) continue;
            String emName = ehElement.getAttribute("name");
            String exceptionClassName = ehElement.getAttribute("exception");
            String exceptionResult = ehElement.getAttribute("result");
            Map params = XmlHelper.getParams(ehElement);
            if (!TextUtils.stringSet(emName)) {
                emName = exceptionResult;
            }
            ExceptionMappingConfig ehConfig = new ExceptionMappingConfig(emName, exceptionClassName, exceptionResult, params);
            ehConfig.setLocation(DomHelper.getLocationObject(ehElement));
            exceptionMappings.add(ehConfig);
        }
        return exceptionMappings;
    }

    protected void loadDefaultInterceptorRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadDefaultActionRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-action-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultActionRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected void loadDefaultClassRef(PackageConfig packageContext, Element element) {
        NodeList defaultClassRefList = element.getElementsByTagName("default-class-ref");
        if (defaultClassRefList.getLength() > 0) {
            Element defaultClassRefElement = (Element)defaultClassRefList.item(0);
            packageContext.setDefaultClassRef(defaultClassRefElement.getAttribute("class"));
        }
    }

    protected void loadGobalExceptionMappings(PackageConfig packageContext, Element packageElement) {
        NodeList globalExceptionMappingList = packageElement.getElementsByTagName("global-exception-mappings");
        if (globalExceptionMappingList.getLength() > 0) {
            Element globalExceptionMappingElement = (Element)globalExceptionMappingList.item(0);
            List exceptionMappings = this.buildExceptionMappings(globalExceptionMappingElement, packageContext);
            packageContext.addGlobalExceptionMappingConfigs(exceptionMappings);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig config = new InterceptorStackConfig(name);
        config.setLocation(DomHelper.getLocationObject(element));
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config;
    }

    protected void loadInterceptorStacks(Element element, PackageConfig context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            Map params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = new InterceptorConfig(name, className, params);
            config.setLocation(DomHelper.getLocationObject(interceptorElement));
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    private List loadConfigurationFiles(String fileName, Element includeElement) {
        ArrayList<Document> docs = new ArrayList<Document>();
        if (!this.includedFileNames.contains(fileName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loading action configurations from: " + fileName));
            }
            this.includedFileNames.add(fileName);
            Iterator<URL> urls = null;
            Document doc = null;
            InputStream is = null;
            IOException ioException = null;
            try {
                urls = this.getConfigurationUrls(fileName);
            }
            catch (IOException ex) {
                ioException = ex;
            }
            if (urls == null || !urls.hasNext()) {
                if (this.errorIfMissing) {
                    throw new ConfigurationException("Could not open files of the name " + fileName, ioException);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Unable to locate configuration files of the name " + fileName + ", skipping"));
                }
                return docs;
            }
            URL url = null;
            while (urls.hasNext()) {
                try {
                    url = urls.next();
                    is = FileManager.loadFile(url);
                    InputSource in = new InputSource(is);
                    in.setSystemId(url.toString());
                    doc = DomHelper.parse(in, this.dtdMappings);
                }
                catch (XWorkException e) {
                    if (includeElement != null) {
                        throw new ConfigurationException(e, (Object)includeElement);
                    }
                    throw new ConfigurationException(e);
                }
                catch (Exception e) {
                    String s = "Caught exception while loading file " + fileName;
                    throw new ConfigurationException(s, e, includeElement);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)"Unable to close input stream", (Throwable)e);
                        }
                    }
                }
                Element rootElement = doc.getDocumentElement();
                NodeList children = rootElement.getChildNodes();
                int childSize = children.getLength();
                for (int i = 0; i < childSize; ++i) {
                    Element child;
                    String nodeName;
                    Node childNode = children.item(i);
                    if (!(childNode instanceof Element) || !(nodeName = (child = (Element)childNode).getNodeName()).equals("include")) continue;
                    String includeFileName = child.getAttribute("file");
                    docs.addAll(this.loadConfigurationFiles(includeFileName, child));
                }
                docs.add(doc);
                this.loadedFileUrls.add(url.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Loaded action configuration from: " + fileName));
            }
        }
        return docs;
    }

    protected Iterator<URL> getConfigurationUrls(String fileName) throws IOException {
        return ClassLoaderUtil.getResources(fileName, XmlConfigurationProvider.class, false);
    }

    protected void loadExtraConfiguration(Document doc) {
    }

    private List lookupInterceptorReference(PackageConfig context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        Map refParams = XmlHelper.getParams(interceptorRefElement);
        Location loc = LocationUtils.getLocation(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams, loc, this.objectFactory);
    }
}

