/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Preparable;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.interceptor.PrefixMethodInvocationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PrepareInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -5216969014510719786L;
    private static final Log _log = LogFactory.getLog(PrepareInterceptor.class);
    private static final String PREPARE_PREFIX = "prepare";
    private static final String ALT_PREPARE_PREFIX = "prepareDo";
    private boolean alwaysInvokePrepare = true;

    public void setAlwaysInvokePrepare(String alwaysInvokePrepare) {
        this.alwaysInvokePrepare = Boolean.parseBoolean(alwaysInvokePrepare);
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (action instanceof Preparable) {
            try {
                PrefixMethodInvocationUtil.invokePrefixMethod(invocation, new String[]{PREPARE_PREFIX, ALT_PREPARE_PREFIX});
            }
            catch (Exception e) {
                _log.warn((Object)"an exception occured while trying to execute prefixed method", (Throwable)e);
            }
            if (this.alwaysInvokePrepare) {
                ((Preparable)action).prepare();
            }
        }
        return invocation.invoke();
    }
}

