/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.XWorkConverter;
import java.util.HashSet;
import java.util.Set;

public class TextParseUtil {
    public static String translateVariables(String expression, ValueStack stack) {
        return TextParseUtil.translateVariables('$', expression, stack, String.class, null).toString();
    }

    public static String translateVariables(String expression, ValueStack stack, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables('$', expression, stack, String.class, evaluator).toString();
    }

    public static String translateVariables(char open, String expression, ValueStack stack) {
        return TextParseUtil.translateVariables(open, expression, stack, String.class, null).toString();
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType) {
        return TextParseUtil.translateVariables(open, expression, stack, asType, null);
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator) {
        Object result = expression;
        while (true) {
            int start = expression.indexOf(open + "{");
            int length = expression.length();
            int x = start + 2;
            int count = 1;
            while (start != -1 && x < length && count != 0) {
                char c;
                if ((c = expression.charAt(x++)) == '{') {
                    ++count;
                    continue;
                }
                if (c != '}') continue;
                --count;
            }
            int end = x - 1;
            if (start == -1 || end == -1 || count != 0) break;
            String var = expression.substring(start + 2, end);
            Object o = stack.findValue(var, asType);
            if (evaluator != null) {
                o = evaluator.evaluate(o);
            }
            String left = expression.substring(0, start);
            String right = expression.substring(end + 1);
            if (o != null) {
                result = TextUtils.stringSet(left) ? left + o : o;
                if (TextUtils.stringSet(right)) {
                    result = result + right;
                }
                expression = left + o + right;
                continue;
            }
            result = left + right;
            expression = left + right;
        }
        return XWorkConverter.getInstance().convertValue(stack.getContext(), result, asType);
    }

    public static Set commaDelimitedStringToSet(String s) {
        HashSet<String> set = new HashSet<String>();
        String[] split = s.split(",");
        for (int i = 0; i < split.length; ++i) {
            String trimmed = split[i].trim();
            if (trimmed.length() <= 0) continue;
            set.add(trimmed);
        }
        return set;
    }

    public static interface ParsedValueEvaluator {
        public Object evaluate(Object var1);
    }
}

