/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorFactory;
import com.opensymphony.xwork2.validator.annotations.ConversionErrorFieldValidator;
import com.opensymphony.xwork2.validator.annotations.CustomValidator;
import com.opensymphony.xwork2.validator.annotations.DateRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.DoubleRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.ExpressionValidator;
import com.opensymphony.xwork2.validator.annotations.FieldExpressionValidator;
import com.opensymphony.xwork2.validator.annotations.IntRangeFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.StringLengthFieldValidator;
import com.opensymphony.xwork2.validator.annotations.StringRegexValidator;
import com.opensymphony.xwork2.validator.annotations.UrlValidator;
import com.opensymphony.xwork2.validator.annotations.Validation;
import com.opensymphony.xwork2.validator.annotations.ValidationParameter;
import com.opensymphony.xwork2.validator.annotations.Validations;
import com.opensymphony.xwork2.validator.annotations.VisitorFieldValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationValidationConfigurationBuilder {
    private static final Pattern SETTER_PATTERN = Pattern.compile("set([A-Z][A-Za-z0-9]*)$");
    private static final Pattern GETTER_PATTERN = Pattern.compile("(get|is|has)([A-Z][A-Za-z0-9]*)$");

    private static List<ValidatorConfig> processAnnotations(Object o) {
        ArrayList<ValidatorConfig> result = new ArrayList<ValidatorConfig>();
        String fieldName = null;
        Annotation[] annotations = null;
        if (o instanceof Class) {
            Class clazz = (Class)o;
            annotations = clazz.getAnnotations();
        }
        if (o instanceof Method) {
            Method method = (Method)o;
            fieldName = AnnotationValidationConfigurationBuilder.resolvePropertyName(method);
            annotations = method.getAnnotations();
        }
        if (annotations != null) {
            for (Annotation a : annotations) {
                ValidatorConfig temp;
                Annotation v;
                if (a instanceof Validations) {
                    AnnotationValidationConfigurationBuilder.processValidationAnnotation(a, fieldName, result);
                }
                if (a instanceof Validation) {
                    v = (Validation)a;
                    if (v.validations() == null) continue;
                    for (Validations val : v.validations()) {
                        AnnotationValidationConfigurationBuilder.processValidationAnnotation(val, fieldName, result);
                    }
                    continue;
                }
                if (a instanceof ExpressionValidator) {
                    v = (ExpressionValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processExpressionValidatorAnnotation((ExpressionValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof CustomValidator) {
                    v = (CustomValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processCustomValidatorAnnotation((CustomValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof ConversionErrorFieldValidator) {
                    v = (ConversionErrorFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processConversionErrorFieldValidatorAnnotation((ConversionErrorFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof DateRangeFieldValidator) {
                    v = (DateRangeFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processDateRangeFieldValidatorAnnotation((DateRangeFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof EmailValidator) {
                    v = (EmailValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processEmailValidatorAnnotation((EmailValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof FieldExpressionValidator) {
                    v = (FieldExpressionValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processFieldExpressionValidatorAnnotation((FieldExpressionValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof IntRangeFieldValidator) {
                    v = (IntRangeFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processIntRangeFieldValidatorAnnotation((IntRangeFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof DoubleRangeFieldValidator) {
                    v = (DoubleRangeFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processDoubleRangeFieldValidatorAnnotation((DoubleRangeFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof RequiredFieldValidator) {
                    v = (RequiredFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processRequiredFieldValidatorAnnotation((RequiredFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof RequiredStringValidator) {
                    v = (RequiredStringValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processRequiredStringValidatorAnnotation((RequiredStringValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof StringLengthFieldValidator) {
                    v = (StringLengthFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processStringLengthFieldValidatorAnnotation((StringLengthFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof UrlValidator) {
                    v = (UrlValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processUrlValidatorAnnotation((UrlValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof VisitorFieldValidator) {
                    v = (VisitorFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processVisitorFieldValidatorAnnotation((VisitorFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (a instanceof RegexFieldValidator) {
                    v = (RegexFieldValidator)a;
                    temp = AnnotationValidationConfigurationBuilder.processRegexFieldValidatorAnnotation((RegexFieldValidator)v, fieldName);
                    if (temp == null) continue;
                    result.add(temp);
                    continue;
                }
                if (!(a instanceof StringRegexValidator) || (temp = AnnotationValidationConfigurationBuilder.processStringRegexValidatorAnnotation((StringRegexValidator)(v = (StringRegexValidator)a), fieldName)) == null) continue;
                result.add(temp);
            }
        }
        return result;
    }

    private static void processValidationAnnotation(Annotation a, String fieldName, List<ValidatorConfig> result) {
        VisitorFieldValidator[] vfv;
        UrlValidator[] uv;
        StringRegexValidator[] srv;
        StringLengthFieldValidator[] slfv;
        RequiredStringValidator[] rsv;
        RequiredFieldValidator[] rv;
        RegexFieldValidator[] rfv;
        IntRangeFieldValidator[] irfv;
        FieldExpressionValidator[] fev;
        EmailValidator[] emv;
        DateRangeFieldValidator[] drfv;
        ConversionErrorFieldValidator[] cef;
        ExpressionValidator[] ev;
        Validations validations = (Validations)a;
        CustomValidator[] cv = validations.customValidators();
        if (cv != null) {
            for (CustomValidator v : cv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processCustomValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((ev = validations.expressions()) != null) {
            for (ExpressionValidator v : ev) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processExpressionValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((cef = validations.conversionErrorFields()) != null) {
            for (ConversionErrorFieldValidator v : cef) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processConversionErrorFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((drfv = validations.dateRangeFields()) != null) {
            for (DateRangeFieldValidator v : drfv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processDateRangeFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((emv = validations.emails()) != null) {
            for (EmailValidator v : emv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processEmailValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((fev = validations.fieldExpressions()) != null) {
            for (FieldExpressionValidator v : fev) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processFieldExpressionValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((irfv = validations.intRangeFields()) != null) {
            for (IntRangeFieldValidator v : irfv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processIntRangeFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((rfv = validations.regexFields()) != null) {
            for (RegexFieldValidator v : rfv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processRegexFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((rv = validations.requiredFields()) != null) {
            for (RequiredFieldValidator v : rv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processRequiredFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((rsv = validations.requiredStrings()) != null) {
            for (RequiredStringValidator v : rsv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processRequiredStringValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((slfv = validations.stringLengthFields()) != null) {
            for (StringLengthFieldValidator v : slfv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processStringLengthFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((srv = validations.stringRegexs()) != null) {
            for (StringRegexValidator v : srv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processStringRegexValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((uv = validations.urls()) != null) {
            for (UrlValidator v : uv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processUrlValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
        if ((vfv = validations.visitorFields()) != null) {
            for (VisitorFieldValidator v : vfv) {
                ValidatorConfig temp = AnnotationValidationConfigurationBuilder.processVisitorFieldValidatorAnnotation(v, fieldName);
                if (temp == null) continue;
                result.add(temp);
            }
        }
    }

    private static ValidatorConfig processExpressionValidatorAnnotation(ExpressionValidator v, String fieldName) {
        String validatorType = "expression";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        }
        params.put("expression", v.expression());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processCustomValidatorAnnotation(CustomValidator v, String fieldName) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        String validatorType = v.type();
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidationParameter[] recursedAnnotations = v.parameters();
        if (recursedAnnotations != null) {
            for (ValidationParameter a2 : recursedAnnotations) {
                if (!(a2 instanceof ValidationParameter)) continue;
                ValidationParameter parameter = a2;
                String parameterName = parameter.name();
                String parameterValue = parameter.value();
                params.put(parameterName, parameterValue);
            }
        }
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processStringRegexValidatorAnnotation(StringRegexValidator v, String fieldName) {
        String validatorType = "stringregex";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        params.put("caseSensitive", v.caseSensitive());
        params.put("regex", v.regex());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processRegexFieldValidatorAnnotation(RegexFieldValidator v, String fieldName) {
        String validatorType = "regex";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        params.put("expression", v.expression());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processVisitorFieldValidatorAnnotation(VisitorFieldValidator v, String fieldName) {
        String validatorType = "visitor";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        params.put("context", v.context());
        params.put("appendPrefix", v.appendPrefix());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processUrlValidatorAnnotation(UrlValidator v, String fieldName) {
        String validatorType = "url";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processStringLengthFieldValidatorAnnotation(StringLengthFieldValidator v, String fieldName) {
        String validatorType = "stringlength";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        if (v.maxLength() != null && v.maxLength().length() > 0) {
            params.put("maxLength", v.maxLength());
        }
        if (v.minLength() != null && v.minLength().length() > 0) {
            params.put("minLength", v.minLength());
        }
        params.put("trim", v.trim());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static Date parseDateString(String value) {
        SimpleDateFormat d1 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 1, Locale.getDefault());
        SimpleDateFormat d2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, Locale.getDefault());
        SimpleDateFormat d3 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());
        SimpleDateFormat[] dfs = new SimpleDateFormat[]{d1, d2, d3};
        SimpleDateFormat df = null;
        for (int i = 0; i < dfs.length; ++i) {
            try {
                Date check = dfs[i].parse(value);
                df = dfs[i];
                if (check == null) continue;
                return check;
            }
            catch (ParseException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    private static ValidatorConfig processRequiredStringValidatorAnnotation(RequiredStringValidator v, String fieldName) {
        String validatorType = "requiredstring";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        params.put("trim", v.trim());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processRequiredFieldValidatorAnnotation(RequiredFieldValidator v, String fieldName) {
        String validatorType = "required";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processIntRangeFieldValidatorAnnotation(IntRangeFieldValidator v, String fieldName) {
        String validatorType = "int";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        if (v.min() != null && v.min().length() > 0) {
            params.put("min", v.min());
        }
        if (v.max() != null && v.max().length() > 0) {
            params.put("max", v.max());
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processDoubleRangeFieldValidatorAnnotation(DoubleRangeFieldValidator v, String fieldName) {
        String validatorType = "double";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        if (v.minInclusive() != null && v.minInclusive().length() > 0) {
            params.put("minInclusive", v.minInclusive());
        }
        if (v.maxInclusive() != null && v.maxInclusive().length() > 0) {
            params.put("maxInclusive", v.maxInclusive());
        }
        if (v.minExclusive() != null && v.minExclusive().length() > 0) {
            params.put("minExclusive", v.minExclusive());
        }
        if (v.maxExclusive() != null && v.maxExclusive().length() > 0) {
            params.put("maxExclusive", v.maxExclusive());
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processFieldExpressionValidatorAnnotation(FieldExpressionValidator v, String fieldName) {
        String validatorType = "fieldexpression";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        params.put("expression", v.expression());
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processEmailValidatorAnnotation(EmailValidator v, String fieldName) {
        String validatorType = "email";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processDateRangeFieldValidatorAnnotation(DateRangeFieldValidator v, String fieldName) {
        String validatorType = "date";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        if (v.min() != null && v.min().length() > 0) {
            params.put("min", AnnotationValidationConfigurationBuilder.parseDateString(v.min()));
        }
        if (v.max() != null && v.max().length() > 0) {
            params.put("max", AnnotationValidationConfigurationBuilder.parseDateString(v.max()));
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    private static ValidatorConfig processConversionErrorFieldValidatorAnnotation(ConversionErrorFieldValidator v, String fieldName) {
        String validatorType = "conversion";
        HashMap<String, String> params = new HashMap<String, String>();
        if (fieldName != null) {
            params.put("fieldName", fieldName);
        } else if (v.fieldName() != null && v.fieldName().length() > 0) {
            params.put("fieldName", v.fieldName());
        }
        ValidatorFactory.lookupRegisteredValidatorType(validatorType);
        ValidatorConfig vCfg = new ValidatorConfig(validatorType, params);
        vCfg.setShortCircuit(v.shortCircuit());
        vCfg.setDefaultMessage(v.message());
        String key = v.key();
        if (key != null && key.trim().length() > 0) {
            vCfg.setMessageKey(key);
        }
        return vCfg;
    }

    public static List<ValidatorConfig> buildAnnotationClassValidatorConfigs(Class aClass) {
        Method[] methods;
        ArrayList<ValidatorConfig> result = new ArrayList<ValidatorConfig>();
        List<ValidatorConfig> temp = AnnotationValidationConfigurationBuilder.processAnnotations(aClass);
        if (temp != null) {
            result.addAll(temp);
        }
        if ((methods = aClass.getDeclaredMethods()) != null) {
            for (Method method : methods) {
                temp = AnnotationValidationConfigurationBuilder.processAnnotations(method);
                if (temp == null) continue;
                result.addAll(temp);
            }
        }
        return result;
    }

    public static String resolvePropertyName(Method method) {
        Matcher matcher = SETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 1) {
            String raw = matcher.group(1);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        matcher = GETTER_PATTERN.matcher(method.getName());
        if (matcher.matches() && method.getParameterTypes().length == 0) {
            String raw = matcher.group(2);
            return raw.substring(0, 1).toLowerCase() + raw.substring(1);
        }
        return null;
    }
}

