/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.atompub.abdera;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.apache.chemistry.BaseType;
import org.apache.chemistry.CMIS;
import org.apache.chemistry.CMISRuntimeException;
import org.apache.chemistry.PropertyDefinition;
import org.apache.chemistry.PropertyType;
import org.apache.chemistry.Repository;
import org.apache.chemistry.Type;
import org.apache.chemistry.atompub.ValueAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesElement
extends ExtensibleElementWrapper {
    protected final Repository repository;

    public PropertiesElement(Element internal, Repository repository) {
        super(internal);
        this.repository = repository;
    }

    public PropertiesElement(Factory factory) {
        super(factory, CMIS.PROPERTIES);
        this.repository = null;
    }

    public Map<String, Serializable> getProperties(String typeId) {
        Object value;
        HashMap raw = new HashMap();
        HashMap<String, ValueAdapter> adapters = new HashMap<String, ValueAdapter>();
        for (Element element : this.getElements()) {
            String name;
            ValueAdapter va = ValueAdapter.getAdapter(element.getQName());
            if (va == null) continue;
            String pdid = element.getAttributeValue(CMIS.PDID);
            boolean buggyCompat = false;
            if (pdid == null && "ObjectTypeId".equals(name = element.getAttributeValue(new QName("http://docs.oasis-open.org/ns/cmis/core/200908/", "name")))) {
                pdid = "cmis:objectTypeId";
                buggyCompat = true;
            }
            adapters.put(pdid, va);
            LinkedList<Serializable> list = new LinkedList<Serializable>();
            for (Element el : element.getElements()) {
                if (!el.getQName().equals(CMIS.VALUE)) continue;
                value = va.readValue(el.getText());
                if (buggyCompat && "document".equals(value)) {
                    value = BaseType.DOCUMENT.getId();
                }
                list.add((Serializable)value);
                if (!pdid.equals("cmis:objectTypeId")) continue;
                String tid = (String)value;
                if (tid == null || typeId != null && !tid.equals(typeId)) {
                    throw new CMISRuntimeException("Invalid type: " + tid);
                }
                typeId = tid;
            }
            raw.put(pdid, list);
        }
        if (typeId == null) {
            throw new RuntimeException("Invalid object with no cmis:objectTypeId");
        }
        Type type = this.repository.getType(typeId);
        if (type == null) {
            throw new RuntimeException("Unknown type: " + typeId);
        }
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        for (Map.Entry e : raw.entrySet()) {
            String name = (String)e.getKey();
            PropertyDefinition pd = type.getPropertyDefinition(name);
            if (pd == null) {
                throw new RuntimeException("Illegal property: " + name + " for type: " + typeId);
            }
            ValueAdapter va = (ValueAdapter)adapters.get(name);
            if (va.getPropertyType() != pd.getType()) {
                throw new RuntimeException("Property: " + name + " has type: " + typeId + " but used element: " + va.getPropertyQName());
            }
            List list = (List)e.getValue();
            if (pd.isMultiValued()) {
                value = list.toArray(va.createArray(list.size()));
            } else if (list.isEmpty()) {
                value = null;
            } else if (list.size() == 1) {
                value = (Serializable)list.get(0);
            } else {
                throw new RuntimeException("Property: " + name + " for type: " + typeId + " cannot have multi-values: " + list);
            }
            properties.put(name, (Serializable)value);
        }
        return properties;
    }

    public void setProperties(Map<String, Serializable> values, Type type) {
        if (type != null) {
            for (PropertyDefinition propertyDefinition : type.getPropertyDefinitions()) {
                this.setProperty(values.get(propertyDefinition.getId()), propertyDefinition);
            }
        } else {
            for (Map.Entry<String, Serializable> entry : values.entrySet()) {
                String key = entry.getKey();
                Serializable value = entry.getValue();
                PropertyType propertyType = PropertiesElement.guessType(key, value);
                this.setProperty(key, value, propertyType);
            }
        }
    }

    public void setProperty(Serializable value, PropertyDefinition propertyDefinition) {
        String displayName;
        if (value == null) {
            return;
        }
        QName qname = PropertiesElement.propertyQName(propertyDefinition.getType());
        List<String> values = PropertiesElement.getStringsForValue(value, propertyDefinition.getType(), propertyDefinition.isMultiValued());
        ExtensibleElement el = (ExtensibleElement)this.addExtension(qname);
        el.setAttributeValue(CMIS.PDID, propertyDefinition.getId());
        String localName = propertyDefinition.getLocalName();
        if (localName != null) {
            el.setAttributeValue(CMIS.LOCAL_NAME_NONS, localName);
        }
        if ((displayName = propertyDefinition.getDisplayName()) != null) {
            el.setAttributeValue(CMIS.DISPLAY_NAME_NONS, displayName);
        }
        for (String s : values) {
            Element val = el.addExtension(CMIS.VALUE);
            val.setText(s);
        }
    }

    public void setProperty(String key, Serializable value, PropertyType propertyType) {
        if (value == null) {
            return;
        }
        QName qname = PropertiesElement.propertyQName(propertyType);
        List<String> values = PropertiesElement.getStringsForValue(value, propertyType, value.getClass().isArray());
        ExtensibleElement el = (ExtensibleElement)this.addExtension(qname);
        el.setAttributeValue(CMIS.PDID, key);
        for (String s : values) {
            Element val = el.addExtension(CMIS.VALUE);
            val.setText(s);
        }
    }

    public static List<String> getStringsForValue(Serializable value, PropertyType propertyType, boolean multi) {
        List<String> values = null;
        if (multi) {
            if (value.getClass().isArray()) {
                value = (Serializable)((Object)Arrays.asList((Serializable[])value));
            }
            if (value instanceof List) {
                values = new ArrayList<String>(((List)((Object)value)).size());
            } else {
                return null;
            }
        }
        switch (propertyType.ordinal()) {
            case 1: 
            case 7: {
                if (multi) {
                    values.addAll((List)((Object)value));
                    break;
                }
                values = Collections.singletonList((String)((Object)value));
                break;
            }
            case 2: {
                if (multi) {
                    for (BigDecimal v : (List)((Object)value)) {
                        values.add(v.toString());
                    }
                    break;
                }
                values = Collections.singletonList(((BigDecimal)value).toString());
                break;
            }
            case 3: {
                if (multi) {
                    for (Number v : (List)((Object)value)) {
                        values.add(v.toString());
                    }
                    break;
                }
                values = Collections.singletonList(((Number)value).toString());
                break;
            }
            case 4: {
                if (multi) {
                    for (Boolean v : (List)((Object)value)) {
                        values.add(v.toString());
                    }
                    break;
                }
                values = Collections.singletonList(((Boolean)value).toString());
                break;
            }
            case 5: {
                if (multi) {
                    for (Calendar v : (List)((Object)value)) {
                        values.add(PropertiesElement.calendarString(v));
                    }
                    break;
                }
                values = Collections.singletonList(PropertiesElement.calendarString((Calendar)value));
                break;
            }
            case 6: {
                throw new UnsupportedOperationException(propertyType.toString());
            }
            case 8: {
                throw new UnsupportedOperationException(propertyType.toString());
            }
            default: {
                throw new UnsupportedOperationException(propertyType.toString());
            }
        }
        return values;
    }

    protected static QName propertyQName(PropertyType propertyType) {
        switch (propertyType.ordinal()) {
            case 1: {
                return CMIS.PROPERTY_STRING;
            }
            case 2: {
                return CMIS.PROPERTY_DECIMAL;
            }
            case 3: {
                return CMIS.PROPERTY_INTEGER;
            }
            case 4: {
                return CMIS.PROPERTY_BOOLEAN;
            }
            case 5: {
                return CMIS.PROPERTY_DATETIME;
            }
            case 7: {
                return CMIS.PROPERTY_ID;
            }
            case 6: {
                return CMIS.PROPERTY_URI;
            }
            case 8: {
                return CMIS.PROPERTY_HTML;
            }
        }
        throw new UnsupportedOperationException(propertyType.toString());
    }

    protected static PropertyType guessType(String key, Serializable value) {
        for (String n : Arrays.asList("cmis:objectId", "cmis:objectTypeId", "cmis:baseTypeId", "cmis:versionSeriesId", "cmis:versionSeriesCheckedOutId", "cmis:parentId", "cmis:sourceId", "cmis:targetId")) {
            if (!key.toUpperCase().endsWith(n.toUpperCase())) continue;
            return PropertyType.ID;
        }
        if (value instanceof String) {
            return PropertyType.STRING;
        }
        if (value instanceof BigDecimal) {
            return PropertyType.DECIMAL;
        }
        if (value instanceof Number) {
            return PropertyType.INTEGER;
        }
        if (value instanceof Boolean) {
            return PropertyType.BOOLEAN;
        }
        if (value instanceof Calendar) {
            return PropertyType.DATETIME;
        }
        return PropertyType.STRING;
    }

    protected static String calendarString(Calendar cal) {
        char sign;
        int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
        if (offset < 0) {
            offset = -offset;
            sign = '-';
        } else {
            sign = '+';
        }
        return String.format("%04d-%02d-%02dT%02d:%02d:%02d%c%02d:%02d", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), Character.valueOf(sign), offset / 60, offset % 60);
    }
}

