/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.Connection;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.RelationshipDirection;
import org.apache.chemistry.ReturnVersion;
import org.apache.chemistry.SPI;
import org.apache.chemistry.Unfiling;
import org.apache.chemistry.VersioningState;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleDocument;
import org.apache.chemistry.impl.simple.SimpleFolder;
import org.apache.chemistry.impl.simple.SimpleObject;
import org.apache.chemistry.impl.simple.SimpleObjectEntry;
import org.apache.chemistry.impl.simple.SimplePolicy;
import org.apache.chemistry.impl.simple.SimpleRelationship;
import org.apache.chemistry.impl.simple.SimpleRepository;
import org.apache.chemistry.property.PropertyDefinition;
import org.apache.chemistry.repository.Repository;
import org.apache.chemistry.type.BaseType;
import org.apache.chemistry.type.ContentStreamPresence;
import org.apache.chemistry.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConnection
implements Connection,
SPI {
    protected final SimpleRepository repository;
    protected final SimpleFolder rootFolder;

    public SimpleConnection(SimpleRepository repository) {
        this.repository = repository;
        this.rootFolder = (SimpleFolder)this.getObject(repository.getInfo().getRootFolderId(), ReturnVersion.THIS);
    }

    public Connection getConnection() {
        return this;
    }

    public SPI getSPI() {
        return this;
    }

    public void close() {
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Folder getRootFolder() {
        return this.rootFolder;
    }

    public Document newDocument(String typeId, ObjectEntry folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.DOCUMENT) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(typeId);
        if (folder != null) {
            data.put("ParentId", folder.getId());
        }
        return new SimpleDocument(data, this);
    }

    public Folder newFolder(String typeId, ObjectEntry folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.FOLDER) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(typeId);
        if (folder != null) {
            data.put("ParentId", folder.getId());
        }
        return new SimpleFolder(data, this);
    }

    public Relationship newRelationship(String typeId) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.RELATIONSHIP) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(typeId);
        return new SimpleRelationship(data, this);
    }

    public Policy newPolicy(String typeId, ObjectEntry folder) {
        Type type = this.repository.getType(typeId);
        if (type == null || type.getBaseType() != BaseType.POLICY) {
            throw new IllegalArgumentException(typeId);
        }
        SimpleData data = new SimpleData(typeId);
        if (folder != null) {
            data.put("ParentId", folder.getId());
        }
        return new SimplePolicy(data, this);
    }

    protected void saveObject(SimpleObject object) {
        SimpleData data = object.data;
        byte[] contentBytes = object.contentBytes;
        HashMap<String, Object> update = new HashMap<String, Object>();
        String id = this.repository.generateId();
        update.put("ObjectId", id);
        Type type = object.getType();
        for (PropertyDefinition pd : type.getPropertyDefinitions()) {
            String name = pd.getName();
            if ("ObjectId".equals(name) || !pd.isRequired() || data.containsKey(name)) continue;
            if ("Name".equals(name)) {
                update.put("Name", id);
                continue;
            }
            if ("CreatedBy".equals(name)) {
                update.put("CreatedBy", "system");
                continue;
            }
            if ("CreationDate".equals(name)) {
                update.put("CreationDate", Calendar.getInstance());
                continue;
            }
            if ("LastModifiedBy".equals(name)) {
                update.put("LastModifiedBy", "system");
                continue;
            }
            if ("LastModificationDate".equals(name)) {
                update.put("LastModificationDate", Calendar.getInstance());
                continue;
            }
            if ("ContentStreamAllowed".equals(name)) {
                update.put("ContentStreamAllowed", "allowed");
                continue;
            }
            if ("IsLatestVersion".equals(name)) {
                update.put("IsLatestVersion", Boolean.TRUE);
                continue;
            }
            if ("IsLatestMajorVersion".equals(name)) {
                update.put("IsLatestMajorVersion", Boolean.TRUE);
                continue;
            }
            if ("IsVersionSeriesCheckedOut".equals(name)) {
                update.put("IsVersionSeriesCheckedOut", Boolean.FALSE);
                continue;
            }
            if ("VersionSeriesId".equals(name)) {
                update.put("VersionSeriesId", id);
                continue;
            }
            if ("VersionLabel".equals(name)) {
                update.put("VersionLabel", "1.0");
                continue;
            }
            throw new RuntimeException("Missing property: " + name);
        }
        if (type.getContentStreamAllowed() == ContentStreamPresence.REQUIRED && contentBytes == null) {
            throw new RuntimeException("Content stream required");
        }
        data.putAll(update);
        this.repository.datas.put(id, data);
        update.put("ContentStreamLength", contentBytes == null ? null : Integer.valueOf(contentBytes.length));
        if (contentBytes == null) {
            this.repository.contentBytes.remove(id);
        } else {
            this.repository.contentBytes.put(id, contentBytes);
        }
        String parentId = (String)data.get("ParentId");
        if (type.getBaseType() == BaseType.FOLDER) {
            this.repository.children.put(id, this.repository.newSet());
        } else {
            data.remove("ParentId");
        }
        if (parentId != null) {
            Set<String> parents = this.repository.newSet();
            parents.add(parentId);
            this.repository.parents.put(id, parents);
            this.repository.children.get(parentId).add(id);
        }
    }

    public List<ObjectEntry> getDescendants(String folderId, BaseType type, int depth, String filter, boolean includeAllowableActions, boolean includeRelationships, String orderBy) {
        throw new UnsupportedOperationException();
    }

    public List<ObjectEntry> getChildren(String folderId, BaseType type, String filter, boolean includeAllowableActions, boolean includeRelationships, int maxItems, int skipCount, String orderBy, boolean[] hasMoreItems) {
        int toIndex;
        Set<String> ids = this.repository.children.get(folderId);
        ArrayList<SimpleObjectEntry> all = new ArrayList<SimpleObjectEntry>(ids.size());
        for (String id : ids) {
            SimpleData data = this.repository.datas.get(id);
            all.add(new SimpleObjectEntry(data, this));
        }
        int fromIndex = skipCount;
        if (fromIndex < 0 || fromIndex > all.size()) {
            hasMoreItems[0] = false;
            return Collections.emptyList();
        }
        if (maxItems == 0) {
            maxItems = all.size();
        }
        if ((toIndex = skipCount + maxItems) > all.size()) {
            toIndex = all.size();
        }
        hasMoreItems[0] = toIndex < all.size();
        return all.subList(fromIndex, toIndex);
    }

    public List<ObjectEntry> getFolderParent(String folderId, String filter, boolean includeAllowableActions, boolean includeRelationships, boolean returnToRoot) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getObjectParents(String objectId, String filter, boolean includeAllowableActions, boolean includeRelationships) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getCheckedoutDocuments(String folderId, String filter, boolean includeAllowableActions, boolean includeRelationships, int maxItems, int skipCount, boolean[] hasMoreItems) {
        throw new UnsupportedOperationException();
    }

    public String createDocument(String typeId, Map<String, Serializable> properties, String folderId, ContentStream contentStream, VersioningState versioningState) {
        throw new UnsupportedOperationException();
    }

    public String createFolder(String typeId, Map<String, Serializable> properties, String folderId) {
        throw new UnsupportedOperationException();
    }

    public String createRelationship(String typeId, Map<String, Serializable> properties, String sourceId, String targetId) {
        throw new UnsupportedOperationException();
    }

    public String createPolicy(String typeId, Map<String, Serializable> properties, String folderId) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getAllowableActions(String objectId, String asUser) {
        throw new UnsupportedOperationException();
    }

    public ObjectEntry getProperties(String objectId, ReturnVersion returnVersion, String filter, boolean includeAllowableActions, boolean includeRelationships) {
        SimpleData data = this.repository.datas.get(objectId);
        if (data == null) {
            throw new RuntimeException("Not found: " + objectId);
        }
        return new SimpleObjectEntry(data, this);
    }

    public CMISObject getObject(String objectId, ReturnVersion returnVersion) {
        SimpleData data = this.repository.datas.get(objectId);
        if (data == null) {
            throw new RuntimeException("Not found: " + objectId);
        }
        String typeId = (String)data.get("ObjectTypeId");
        switch (this.repository.getType(typeId).getBaseType()) {
            case DOCUMENT: {
                return new SimpleDocument(data, this);
            }
            case FOLDER: {
                return new SimpleFolder(data, this);
            }
            case RELATIONSHIP: {
                return new SimpleRelationship(data, this);
            }
            case POLICY: {
                return new SimplePolicy(data, this);
            }
        }
        throw new RuntimeException();
    }

    public InputStream getContentStream(String documentId, int offset, int length) {
        byte[] bytes = this.repository.contentBytes.get(documentId);
        if (bytes == null) {
            return null;
        }
        if (length == -1) {
            length = bytes.length;
        }
        return new ByteArrayInputStream(bytes, offset, length);
    }

    public void setContentStream(String documentId, boolean overwrite, ContentStream contentStream) {
        throw new UnsupportedOperationException();
    }

    public void deleteContentStream(String documentId) {
        throw new UnsupportedOperationException();
    }

    public String updateProperties(String objectId, String changeToken, Map<String, Serializable> properties) {
        throw new UnsupportedOperationException();
    }

    public void moveObject(String objectId, String targetFolderId, String sourceFolderId) {
        throw new UnsupportedOperationException();
    }

    public void moveObject(ObjectEntry object, ObjectEntry targetFolder, ObjectEntry sourceFolder) {
        throw new UnsupportedOperationException();
    }

    public void deleteObject(String objectId) {
        throw new UnsupportedOperationException();
    }

    public void deleteObject(ObjectEntry object) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> deleteTree(String folderId, Unfiling unfiling, boolean continueOnFailure) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> deleteTree(ObjectEntry folder, Unfiling unfiling, boolean continueOnFailure) {
        throw new UnsupportedOperationException();
    }

    public void addObjectToFolder(String objectId, String folderId) {
        throw new UnsupportedOperationException();
    }

    public void addObjectToFolder(ObjectEntry object, ObjectEntry folder) {
        throw new UnsupportedOperationException();
    }

    public void removeObjectFromFolder(String objectId, String folderId) {
        throw new UnsupportedOperationException();
    }

    public void removeObjectFromFolder(ObjectEntry object, ObjectEntry folder) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> query(String statement, boolean searchAllVersions, boolean includeAllowableActions, boolean includeRelationships, int maxItems, int skipCount, boolean[] hasMoreItems) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> query(String statement, boolean searchAllVersions) {
        throw new UnsupportedOperationException();
    }

    public String checkOut(String documentId, boolean[] contentCopied) {
        throw new UnsupportedOperationException();
    }

    public CMISObject checkOut(ObjectEntry document) {
        throw new UnsupportedOperationException();
    }

    public void cancelCheckOut(String documentId) {
        throw new UnsupportedOperationException();
    }

    public void cancelCheckOut(ObjectEntry document) {
        throw new UnsupportedOperationException();
    }

    public String checkIn(String documentId, boolean major, Map<String, Serializable> properties, ContentStream contentStream, String comment) {
        throw new UnsupportedOperationException();
    }

    public CMISObject checkIn(ObjectEntry document, boolean major, String comment) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Serializable> getPropertiesOfLatestVersion(String versionSeriesId, boolean majorVersion, String filter) {
        throw new UnsupportedOperationException();
    }

    public CMISObject getLatestVersion(ObjectEntry document, boolean major) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAllVersions(String versionSeriesId, String filter) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAllVersions(ObjectEntry document, String filter) {
        throw new UnsupportedOperationException();
    }

    public void deleteAllVersions(String versionSeriesId) {
        throw new UnsupportedOperationException();
    }

    public void deleteAllVersions(ObjectEntry document) {
        throw new UnsupportedOperationException();
    }

    public List<ObjectEntry> getRelationships(String objectId, RelationshipDirection direction, String typeId, boolean includeSubRelationshipTypes, String filter, String includeAllowableActions, int maxItems, int skipCount, boolean[] hasMoreItems) {
        throw new UnsupportedOperationException();
    }

    public List<ObjectEntry> getRelationships(ObjectEntry object, RelationshipDirection direction, String typeId, boolean includeSubRelationshipTypes) {
        throw new UnsupportedOperationException();
    }

    public void applyPolicy(String policyId, String objectId) {
        throw new UnsupportedOperationException();
    }

    public void applyPolicy(Policy policy, ObjectEntry object) {
        throw new UnsupportedOperationException();
    }

    public void removePolicy(String policyId, String objectId) {
        throw new UnsupportedOperationException();
    }

    public void removePolicy(Policy policy, ObjectEntry object) {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getAppliedPolicies(String policyId, String filter) {
        throw new UnsupportedOperationException();
    }

    public Collection<Policy> getAppliedPolicies(ObjectEntry object) {
        throw new UnsupportedOperationException();
    }
}

