/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.chemistry.ContentStream;

public class SimpleContentStream
implements ContentStream {
    protected final String mimeType;
    protected final String filename;
    protected final URI uri;
    protected final byte[] bytes;
    protected final long length;

    public SimpleContentStream(byte[] bytes, String mimeType, String filename, URI uri) throws IOException {
        this.mimeType = mimeType;
        this.filename = filename;
        this.uri = uri;
        this.bytes = bytes;
        this.length = bytes.length;
    }

    public SimpleContentStream(InputStream stream, String mimeType, String filename, URI uri) throws IOException {
        this.mimeType = mimeType;
        this.filename = filename;
        this.uri = uri;
        this.bytes = SimpleContentStream.getBytes(stream);
        this.length = this.bytes.length;
    }

    protected static byte[] getBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((n = stream.read(buf)) != -1) {
            out.write(buf, 0, n);
        }
        return out.toByteArray();
    }

    public long getLength() {
        return this.length;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public URI getURI() {
        return this.uri;
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.bytes);
    }
}

