/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.chemistry.ContentStream;
import org.apache.chemistry.Document;
import org.apache.chemistry.impl.simple.SimpleConnection;
import org.apache.chemistry.impl.simple.SimpleContentStream;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleObject;
import org.apache.chemistry.type.ContentStreamPresence;

public class SimpleDocument
extends SimpleObject
implements Document {
    public SimpleDocument(SimpleData data, SimpleConnection connection) {
        super(data, connection);
    }

    public InputStream getStream() {
        if (this.contentBytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.contentBytes);
    }

    public ContentStream getContentStream() {
        if (this.contentBytes == null) {
            return null;
        }
        String mimeType = this.getString("ContentStreamMimeType");
        String filename = this.getString("ContentStreamFilename");
        URI uri = this.getURI("ContentStreamUri");
        try {
            return new SimpleContentStream(this.contentBytes, mimeType, filename, uri);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void setContentStream(ContentStream contentStream) throws IOException {
        ContentStreamPresence csa = this.getType().getContentStreamAllowed();
        if (csa == ContentStreamPresence.NOT_ALLOWED && contentStream != null) {
            throw new RuntimeException("Content stream not allowed");
        }
        if (csa == ContentStreamPresence.REQUIRED && contentStream == null) {
            throw new RuntimeException("Content stream required");
        }
        if (contentStream == null) {
            this._setValue("ContentStreamLength", null);
            this._setValue("ContentStreamMimeType", null);
            this._setValue("ContentStreamFilename", null);
            this._setValue("ContentStreamUri", null);
            this.contentBytes = null;
        } else {
            this._setValue("ContentStreamLength", Integer.valueOf((int)contentStream.getLength()));
            this._setValue("ContentStreamMimeType", (Serializable)((Object)contentStream.getMimeType()));
            this._setValue("ContentStreamFilename", (Serializable)((Object)contentStream.getFilename()));
            this._setValue("ContentStreamUri", contentStream.getURI());
            this.contentBytes = SimpleContentStream.getBytes(contentStream.getStream());
        }
    }
}

