/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.CMISObject;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.impl.simple.SimpleConnection;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleFolder;
import org.apache.chemistry.impl.simple.SimpleObjectEntry;
import org.apache.chemistry.impl.simple.SimplePropertyDefinition;
import org.apache.chemistry.impl.simple.SimpleRepository;
import org.apache.chemistry.type.BaseType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObject
extends SimpleObjectEntry
implements CMISObject {
    protected byte[] contentBytes;

    protected SimpleObject(SimpleData data, SimpleConnection connection) {
        super(data, connection);
    }

    @Override
    public Document getDocument() {
        if (this.getType().getBaseType() != BaseType.DOCUMENT) {
            throw new RuntimeException("Not a document: " + this.getId());
        }
        return (Document)this;
    }

    @Override
    public Folder getFolder() {
        if (this.getType().getBaseType() != BaseType.FOLDER) {
            throw new RuntimeException("Not a folder: " + this.getId());
        }
        return (Folder)this;
    }

    @Override
    public Relationship getRelationship() {
        if (this.getType().getBaseType() != BaseType.RELATIONSHIP) {
            throw new RuntimeException("Not a relationship: " + this.getId());
        }
        return (Relationship)this;
    }

    @Override
    public Policy getPolicy() {
        if (this.getType().getBaseType() != BaseType.POLICY) {
            throw new RuntimeException("Not a policy: " + this.getId());
        }
        return (Policy)this;
    }

    public Folder getParent() {
        Set<String> parents = this.connection.repository.parents.get(this.getId());
        if (parents == SimpleRepository.NO_PARENT) {
            return null;
        }
        if (parents.size() != 1) {
            throw new RuntimeException("Several parents for: " + this.getId());
        }
        String pid = parents.iterator().next();
        SimpleData data = this.connection.repository.datas.get(pid);
        return new SimpleFolder(data, this.connection);
    }

    public void setValue(String name, Serializable value) {
        SimplePropertyDefinition pd = (SimplePropertyDefinition)this.getType().getPropertyDefinition(name);
        if (pd == null) {
            throw new IllegalArgumentException(name);
        }
        String error = pd.validationError(value);
        if (error != null) {
            throw new RuntimeException("Property " + name + ": " + error);
        }
        this._setValue(name, value);
    }

    protected void _setValue(String name, Serializable value) {
        if (value == null) {
            this.data.remove(name);
        } else {
            this.data.put(name, value);
        }
    }

    public void setValues(Map<String, Serializable> values) {
        for (String name : values.keySet()) {
            this.setValue(name, values.get(name));
        }
    }

    public void save() {
        if (this.getId() == null) {
            this.connection.saveObject(this);
        }
    }

    public void setName(String name) {
        this.setValue("Name", (Serializable)((Object)name));
    }
}

