/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.Document;
import org.apache.chemistry.Folder;
import org.apache.chemistry.ObjectEntry;
import org.apache.chemistry.Policy;
import org.apache.chemistry.Relationship;
import org.apache.chemistry.impl.simple.SimpleConnection;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleDocument;
import org.apache.chemistry.impl.simple.SimpleFolder;
import org.apache.chemistry.impl.simple.SimplePolicy;
import org.apache.chemistry.impl.simple.SimpleProperty;
import org.apache.chemistry.impl.simple.SimpleRelationship;
import org.apache.chemistry.property.Property;
import org.apache.chemistry.property.PropertyDefinition;
import org.apache.chemistry.type.BaseType;
import org.apache.chemistry.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleObjectEntry
implements ObjectEntry {
    protected final SimpleData data;
    protected final SimpleConnection connection;

    protected SimpleObjectEntry(SimpleData data, SimpleConnection connection) {
        this.data = data;
        this.connection = connection;
    }

    public Type getType() {
        String typeId = (String)this.data.get("ObjectTypeId");
        return this.connection.repository.getType(typeId);
    }

    public Property getProperty(String name) {
        return new SimpleProperty(this, name);
    }

    public Map<String, Property> getProperties() {
        HashMap<String, Property> properties = new HashMap<String, Property>();
        for (PropertyDefinition pd : this.getType().getPropertyDefinitions()) {
            String name = pd.getName();
            properties.put(name, this.getProperty(name));
        }
        return properties;
    }

    public Serializable getValue(String name) {
        PropertyDefinition propertyDefinition = this.getType().getPropertyDefinition(name);
        if (propertyDefinition == null) {
            throw new IllegalArgumentException(name);
        }
        return (Serializable)this.data.get(name);
    }

    public Collection<String> getAllowableActions() {
        throw new UnsupportedOperationException();
    }

    public Collection<ObjectEntry> getRelationships() {
        throw new UnsupportedOperationException();
    }

    public Document getDocument() {
        if (this.getType().getBaseType() != BaseType.DOCUMENT) {
            throw new RuntimeException("Not a document: " + this.getId());
        }
        return new SimpleDocument(this.data, this.connection);
    }

    public Folder getFolder() {
        if (this.getType().getBaseType() != BaseType.FOLDER) {
            throw new RuntimeException("Not a folder: " + this.getId());
        }
        return new SimpleFolder(this.data, this.connection);
    }

    public Relationship getRelationship() {
        if (this.getType().getBaseType() != BaseType.RELATIONSHIP) {
            throw new RuntimeException("Not a relationship: " + this.getId());
        }
        return new SimpleRelationship(this.data, this.connection);
    }

    public Policy getPolicy() {
        if (this.getType().getBaseType() != BaseType.POLICY) {
            throw new RuntimeException("Not a policy: " + this.getId());
        }
        return new SimplePolicy(this.data, this.connection);
    }

    public String getString(String name) {
        return (String)((Object)this.getValue(name));
    }

    public String[] getStrings(String name) {
        return (String[])this.getValue(name);
    }

    public BigDecimal getDecimal(String name) {
        return (BigDecimal)this.getValue(name);
    }

    public BigDecimal[] getDecimals(String name) {
        return (BigDecimal[])this.getValue(name);
    }

    public Integer getInteger(String name) {
        return (Integer)this.getValue(name);
    }

    public Integer[] getIntegers(String name) {
        return (Integer[])this.getValue(name);
    }

    public Boolean getBoolean(String name) {
        return (Boolean)this.getValue(name);
    }

    public Boolean[] getBooleans(String name) {
        return (Boolean[])this.getValue(name);
    }

    public Calendar getDateTime(String name) {
        return (Calendar)this.getValue(name);
    }

    public Calendar[] getDateTimes(String name) {
        return (Calendar[])this.getValue(name);
    }

    public URI getURI(String name) {
        return (URI)this.getValue(name);
    }

    public URI[] getURIs(String name) {
        return (URI[])this.getValue(name);
    }

    public String getId(String name) {
        return (String)((Object)this.getValue(name));
    }

    public String[] getIds(String name) {
        return (String[])this.getValue(name);
    }

    public String getXML(String name) {
        return (String)((Object)this.getValue(name));
    }

    public String[] getXMLs(String name) {
        return (String[])this.getValue(name);
    }

    public String getHTML(String name) {
        return (String)((Object)this.getValue(name));
    }

    public String[] getHTMLs(String name) {
        return (String[])this.getValue(name);
    }

    public String getId() {
        return this.getString("ObjectId");
    }

    public URI getURI() {
        return this.getURI("Uri");
    }

    public String getTypeId() {
        return this.getId("ObjectTypeId");
    }

    public String getCreatedBy() {
        return this.getString("CreatedBy");
    }

    public Calendar getCreationDate() {
        return this.getDateTime("CreationDate");
    }

    public String getLastModifiedBy() {
        return this.getString("LastModifiedBy");
    }

    public Calendar getLastModificationDate() {
        return this.getDateTime("LastModificationDate");
    }

    public String getChangeToken() {
        return this.getString("ChangeToken");
    }

    public String getName() {
        return this.getString("Name");
    }

    public boolean isImmutable() {
        Boolean b = this.getBoolean("IsImmutable");
        return b == null ? false : b;
    }

    public boolean isLatestVersion() {
        Boolean b = this.getBoolean("IsLatestVersion");
        return b == null ? false : b;
    }

    public boolean isMajorVersion() {
        Boolean b = this.getBoolean("IsMajorVersion");
        return b == null ? false : b;
    }

    public boolean isLatestMajorVersion() {
        Boolean b = this.getBoolean("IsLatestMajorVersion");
        return b == null ? false : b;
    }

    public String getVersionLabel() {
        return this.getString("VersionLabel");
    }

    public String getVersionSeriesId() {
        return this.getId("VersionSeriesId");
    }

    public boolean isVersionSeriesCheckedOut() {
        Boolean b = this.getBoolean("IsVersionSeriesCheckedOut");
        return b == null ? false : b;
    }

    public String getVersionSeriesCheckedOutBy() {
        return this.getString("VersionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return this.getId("VersionSeriesCheckedOutId");
    }

    public String getCheckinComment() {
        return this.getString("CheckinComment");
    }

    public boolean hasContentStream() {
        String name = "ContentStreamMimeType";
        PropertyDefinition propertyDefinition = this.getType().getPropertyDefinition(name);
        if (propertyDefinition == null) {
            return false;
        }
        return this.data.containsKey(name);
    }
}

