/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.apache.chemistry.property.Choice;
import org.apache.chemistry.property.PropertyDefinition;
import org.apache.chemistry.property.PropertyType;
import org.apache.chemistry.property.Updatability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePropertyDefinition
implements PropertyDefinition {
    private final String name;
    private final String id;
    private final String displayName;
    private final String description;
    private final boolean inherited;
    private final PropertyType type;
    private final boolean multiValued;
    private final List<Choice> choices;
    private final boolean openChoice;
    private final boolean required;
    private final Serializable defaultValue;
    private final Updatability updatability;
    private final boolean queryable;
    private final boolean orderable;
    private final int precision;
    private final Integer minValue;
    private final Integer maxValue;
    private final int maxLength;
    private final URI schemaURI;
    private final String encoding;

    public SimplePropertyDefinition(String name, String id, String displayName, String description, boolean inherited, PropertyType type, boolean multiValued, List<Choice> choices, boolean openChoice, boolean required, Serializable defaultValue, Updatability updatability, boolean queryable, boolean orderable, int precision, Integer minValue, Integer maxValue, int maxLength, URI schemaURI, String encoding) {
        this.name = name;
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.inherited = inherited;
        this.type = type;
        this.multiValued = multiValued;
        this.choices = choices == null ? null : Collections.unmodifiableList(choices);
        this.openChoice = openChoice;
        this.required = required;
        this.defaultValue = defaultValue;
        this.updatability = updatability;
        this.queryable = queryable;
        this.orderable = orderable;
        this.precision = precision;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.maxLength = maxLength;
        this.schemaURI = schemaURI;
        this.encoding = encoding;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public PropertyType getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public boolean isOpenChoice() {
        return this.openChoice;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Serializable getDefaultValue() {
        return this.defaultValue;
    }

    public Updatability getUpdatability() {
        return this.updatability;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public boolean isOrderable() {
        return this.orderable;
    }

    public int getPrecision() {
        return this.precision;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public URI getSchemaURI() {
        return this.schemaURI;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean validates(Serializable value) {
        return this.validationError(value) == null;
    }

    public String validationError(Serializable value) {
        Class klass;
        if (this.getUpdatability() == Updatability.READ_ONLY) {
            return "Property is read-only";
        }
        if (value == null) {
            if (this.isRequired()) {
                return "Property is required";
            }
            return null;
        }
        boolean multi = this.isMultiValued();
        if (multi != value.getClass().isArray()) {
            return multi ? "Property is multi-valued" : "Property is single-valued";
        }
        switch (this.type) {
            case STRING: 
            case ID: {
                klass = String.class;
                break;
            }
            case DECIMAL: {
                klass = BigDecimal.class;
                break;
            }
            case INTEGER: {
                klass = Integer.class;
                break;
            }
            case BOOLEAN: {
                klass = Boolean.class;
                break;
            }
            case DATETIME: {
                klass = Calendar.class;
                break;
            }
            case URI: {
                klass = URI.class;
                break;
            }
            case XML: {
                klass = String.class;
                break;
            }
            case HTML: {
                klass = String.class;
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.type.toString());
            }
        }
        if (multi) {
            int i = 0;
            while (i < Array.getLength(value)) {
                Object v = Array.get(value, i);
                if (v == null) {
                    return "Array value cannot contain null elements";
                }
                if (!klass.isInstance(v)) {
                    return "Array value has type " + v.getClass() + " instead of " + klass.getName();
                }
                ++i;
            }
        } else if (!klass.isInstance(value)) {
            return "Value has type " + value.getClass() + " instead of " + klass.getName();
        }
        return null;
    }
}

