/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.chemistry.Connection;
import org.apache.chemistry.impl.simple.SimpleConnection;
import org.apache.chemistry.impl.simple.SimpleData;
import org.apache.chemistry.impl.simple.SimpleType;
import org.apache.chemistry.repository.JoinCapability;
import org.apache.chemistry.repository.QueryCapability;
import org.apache.chemistry.repository.Repository;
import org.apache.chemistry.repository.RepositoryCapabilities;
import org.apache.chemistry.repository.RepositoryEntry;
import org.apache.chemistry.repository.RepositoryInfo;
import org.apache.chemistry.type.BaseType;
import org.apache.chemistry.type.ContentStreamPresence;
import org.apache.chemistry.type.Type;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRepository
implements Repository,
RepositoryInfo,
RepositoryCapabilities {
    public static final String ROOT_FOLDER_NAME = "CMIS_Root_Folder";
    public static final String ROOT_TYPE_ID = "Root";
    public static final String DOCUMENT_TYPE_ID = "document";
    public static final String FOLDER_TYPE_ID = "folder";
    public static final String RELATIONSHIP_TYPE_ID = "relationship";
    public static final String POLICY_TYPE_ID = "policy";
    protected static SimpleType ROOT_TYPE = new SimpleType("Root", "folder", "Root", "Root Folder Type", BaseType.FOLDER, "", false, false, false, false, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.emptyList());
    protected static SimpleType DOCUMENT_TYPE = new SimpleType("document", null, "Document", "Document Type", BaseType.DOCUMENT, "", true, true, true, true, true, true, ContentStreamPresence.ALLOWED, null, null, Collections.emptyList());
    protected static SimpleType FOLDER_TYPE = new SimpleType("folder", null, "Folder", "Folder Type", BaseType.FOLDER, "", true, true, false, true, true, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.emptyList());
    protected static SimpleType RELATIONSHIP_TYPE = new SimpleType("relationship", null, "Relationship", "Relationship Type", BaseType.RELATIONSHIP, "", true, true, false, true, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.emptyList());
    protected static SimpleType POLICY_TYPE = new SimpleType("policy", null, "Policy", "Policy Type", BaseType.POLICY, "", true, true, false, true, false, false, ContentStreamPresence.NOT_ALLOWED, null, null, Collections.emptyList());
    public static final String USERNAME = "USERNAME";
    public static final String PASSWORD = "PASSWORD";
    protected static final Set<String> NO_PARENT = Collections.unmodifiableSet(new HashSet());
    private final String name;
    private final String rootFolderId;
    private final Map<String, Type> types;
    protected final Map<String, SimpleData> datas;
    protected final Map<String, byte[]> contentBytes;
    protected final Map<String, Set<String>> children;
    protected final Map<String, Set<String>> parents;

    public SimpleRepository(String name, Collection<SimpleType> types) {
        this.name = name;
        this.types = new HashMap<String, Type>();
        for (Collection ts : Arrays.asList(this.getDefaultTypes(), types)) {
            for (Type type : ts) {
                String tid = type.getId();
                if (this.types.containsKey(tid)) {
                    throw new RuntimeException("Type already defined: " + tid);
                }
                this.types.put(tid, type);
            }
        }
        this.rootFolderId = this.generateId();
        this.datas = new ConcurrentHashMap<String, SimpleData>();
        this.contentBytes = new ConcurrentHashMap<String, byte[]>();
        this.children = new ConcurrentHashMap<String, Set<String>>();
        this.parents = new ConcurrentHashMap<String, Set<String>>();
        SimpleData rootData = new SimpleData(ROOT_TYPE_ID);
        rootData.put("ObjectId", this.rootFolderId);
        rootData.put("Name", ROOT_FOLDER_NAME);
        this.datas.put(this.rootFolderId, rootData);
        this.children.put(this.rootFolderId, this.newSet());
        this.parents.put(this.rootFolderId, NO_PARENT);
    }

    protected String generateId() {
        return UUID.randomUUID().toString();
    }

    protected Collection<SimpleType> getDefaultTypes() {
        return Arrays.asList(DOCUMENT_TYPE, FOLDER_TYPE, RELATIONSHIP_TYPE, POLICY_TYPE, ROOT_TYPE);
    }

    protected Set<String> newSet() {
        return Collections.synchronizedSet(new HashSet());
    }

    public String getId() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public URI getURI() {
        return null;
    }

    public String getRelationshipName() {
        return null;
    }

    public Connection getConnection(Map<String, Serializable> parameters) {
        return new SimpleConnection(this);
    }

    public RepositoryInfo getInfo() {
        return this;
    }

    public Type getType(String typeId) {
        return this.types.get(typeId);
    }

    public Collection<Type> getTypes(String typeId, boolean returnPropertyDefinitions) {
        if (typeId == null) {
            return Collections.unmodifiableCollection(this.types.values());
        }
        if (!this.types.containsKey(typeId)) {
            return null;
        }
        return Collections.singleton(this.types.get(typeId));
    }

    public List<Type> getTypes(String typeId, boolean returnPropertyDefinitions, int maxItems, int skipCount, boolean[] hasMoreItems) {
        int toIndex;
        if (maxItems < 0) {
            throw new IllegalArgumentException(String.valueOf(maxItems));
        }
        if (skipCount < 0) {
            throw new IllegalArgumentException(String.valueOf(skipCount));
        }
        if (hasMoreItems.length < 1) {
            throw new IllegalArgumentException("hasMoreItems parameter too small");
        }
        Collection<Type> t = this.getTypes(typeId, returnPropertyDefinitions);
        if (t == null) {
            hasMoreItems[0] = false;
            return Collections.emptyList();
        }
        ArrayList<Type> all = new ArrayList<Type>(t);
        int fromIndex = skipCount;
        if (fromIndex < 0 || fromIndex > all.size()) {
            hasMoreItems[0] = false;
            return Collections.emptyList();
        }
        if (maxItems == 0) {
            maxItems = all.size();
        }
        if ((toIndex = skipCount + maxItems) > all.size()) {
            toIndex = all.size();
        }
        hasMoreItems[0] = toIndex < all.size();
        return all.subList(fromIndex, toIndex);
    }

    public String getDescription() {
        return "Repository " + this.name;
    }

    public String getRootFolderId() {
        return this.rootFolderId;
    }

    public String getVendorName() {
        return "Nuxeo";
    }

    public String getProductName() {
        return "Chemistry Simple Repository";
    }

    public String getProductVersion() {
        return "0.1-SNAPSHOT";
    }

    public String getVersionSupported() {
        return "0.51";
    }

    public Document getRepositorySpecificInformation() {
        return null;
    }

    public RepositoryCapabilities getCapabilities() {
        return this;
    }

    public Collection<RepositoryEntry> getRelatedRepositories() {
        return Collections.emptySet();
    }

    public boolean hasMultifiling() {
        return false;
    }

    public boolean hasUnfiling() {
        return false;
    }

    public boolean hasVersionSpecificFiling() {
        return false;
    }

    public boolean isPWCUpdatable() {
        return false;
    }

    public boolean isPWCSearchable() {
        return false;
    }

    public boolean isAllVersionsSearchable() {
        return false;
    }

    public JoinCapability getJoinCapability() {
        return JoinCapability.NO_JOIN;
    }

    public QueryCapability getQueryCapability() {
        return QueryCapability.BOTH_COMBINED;
    }
}

