/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.impl.simple;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.impl.simple.SimplePropertyDefinition;
import org.apache.chemistry.property.PropertyDefinition;
import org.apache.chemistry.property.PropertyType;
import org.apache.chemistry.property.Updatability;
import org.apache.chemistry.type.BaseType;
import org.apache.chemistry.type.ContentStreamPresence;
import org.apache.chemistry.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleType
implements Type {
    protected static final SimplePropertyDefinition PROP_ID = new SimplePropertyDefinition("ObjectId", "def:id", "Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_URI = new SimplePropertyDefinition("Uri", "def:uri", "URI", "", false, PropertyType.URI, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_TYPE_ID = new SimplePropertyDefinition("ObjectTypeId", "def:typeid", "Type ID", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CREATED_BY = new SimplePropertyDefinition("CreatedBy", "def:createdby", "Created By", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CREATION_DATE = new SimplePropertyDefinition("CreationDate", "def:creationdate", "Creation Date", "", false, PropertyType.DATETIME, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_LAST_MODIFIED_BY = new SimplePropertyDefinition("LastModifiedBy", "def:lastmodifiedby", "Last Modified By", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_LAST_MODIFICATION_DATE = new SimplePropertyDefinition("LastModificationDate", "def:lastmodificationdate", "Last Modification Date", "", false, PropertyType.DATETIME, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CHANGE_TOKEN = new SimplePropertyDefinition("ChangeToken", "def:changetoken", "Change Token", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_NAME = new SimplePropertyDefinition("Name", "def:name", "Name", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_IS_LATEST_VERSION = new SimplePropertyDefinition("IsLatestVersion", "def:islatestversion", "Is Latest Version", "", false, PropertyType.BOOLEAN, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_IS_MAJOR_VERSION = new SimplePropertyDefinition("IsMajorVersion", "def:ismajorversion", "Is Major Version", "", false, PropertyType.BOOLEAN, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_IS_LATEST_MAJOR_VERSION = new SimplePropertyDefinition("IsLatestMajorVersion", "def:islatestmajorversion", "Is Latest Major Version", "", false, PropertyType.BOOLEAN, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_VERSION_LABEL = new SimplePropertyDefinition("VersionLabel", "def:versionlabel", "Version Label", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_VERSION_SERIES_ID = new SimplePropertyDefinition("VersionSeriesId", "def:versionseriesid", "Version Series ID", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_IS_VERSION_SERIES_CHECKED_OUT = new SimplePropertyDefinition("IsVersionSeriesCheckedOut", "def:isversionseriescheckedout", "Is Version Series Checked Out", "", false, PropertyType.BOOLEAN, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_VERSION_SERIES_CHECKED_OUT_BY = new SimplePropertyDefinition("VersionSeriesCheckedOutBy", "def:versionseriescheckedoutby", "Version Series Checked Out By", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_VERSION_SERIES_CHECKED_OUT_ID = new SimplePropertyDefinition("VersionSeriesCheckedOutId", "def:versionseriescheckedoutid", "Version Series Checked Out Id", "", false, PropertyType.ID, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CHECKIN_COMMENT = new SimplePropertyDefinition("CheckinComment", "def:checkincomment", "Checkin Comment", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CONTENT_STREAM_ALLOWED = new SimplePropertyDefinition("ContentStreamAllowed", "def:contentstreamallowed", "Content Stream Allowed", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CONTENT_STREAM_LENGTH = new SimplePropertyDefinition("ContentStreamLength", "def:contentstreamlength", "Content Stream Length", "", false, PropertyType.INTEGER, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CONTENT_STREAM_MIME_TYPE = new SimplePropertyDefinition("ContentStreamMimeType", "def:contentstreammimetype", "Content Stream MIME Type", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CONTENT_STREAM_FILENAME = new SimplePropertyDefinition("ContentStreamFilename", "def:contentstreamfilename", "Content Stream Filename", "", false, PropertyType.STRING, false, null, false, false, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_CONTENT_STREAM_URI = new SimplePropertyDefinition("ContentStreamUri", "def:contentstreamuri", "Content Stream URI", "", false, PropertyType.URI, false, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_PARENT_ID = new SimplePropertyDefinition("ParentId", "def:parentid", "Parent Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_ALLOWED_CHILD_OBJECT_TYPE_IDS = new SimplePropertyDefinition("AllowedChildObjectTypeIds", "def:allowedchildobjecttypeids", "Allowed Child Object Type Ids", "", false, PropertyType.ID, true, null, false, false, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_SOURCE_ID = new SimplePropertyDefinition("SourceId", "def:sourceid", "Source Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_TARGET_ID = new SimplePropertyDefinition("TargetId", "def:targetid", "Target Id", "", false, PropertyType.ID, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_POLICY_NAME = new SimplePropertyDefinition("PolicyName", "def:policyname", "Policy Name", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_ONLY, true, true, 0, null, null, -1, null, null);
    protected static final SimplePropertyDefinition PROP_POLICY_TEXT = new SimplePropertyDefinition("PolicyText", "def:policytext", "Policy Text", "", false, PropertyType.STRING, false, null, false, true, null, Updatability.READ_WRITE, true, true, 0, null, null, -1, null, null);
    private final String id;
    private final String parentId;
    private final String queryName;
    private final String displayName;
    private final BaseType baseType;
    private final String description;
    private final boolean creatable;
    private final boolean queryable;
    private final boolean controllable;
    private final boolean includedInSuperTypeQuery;
    private final boolean fileable;
    private final boolean versionable;
    private final ContentStreamPresence contentStreamAllowed;
    private final String[] allowedSourceTypes;
    private final String[] allowedTargetTypes;
    private final Map<String, PropertyDefinition> propertyDefinitions;

    public SimpleType(String id, String parentId, String queryName, String displayName, BaseType baseType, String description, boolean creatable, boolean queryable, boolean controllable, boolean includedInSuperTypeQuery, boolean fileable, boolean versionable, ContentStreamPresence contentStreamAllowed, String[] allowedSourceTypes, String[] allowedTargetTypes, Collection<SimplePropertyDefinition> propertyDefinitions) {
        this.id = id;
        this.parentId = parentId;
        this.queryName = queryName;
        this.displayName = displayName;
        this.baseType = baseType;
        this.description = description;
        this.creatable = creatable;
        this.queryable = queryable;
        this.controllable = controllable;
        this.includedInSuperTypeQuery = includedInSuperTypeQuery;
        this.fileable = fileable;
        this.versionable = versionable;
        this.contentStreamAllowed = contentStreamAllowed;
        this.allowedSourceTypes = allowedSourceTypes;
        this.allowedTargetTypes = allowedTargetTypes;
        HashMap<String, PropertyDefinition> map = new HashMap<String, PropertyDefinition>();
        for (Collection defs : Arrays.asList(this.getBasePropertyDefinitions(baseType), propertyDefinitions)) {
            for (PropertyDefinition def : defs) {
                String name = def.getName();
                if (map.containsKey(name)) {
                    throw new RuntimeException("Property already defined for name: " + name);
                }
                map.put(name, def);
            }
        }
        this.propertyDefinitions = map;
    }

    protected List<SimplePropertyDefinition> getBasePropertyDefinitions(BaseType baseType) {
        ArrayList<SimplePropertyDefinition> defs = new ArrayList<SimplePropertyDefinition>((Collection)Arrays.asList(PROP_ID, PROP_URI, PROP_TYPE_ID, PROP_CREATED_BY, PROP_CREATION_DATE, PROP_LAST_MODIFIED_BY, PROP_LAST_MODIFICATION_DATE, PROP_CHANGE_TOKEN));
        switch (baseType) {
            case DOCUMENT: {
                defs.addAll((Collection<SimplePropertyDefinition>)Arrays.asList(PROP_NAME, PROP_IS_LATEST_VERSION, PROP_IS_MAJOR_VERSION, PROP_IS_LATEST_MAJOR_VERSION, PROP_VERSION_LABEL, PROP_VERSION_SERIES_ID, PROP_IS_VERSION_SERIES_CHECKED_OUT, PROP_VERSION_SERIES_CHECKED_OUT_BY, PROP_VERSION_SERIES_CHECKED_OUT_ID, PROP_CHECKIN_COMMENT, PROP_CONTENT_STREAM_ALLOWED, PROP_CONTENT_STREAM_LENGTH, PROP_CONTENT_STREAM_MIME_TYPE, PROP_CONTENT_STREAM_FILENAME, PROP_CONTENT_STREAM_URI));
                break;
            }
            case FOLDER: {
                defs.addAll((Collection<SimplePropertyDefinition>)Arrays.asList(PROP_NAME, PROP_PARENT_ID, PROP_ALLOWED_CHILD_OBJECT_TYPE_IDS));
                break;
            }
            case RELATIONSHIP: {
                defs.addAll((Collection<SimplePropertyDefinition>)Arrays.asList(PROP_SOURCE_ID, PROP_TARGET_ID));
                break;
            }
            case POLICY: {
                defs.addAll((Collection<SimplePropertyDefinition>)Arrays.asList(PROP_POLICY_NAME, PROP_POLICY_TEXT));
            }
        }
        return defs;
    }

    public String getId() {
        return this.id;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getParentId() {
        return this.parentId;
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public String getBaseTypeQueryName() {
        switch (this.baseType) {
            case DOCUMENT: {
                return "Document";
            }
            case FOLDER: {
                return "Folder";
            }
            case POLICY: {
                return "Policy";
            }
            case RELATIONSHIP: {
                return "Relationship";
            }
        }
        throw new UnsupportedOperationException(this.baseType.toString());
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public boolean isControllable() {
        return this.controllable;
    }

    public boolean isIncludedInSuperTypeQuery() {
        return this.includedInSuperTypeQuery;
    }

    public boolean isFileable() {
        return this.fileable;
    }

    public boolean isVersionable() {
        return this.versionable;
    }

    public ContentStreamPresence getContentStreamAllowed() {
        return this.contentStreamAllowed;
    }

    public String[] getAllowedSourceTypes() {
        return this.allowedSourceTypes;
    }

    public String[] getAllowedTargetTypes() {
        return this.allowedTargetTypes;
    }

    public Collection<PropertyDefinition> getPropertyDefinitions() {
        return Collections.unmodifiableCollection(this.propertyDefinitions.values());
    }

    public PropertyDefinition getPropertyDefinition(String name) {
        return this.propertyDefinitions.get(name);
    }
}

