
package org.apache.chemistry.opencmis.commons.impl.jaxb;

import java.math.BigInteger;
import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Holder;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.7-b01-
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ObjectServicePort", targetNamespace = "http://docs.oasis-open.org/ns/cmis/ws/200908/")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface ObjectServicePort {


    /**
     * 
     * @param extension
     * @param addACEs
     * @param versioningState
     * @param objectId
     * @param properties
     * @param removeACEs
     * @param contentStream
     * @param repositoryId
     * @param policies
     * @param folderId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "createDocument", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateDocument")
    @ResponseWrapper(localName = "createDocumentResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateDocumentResponse")
    public void createDocument(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisPropertiesType properties,
        @WebParam(name = "folderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String folderId,
        @WebParam(name = "contentStream", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisContentStreamType contentStream,
        @WebParam(name = "versioningState", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        EnumVersioningState versioningState,
        @WebParam(name = "policies", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        List<String> policies,
        @WebParam(name = "addACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType addACEs,
        @WebParam(name = "removeACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType removeACEs,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.OUT)
        Holder<String> objectId)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param addACEs
     * @param versioningState
     * @param objectId
     * @param properties
     * @param removeACEs
     * @param repositoryId
     * @param policies
     * @param folderId
     * @param sourceId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "createDocumentFromSource", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateDocumentFromSource")
    @ResponseWrapper(localName = "createDocumentFromSourceResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateDocumentFromSourceResponse")
    public void createDocumentFromSource(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "sourceId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String sourceId,
        @WebParam(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisPropertiesType properties,
        @WebParam(name = "folderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String folderId,
        @WebParam(name = "versioningState", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        EnumVersioningState versioningState,
        @WebParam(name = "policies", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        List<String> policies,
        @WebParam(name = "addACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType addACEs,
        @WebParam(name = "removeACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType removeACEs,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.OUT)
        Holder<String> objectId)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param addACEs
     * @param objectId
     * @param properties
     * @param removeACEs
     * @param repositoryId
     * @param policies
     * @param folderId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "createFolder", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateFolder")
    @ResponseWrapper(localName = "createFolderResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateFolderResponse")
    public void createFolder(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisPropertiesType properties,
        @WebParam(name = "folderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String folderId,
        @WebParam(name = "policies", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        List<String> policies,
        @WebParam(name = "addACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType addACEs,
        @WebParam(name = "removeACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType removeACEs,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.OUT)
        Holder<String> objectId)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param addACEs
     * @param objectId
     * @param properties
     * @param removeACEs
     * @param repositoryId
     * @param policies
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "createRelationship", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateRelationship")
    @ResponseWrapper(localName = "createRelationshipResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreateRelationshipResponse")
    public void createRelationship(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisPropertiesType properties,
        @WebParam(name = "policies", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        List<String> policies,
        @WebParam(name = "addACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType addACEs,
        @WebParam(name = "removeACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType removeACEs,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.OUT)
        Holder<String> objectId)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param addACEs
     * @param objectId
     * @param properties
     * @param removeACEs
     * @param repositoryId
     * @param policies
     * @param folderId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "createPolicy", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreatePolicy")
    @ResponseWrapper(localName = "createPolicyResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.CreatePolicyResponse")
    public void createPolicy(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisPropertiesType properties,
        @WebParam(name = "folderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String folderId,
        @WebParam(name = "policies", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        List<String> policies,
        @WebParam(name = "addACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType addACEs,
        @WebParam(name = "removeACEs", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisAccessControlListType removeACEs,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.OUT)
        Holder<String> objectId)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param objectId
     * @param repositoryId
     * @return
     *     returns org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "allowableActions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "getAllowableActions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetAllowableActions")
    @ResponseWrapper(localName = "getAllowableActionsResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetAllowableActionsResponse")
    public CmisAllowableActionsType getAllowableActions(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String objectId,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param includePolicyIds
     * @param objectId
     * @param includeRelationships
     * @param includeAllowableActions
     * @param repositoryId
     * @param renditionFilter
     * @param filter
     * @param includeACL
     * @return
     *     returns org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "object", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "getObject", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetObject")
    @ResponseWrapper(localName = "getObjectResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetObjectResponse")
    public CmisObjectType getObject(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String objectId,
        @WebParam(name = "filter", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String filter,
        @WebParam(name = "includeAllowableActions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean includeAllowableActions,
        @WebParam(name = "includeRelationships", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        EnumIncludeRelationships includeRelationships,
        @WebParam(name = "renditionFilter", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String renditionFilter,
        @WebParam(name = "includePolicyIds", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean includePolicyIds,
        @WebParam(name = "includeACL", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean includeACL,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param objectId
     * @param repositoryId
     * @param filter
     * @return
     *     returns org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "getProperties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetProperties")
    @ResponseWrapper(localName = "getPropertiesResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetPropertiesResponse")
    public CmisPropertiesType getProperties(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String objectId,
        @WebParam(name = "filter", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String filter,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param objectId
     * @param skipCount
     * @param maxItems
     * @param repositoryId
     * @param renditionFilter
     * @return
     *     returns java.util.List<org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType>
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "renditions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "getRenditions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetRenditions")
    @ResponseWrapper(localName = "getRenditionsResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetRenditionsResponse")
    public List<CmisRenditionType> getRenditions(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String objectId,
        @WebParam(name = "renditionFilter", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String renditionFilter,
        @WebParam(name = "maxItems", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        BigInteger maxItems,
        @WebParam(name = "skipCount", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        BigInteger skipCount,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param includePolicyIds
     * @param path
     * @param includeRelationships
     * @param includeAllowableActions
     * @param repositoryId
     * @param renditionFilter
     * @param filter
     * @param includeACL
     * @return
     *     returns org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "object", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "getObjectByPath", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetObjectByPath")
    @ResponseWrapper(localName = "getObjectByPathResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetObjectByPathResponse")
    public CmisObjectType getObjectByPath(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "path", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String path,
        @WebParam(name = "filter", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String filter,
        @WebParam(name = "includeAllowableActions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean includeAllowableActions,
        @WebParam(name = "includeRelationships", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        EnumIncludeRelationships includeRelationships,
        @WebParam(name = "renditionFilter", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String renditionFilter,
        @WebParam(name = "includePolicyIds", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean includePolicyIds,
        @WebParam(name = "includeACL", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean includeACL,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param streamId
     * @param objectId
     * @param length
     * @param offset
     * @param repositoryId
     * @return
     *     returns org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "contentStream", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "getContentStream", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetContentStream")
    @ResponseWrapper(localName = "getContentStreamResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.GetContentStreamResponse")
    public CmisContentStreamType getContentStream(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String objectId,
        @WebParam(name = "streamId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String streamId,
        @WebParam(name = "offset", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        BigInteger offset,
        @WebParam(name = "length", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        BigInteger length,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param changeToken
     * @param objectId
     * @param properties
     * @param repositoryId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "updateProperties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.UpdateProperties")
    @ResponseWrapper(localName = "updatePropertiesResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.UpdatePropertiesResponse")
    public void updateProperties(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> objectId,
        @WebParam(name = "changeToken", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> changeToken,
        @WebParam(name = "properties", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisPropertiesType properties,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param targetFolderId
     * @param sourceFolderId
     * @param objectId
     * @param repositoryId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "moveObject", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.MoveObject")
    @ResponseWrapper(localName = "moveObjectResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.MoveObjectResponse")
    public void moveObject(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> objectId,
        @WebParam(name = "targetFolderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String targetFolderId,
        @WebParam(name = "sourceFolderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String sourceFolderId,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param allVersions
     * @param objectId
     * @param repositoryId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "deleteObject", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteObject")
    @ResponseWrapper(localName = "deleteObjectResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteObjectResponse")
    public void deleteObject(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String objectId,
        @WebParam(name = "allVersions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean allVersions,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param continueOnFailure
     * @param unfileObjects
     * @param allVersions
     * @param repositoryId
     * @param folderId
     * @return
     *     returns org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse.FailedToDelete
     * @throws CmisException
     */
    @WebMethod
    @WebResult(name = "failedToDelete", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
    @RequestWrapper(localName = "deleteTree", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTree")
    @ResponseWrapper(localName = "deleteTreeResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse")
    public org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse.FailedToDelete deleteTree(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "folderId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String folderId,
        @WebParam(name = "allVersions", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean allVersions,
        @WebParam(name = "unfileObjects", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        EnumUnfileObject unfileObjects,
        @WebParam(name = "continueOnFailure", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean continueOnFailure,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisExtensionType extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param overwriteFlag
     * @param changeToken
     * @param objectId
     * @param contentStream
     * @param repositoryId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "setContentStream", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.SetContentStream")
    @ResponseWrapper(localName = "setContentStreamResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.SetContentStreamResponse")
    public void setContentStream(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> objectId,
        @WebParam(name = "overwriteFlag", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        Boolean overwriteFlag,
        @WebParam(name = "changeToken", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> changeToken,
        @WebParam(name = "contentStream", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        CmisContentStreamType contentStream,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension)
        throws CmisException
    ;

    /**
     * 
     * @param extension
     * @param changeToken
     * @param objectId
     * @param repositoryId
     * @throws CmisException
     */
    @WebMethod
    @RequestWrapper(localName = "deleteContentStream", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteContentStream")
    @ResponseWrapper(localName = "deleteContentStreamResponse", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", className = "org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteContentStreamResponse")
    public void deleteContentStream(
        @WebParam(name = "repositoryId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/")
        String repositoryId,
        @WebParam(name = "objectId", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> objectId,
        @WebParam(name = "changeToken", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<String> changeToken,
        @WebParam(name = "extension", targetNamespace = "http://docs.oasis-open.org/ns/cmis/messaging/200908/", mode = WebParam.Mode.INOUT)
        Holder<CmisExtensionType> extension)
        throws CmisException
    ;

}
