/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.fileshare.FileShareRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryMap {
    private final Map<String, FileShareRepository> map = new HashMap<String, FileShareRepository>();
    private final Map<String, String> logins = new HashMap<String, String>();

    public void addRepository(FileShareRepository fsr) {
        if (fsr == null || fsr.getRepositoryId() == null) {
            return;
        }
        this.map.put(fsr.getRepositoryId(), fsr);
    }

    public FileShareRepository getRepository(String repositoryId) {
        FileShareRepository result = this.map.get(repositoryId);
        if (result == null) {
            throw new CmisObjectNotFoundException("Unknown repository '" + repositoryId + "'!");
        }
        return result;
    }

    public void authenticate(CallContext context) {
        if (!this.authenticate(context.getUsername(), context.getPassword())) {
            throw new CmisPermissionDeniedException();
        }
    }

    public Collection<FileShareRepository> getRepositories() {
        return this.map.values();
    }

    public void addLogin(String username, String password) {
        if (username == null || password == null) {
            return;
        }
        this.logins.put(username.trim(), password);
    }

    private boolean authenticate(String username, String password) {
        String pwd = this.logins.get(username);
        if (pwd == null) {
            return false;
        }
        return pwd.equals(password);
    }
}

