/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeManager {
    public static final String DOCUMENT_TYPE_ID = BaseTypeId.CMIS_DOCUMENT.value();
    public static final String FOLDER_TYPE_ID = BaseTypeId.CMIS_FOLDER.value();
    public static final String RELATIONSHIP_TYPE_ID = BaseTypeId.CMIS_RELATIONSHIP.value();
    public static final String POLICY_TYPE_ID = BaseTypeId.CMIS_POLICY.value();
    private static final String NAMESPACE = "http://opencmis.org/fileshare";
    private static final Log log = LogFactory.getLog(TypeManager.class);
    private Map<String, TypeDefinitionContainerImpl> types;
    private List<TypeDefinitionContainer> typesList;

    public TypeManager() {
        this.setup();
    }

    private void setup() {
        this.types = new HashMap<String, TypeDefinitionContainerImpl>();
        this.typesList = new ArrayList<TypeDefinitionContainer>();
        FolderTypeDefinitionImpl folderType = new FolderTypeDefinitionImpl();
        folderType.setBaseTypeId(BaseTypeId.CMIS_FOLDER);
        folderType.setIsControllableAcl(Boolean.valueOf(false));
        folderType.setIsControllablePolicy(Boolean.valueOf(false));
        folderType.setIsCreatable(Boolean.valueOf(true));
        folderType.setDescription("Folder");
        folderType.setDisplayName("Folder");
        folderType.setIsFileable(Boolean.valueOf(true));
        folderType.setIsFulltextIndexed(Boolean.valueOf(false));
        folderType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        folderType.setLocalName("Folder");
        folderType.setLocalNamespace(NAMESPACE);
        folderType.setIsQueryable(Boolean.valueOf(false));
        folderType.setQueryName("cmis:folder");
        folderType.setId(FOLDER_TYPE_ID);
        TypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)folderType);
        TypeManager.addFolderPropertyDefinitions(folderType);
        this.addTypeInteral((AbstractTypeDefinition)folderType);
        DocumentTypeDefinitionImpl documentType = new DocumentTypeDefinitionImpl();
        documentType.setBaseTypeId(BaseTypeId.CMIS_DOCUMENT);
        documentType.setIsControllableAcl(Boolean.valueOf(false));
        documentType.setIsControllablePolicy(Boolean.valueOf(false));
        documentType.setIsCreatable(Boolean.valueOf(true));
        documentType.setDescription("Document");
        documentType.setDisplayName("Document");
        documentType.setIsFileable(Boolean.valueOf(true));
        documentType.setIsFulltextIndexed(Boolean.valueOf(false));
        documentType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        documentType.setLocalName("Document");
        documentType.setLocalNamespace(NAMESPACE);
        documentType.setIsQueryable(Boolean.valueOf(false));
        documentType.setQueryName("cmis:document");
        documentType.setId(DOCUMENT_TYPE_ID);
        documentType.setIsVersionable(Boolean.valueOf(false));
        documentType.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
        TypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)documentType);
        TypeManager.addDocumentPropertyDefinitions(documentType);
        this.addTypeInteral((AbstractTypeDefinition)documentType);
        RelationshipTypeDefinitionImpl relationshipType = new RelationshipTypeDefinitionImpl();
        relationshipType.setBaseTypeId(BaseTypeId.CMIS_RELATIONSHIP);
        relationshipType.setIsControllableAcl(Boolean.valueOf(false));
        relationshipType.setIsControllablePolicy(Boolean.valueOf(false));
        relationshipType.setIsCreatable(Boolean.valueOf(false));
        relationshipType.setDescription("Relationship");
        relationshipType.setDisplayName("Relationship");
        relationshipType.setIsFileable(Boolean.valueOf(false));
        relationshipType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        relationshipType.setLocalName("Relationship");
        relationshipType.setLocalNamespace(NAMESPACE);
        relationshipType.setIsQueryable(Boolean.valueOf(false));
        relationshipType.setQueryName("cmis:relationship");
        relationshipType.setId(RELATIONSHIP_TYPE_ID);
        TypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)relationshipType);
        PolicyTypeDefinitionImpl policyType = new PolicyTypeDefinitionImpl();
        policyType.setBaseTypeId(BaseTypeId.CMIS_POLICY);
        policyType.setIsControllableAcl(Boolean.valueOf(false));
        policyType.setIsControllablePolicy(Boolean.valueOf(false));
        policyType.setIsCreatable(Boolean.valueOf(false));
        policyType.setDescription("Policy");
        policyType.setDisplayName("Policy");
        policyType.setIsFileable(Boolean.valueOf(false));
        policyType.setIsIncludedInSupertypeQuery(Boolean.valueOf(true));
        policyType.setLocalName("Policy");
        policyType.setLocalNamespace(NAMESPACE);
        policyType.setIsQueryable(Boolean.valueOf(false));
        policyType.setQueryName("cmis:policy");
        policyType.setId(POLICY_TYPE_ID);
        TypeManager.addBasePropertyDefinitions((AbstractTypeDefinition)policyType);
    }

    private static void addBasePropertyDefinitions(AbstractTypeDefinition type) {
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:baseTypeId", "Base Type Id", "Base Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:objectId", "Object Id", "Object Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:objectTypeId", "Type Id", "Type Id", PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, false, true));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:name", "Name", "Name", PropertyType.STRING, Cardinality.SINGLE, Updatability.READWRITE, false, true));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:createdBy", "Created By", "Created By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:creationDate", "Creation Date", "Creation Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:lastModifiedBy", "Last Modified By", "Last Modified By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:lastModificationDate", "Last Modification Date", "Last Modification Date", PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:changeToken", "Change Token", "Change Token", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    private static void addFolderPropertyDefinitions(FolderTypeDefinitionImpl type) {
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:parentId", "Parent Id", "Parent Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:allowedChildObjectTypeIds", "Allowed Child Object Type Ids", "Allowed Child Object Type Ids", PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:path", "Path", "Path", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    private static void addDocumentPropertyDefinitions(DocumentTypeDefinitionImpl type) {
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:isImmutable", "Is Immutable", "Is Immutable", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:isLatestVersion", "Is Latest Version", "Is Latest Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:isMajorVersion", "Is Major Version", "Is Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:isLatestMajorVersion", "Is Latest Major Version", "Is Latest Major Version", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:versionLabel", "Version Label", "Version Label", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:versionSeriesId", "Version Series Id", "Version Series Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, true));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:isVersionSeriesCheckedOut", "Is Verison Series Checked Out", "Is Verison Series Checked Out", PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:versionSeriesCheckedOutId", "Version Series Checked Out Id", "Version Series Checked Out Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:versionSeriesCheckedOutBy", "Version Series Checked Out By", "Version Series Checked Out By", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:checkinComment", "Checkin Comment", "Checkin Comment", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:contentStreamLength", "Content Stream Length", "Content Stream Length", PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:contentStreamMimeType", "MIME Type", "MIME Type", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:contentStreamFileName", "Filename", "Filename", PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, false, false));
        type.addPropertyDefinition(TypeManager.createPropDef("cmis:contentStreamId", "Content Stream Id", "Content Stream Id", PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, false, false));
    }

    private static PropertyDefinition<?> createPropDef(String id, String displayName, String description, PropertyType datatype, Cardinality cardinality, Updatability updateability, boolean inherited, boolean required) {
        PropertyBooleanDefinitionImpl result = null;
        switch (datatype) {
            case BOOLEAN: {
                result = new PropertyBooleanDefinitionImpl();
                break;
            }
            case DATETIME: {
                result = new PropertyDateTimeDefinitionImpl();
                break;
            }
            case DECIMAL: {
                result = new PropertyDecimalDefinitionImpl();
                break;
            }
            case HTML: {
                result = new PropertyHtmlDefinitionImpl();
                break;
            }
            case ID: {
                result = new PropertyIdDefinitionImpl();
                break;
            }
            case INTEGER: {
                result = new PropertyIntegerDefinitionImpl();
                break;
            }
            case STRING: {
                result = new PropertyStringDefinitionImpl();
                break;
            }
            case URI: {
                result = new PropertyUriDefinitionImpl();
                break;
            }
            default: {
                throw new RuntimeException("Unknown datatype! Spec change?");
            }
        }
        result.setId(id);
        result.setLocalName(id);
        result.setDisplayName(displayName);
        result.setDescription(description);
        result.setPropertyType(datatype);
        result.setCardinality(cardinality);
        result.setUpdatability(updateability);
        result.setIsInherited(Boolean.valueOf(inherited));
        result.setIsRequired(Boolean.valueOf(required));
        result.setIsQueryable(Boolean.valueOf(false));
        result.setIsOrderable(Boolean.valueOf(false));
        result.setQueryName(id);
        return result;
    }

    public boolean addType(TypeDefinition type) {
        if (type == null) {
            return false;
        }
        if (type.getBaseTypeId() == null) {
            return false;
        }
        TypeDefinition baseType = null;
        if (type.getBaseTypeId() == BaseTypeId.CMIS_DOCUMENT) {
            baseType = TypeManager.copyTypeDefintion(this.types.get(DOCUMENT_TYPE_ID).getTypeDefinition());
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_FOLDER) {
            baseType = TypeManager.copyTypeDefintion(this.types.get(FOLDER_TYPE_ID).getTypeDefinition());
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_RELATIONSHIP) {
            baseType = TypeManager.copyTypeDefintion(this.types.get(RELATIONSHIP_TYPE_ID).getTypeDefinition());
        } else if (type.getBaseTypeId() == BaseTypeId.CMIS_POLICY) {
            baseType = TypeManager.copyTypeDefintion(this.types.get(POLICY_TYPE_ID).getTypeDefinition());
        } else {
            return false;
        }
        AbstractTypeDefinition newType = (AbstractTypeDefinition)TypeManager.copyTypeDefintion(type);
        for (PropertyDefinition propDef : baseType.getPropertyDefinitions().values()) {
            ((AbstractPropertyDefinition)propDef).setIsInherited(Boolean.valueOf(true));
            newType.addPropertyDefinition(propDef);
        }
        this.addTypeInteral(newType);
        log.info((Object)("Added type '" + newType.getId() + "'."));
        return true;
    }

    private void addTypeInteral(AbstractTypeDefinition type) {
        TypeDefinitionContainerImpl tdc;
        if (type == null) {
            return;
        }
        if (this.types.containsKey(type.getId())) {
            return;
        }
        TypeDefinitionContainerImpl tc = new TypeDefinitionContainerImpl();
        tc.setTypeDefinition((TypeDefinition)type);
        if (type.getParentTypeId() != null && (tdc = this.types.get(type.getParentTypeId())) != null) {
            if (tdc.getChildren() == null) {
                tdc.setChildren(new ArrayList());
            }
            tdc.getChildren().add(tc);
        }
        this.types.put(type.getId(), tc);
        this.typesList.add((TypeDefinitionContainer)tc);
    }

    public TypeDefinitionList getTypesChildren(CallContext context, String typeId, boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount) {
        int max;
        int skip;
        TypeDefinitionListImpl result = new TypeDefinitionListImpl(new ArrayList());
        int n = skip = skipCount == null ? 0 : skipCount.intValue();
        if (skip < 0) {
            skip = 0;
        }
        int n2 = max = maxItems == null ? Integer.MAX_VALUE : maxItems.intValue();
        if (max < 1) {
            return result;
        }
        if (typeId == null) {
            if (skip < 1) {
                result.getList().add(TypeManager.copyTypeDefintion(this.types.get(FOLDER_TYPE_ID).getTypeDefinition()));
                --max;
            }
            if (skip < 2 && max > 0) {
                result.getList().add(TypeManager.copyTypeDefintion(this.types.get(DOCUMENT_TYPE_ID).getTypeDefinition()));
                --max;
            }
            result.setHasMoreItems(Boolean.valueOf(result.getList().size() + skip < 2));
            result.setNumItems(BigInteger.valueOf(2L));
        } else {
            TypeDefinitionContainer tc = (TypeDefinitionContainer)this.types.get(typeId);
            if (tc == null || tc.getChildren() == null) {
                return result;
            }
            for (TypeDefinitionContainer child : tc.getChildren()) {
                if (skip > 0) {
                    --skip;
                    continue;
                }
                result.getList().add(TypeManager.copyTypeDefintion(child.getTypeDefinition()));
                if (--max != 0) continue;
                break;
            }
            result.setHasMoreItems(Boolean.valueOf(result.getList().size() + skip < tc.getChildren().size()));
            result.setNumItems(BigInteger.valueOf(tc.getChildren().size()));
        }
        if (!includePropertyDefinitions) {
            for (TypeDefinition type : result.getList()) {
                type.getPropertyDefinitions().clear();
            }
        }
        return result;
    }

    public List<TypeDefinitionContainer> getTypesDescendants(CallContext context, String typeId, BigInteger depth, Boolean includePropertyDefinitions) {
        boolean ipd;
        int d;
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        int n = d = depth == null ? -1 : depth.intValue();
        if (d == 0) {
            throw new CmisInvalidArgumentException("Depth must not be 0!");
        }
        boolean bl = ipd = includePropertyDefinitions == null ? false : includePropertyDefinitions;
        if (typeId == null) {
            result.add(this.getTypesDescendants(d, (TypeDefinitionContainer)this.types.get(FOLDER_TYPE_ID), ipd));
            result.add(this.getTypesDescendants(d, (TypeDefinitionContainer)this.types.get(DOCUMENT_TYPE_ID), ipd));
        } else {
            TypeDefinitionContainer tc = (TypeDefinitionContainer)this.types.get(typeId);
            if (tc != null) {
                result.add(this.getTypesDescendants(d, tc, ipd));
            }
        }
        return result;
    }

    private TypeDefinitionContainer getTypesDescendants(int depth, TypeDefinitionContainer tc, boolean includePropertyDefinitions) {
        TypeDefinitionContainerImpl result = new TypeDefinitionContainerImpl();
        TypeDefinition type = TypeManager.copyTypeDefintion(tc.getTypeDefinition());
        if (!includePropertyDefinitions) {
            type.getPropertyDefinitions().clear();
        }
        result.setTypeDefinition(type);
        if (depth != 0 && tc.getChildren() != null) {
            result.setChildren(new ArrayList());
            for (TypeDefinitionContainer tdc : tc.getChildren()) {
                result.getChildren().add(this.getTypesDescendants(depth < 0 ? -1 : depth - 1, tdc, includePropertyDefinitions));
            }
        }
        return result;
    }

    public TypeDefinition getType(String typeId) {
        TypeDefinitionContainer tc = (TypeDefinitionContainer)this.types.get(typeId);
        if (tc == null) {
            return null;
        }
        return tc.getTypeDefinition();
    }

    public TypeDefinition getTypeDefinition(CallContext context, String typeId) {
        TypeDefinitionContainer tc = (TypeDefinitionContainer)this.types.get(typeId);
        if (tc == null) {
            throw new CmisObjectNotFoundException("Type '" + typeId + "' is unknown!");
        }
        return TypeManager.copyTypeDefintion(tc.getTypeDefinition());
    }

    private static TypeDefinition copyTypeDefintion(TypeDefinition type) {
        return Converter.convert((CmisTypeDefinitionType)Converter.convert((TypeDefinition)type));
    }
}

