/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.fileshare.FileShareCmisService;
import org.apache.chemistry.opencmis.fileshare.FileShareRepository;
import org.apache.chemistry.opencmis.fileshare.FileShareRepositoryManager;
import org.apache.chemistry.opencmis.fileshare.FileShareTypeManager;
import org.apache.chemistry.opencmis.fileshare.FileShareUserManager;
import org.apache.chemistry.opencmis.server.support.wrapper.CallContextAwareCmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.CmisServiceWrapperManager;
import org.apache.chemistry.opencmis.server.support.wrapper.ConformanceCmisServiceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileShareCmisServiceFactory
extends AbstractServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FileShareCmisServiceFactory.class);
    private static final String PREFIX_LOGIN = "login.";
    private static final String PREFIX_REPOSITORY = "repository.";
    private static final String PREFIX_TYPE = "type.";
    private static final String SUFFIX_READWRITE = ".readwrite";
    private static final String SUFFIX_READONLY = ".readonly";
    private static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(50L);
    private static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    private static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(200L);
    private static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(10L);
    private ThreadLocal<CallContextAwareCmisService> threadLocalService = new ThreadLocal();
    private FileShareRepositoryManager repositoryManager;
    private FileShareUserManager userManager;
    private FileShareTypeManager typeManager;
    private CmisServiceWrapperManager wrapperManager;

    public FileShareRepositoryManager getRepositoryManager() {
        return this.repositoryManager;
    }

    public FileShareUserManager getUserManager() {
        return this.userManager;
    }

    public FileShareTypeManager getTypeManager() {
        return this.typeManager;
    }

    public void init(Map<String, String> parameters) {
        this.repositoryManager = new FileShareRepositoryManager();
        this.userManager = new FileShareUserManager();
        this.typeManager = new FileShareTypeManager();
        this.wrapperManager = new CmisServiceWrapperManager();
        this.wrapperManager.addWrappersFromServiceFactoryParameters(parameters);
        this.wrapperManager.addOuterWrapper(ConformanceCmisServiceWrapper.class, new Object[]{DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS});
        this.readConfiguration(parameters);
    }

    public void destroy() {
        this.threadLocalService = null;
    }

    public CmisService getService(CallContext context) {
        this.userManager.authenticate(context);
        CallContextAwareCmisService service = this.threadLocalService.get();
        if (service == null) {
            FileShareCmisService fileShareService = new FileShareCmisService(this.repositoryManager);
            service = (CallContextAwareCmisService)this.wrapperManager.wrap((CmisService)fileShareService);
            this.threadLocalService.set(service);
        }
        service.setCallContext(context);
        return service;
    }

    private void readConfiguration(Map<String, String> parameters) {
        ArrayList<String> keys = new ArrayList<String>(parameters.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            FileShareRepository fsr;
            if (key.startsWith(PREFIX_LOGIN)) {
                String usernameAndPassword = this.replaceSystemProperties(parameters.get(key));
                if (usernameAndPassword == null) continue;
                String username = usernameAndPassword;
                String password = "";
                int x = usernameAndPassword.indexOf(58);
                if (x > -1) {
                    username = usernameAndPassword.substring(0, x);
                    password = usernameAndPassword.substring(x + 1);
                }
                LOG.info("Adding login '{}'.", (Object)username);
                this.userManager.addLogin(username, password);
                continue;
            }
            if (key.startsWith(PREFIX_TYPE)) {
                String typeFile = this.replaceSystemProperties(parameters.get(key).trim());
                if (typeFile.length() == 0) continue;
                LOG.info("Loading type definition: {}", (Object)typeFile);
                if (typeFile.charAt(0) == '/') {
                    try {
                        this.typeManager.loadTypeDefinitionFromResource(typeFile);
                        continue;
                    }
                    catch (IllegalArgumentException username) {
                    }
                    catch (Exception e) {
                        LOG.warn("Could not load type defintion from resource '{}': {}", new Object[]{typeFile, e.getMessage(), e});
                        continue;
                    }
                }
                try {
                    this.typeManager.loadTypeDefinitionFromFile(typeFile);
                }
                catch (Exception e) {
                    LOG.warn("Could not load type defintion from file '{}': {}", new Object[]{typeFile, e.getMessage(), e});
                }
                continue;
            }
            if (!key.startsWith(PREFIX_REPOSITORY)) continue;
            String repositoryId = key.substring(PREFIX_REPOSITORY.length()).trim();
            int x = repositoryId.lastIndexOf(46);
            if (x > 0) {
                repositoryId = repositoryId.substring(0, x);
            }
            if (repositoryId.length() == 0) {
                throw new IllegalArgumentException("No repository id!");
            }
            if (key.endsWith(SUFFIX_READWRITE)) {
                fsr = this.repositoryManager.getRepository(repositoryId);
                for (String user : this.split(parameters.get(key))) {
                    fsr.setUserReadWrite(this.replaceSystemProperties(user));
                }
                continue;
            }
            if (key.endsWith(SUFFIX_READONLY)) {
                fsr = this.repositoryManager.getRepository(repositoryId);
                for (String user : this.split(parameters.get(key))) {
                    fsr.setUserReadOnly(this.replaceSystemProperties(user));
                }
                continue;
            }
            String root = this.replaceSystemProperties(parameters.get(key));
            LOG.info("Adding repository '{}': {}", (Object)repositoryId, (Object)root);
            FileShareRepository fsr2 = new FileShareRepository(repositoryId, root, this.typeManager);
            this.repositoryManager.addRepository(fsr2);
        }
    }

    private List<String> split(String csl) {
        if (csl == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : csl.split(",")) {
            result.add(s.trim());
        }
        return result;
    }

    private String replaceSystemProperties(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder(128);
        StringBuilder property = null;
        boolean inProperty = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (inProperty) {
                if (c == '}') {
                    String value = System.getProperty(property.toString());
                    if (value != null) {
                        result.append(value);
                    }
                    inProperty = false;
                    continue;
                }
                property.append(c);
                continue;
            }
            if (c == '{') {
                property = new StringBuilder(32);
                inProperty = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }
}

