/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.fileshare;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.server.CallContext;

public class FileShareUserManager {
    private final Map<String, String> logins = new HashMap<String, String>();

    public synchronized Collection<String> getLogins() {
        return this.logins.keySet();
    }

    public synchronized void addLogin(String username, String password) {
        if (username == null || password == null) {
            return;
        }
        this.logins.put(username.trim(), password);
    }

    public synchronized String authenticate(CallContext context) {
        if (!this.authenticate(context.getUsername(), context.getPassword())) {
            throw new CmisPermissionDeniedException("Invalid username or password.");
        }
        return context.getUsername();
    }

    private synchronized boolean authenticate(String username, String password) {
        String pwd = this.logins.get(username);
        if (pwd == null) {
            return false;
        }
        return pwd.equals(password);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        for (String user : this.logins.keySet()) {
            sb.append('[');
            sb.append(user);
            sb.append(']');
        }
        return sb.toString();
    }
}

