/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.runner;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.impl.WrapperCmisTestGroup;

public abstract class AbstractRunner {
    public static final String OVERRIDE_KEY = "org.apache.chemistry";
    public static final String DEFAULT_TCK_GROUPS = "/cmis-tck-groups.txt";
    public static final String TCK_BUILD_TIMESTAMP = "/META-INF/build-timestamp.txt";
    public static final String TCK_BUILD_TIMESTAMP_PARAMETER = "org.apache.chemistry.opencmis.tck.timestamp";
    public static final String TCK_REVISION = "/META-INF/tck-revision.txt";
    public static final String TCK_REVISION_PARAMETER = "org.apache.chemistry.opencmis.tck.revision";
    private Map<String, String> parameters;
    private final List<CmisTestGroup> groups = new ArrayList<CmisTestGroup>();
    private boolean isCanceled = false;

    public void setParameters(Map<String, String> orgParameters) {
        this.parameters = new HashMap<String, String>();
        if (orgParameters != null) {
            this.parameters.putAll(orgParameters);
        }
        for (Object key : System.getProperties().keySet()) {
            if (!key.toString().startsWith(OVERRIDE_KEY)) continue;
            this.parameters.put(key.toString(), System.getProperties().getProperty(key.toString()));
        }
        this.parameters.put(TCK_BUILD_TIMESTAMP_PARAMETER, this.loadTCKTimestamp());
        String revision = this.loadTCKRevision();
        if (revision != null) {
            this.parameters.put(TCK_REVISION_PARAMETER, revision);
        }
    }

    public void loadParameters(File file) throws IOException {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("File not found!");
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            this.loadParameters(stream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public void loadParameters(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        this.setParameters(IOUtils.readAllLinesAsMap((InputStream)stream));
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTCKTimestamp() {
        InputStream stream = this.getClass().getResourceAsStream(TCK_BUILD_TIMESTAMP);
        if (stream != null) {
            try {
                String string = IOUtils.readAllLines((InputStream)stream, (int)1000);
                return string;
            }
            catch (IOException e) {
                String string = "";
                return string;
            }
            finally {
                IOUtils.closeQuietly((Closeable)stream);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadTCKRevision() {
        InputStream stream = this.getClass().getResourceAsStream(TCK_REVISION);
        if (stream != null) {
            try {
                String revStr = IOUtils.readFirstLine((InputStream)stream);
                String string = String.valueOf(Integer.parseInt(revStr.trim()));
                return string;
            }
            catch (NumberFormatException e) {
                String string = null;
                return string;
            }
            catch (IOException e) {
                String string = null;
                return string;
            }
            finally {
                IOUtils.closeQuietly((Closeable)stream);
            }
        }
        return null;
    }

    public void loadDefaultTckGroups() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream(DEFAULT_TCK_GROUPS);
        if (stream != null) {
            try {
                this.loadGroups(stream);
            }
            finally {
                IOUtils.closeQuietly((Closeable)stream);
            }
        }
    }

    public void loadGroups(File file) throws Exception {
        if (file == null || !file.isFile()) {
            throw new IllegalArgumentException("File not found!");
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            this.loadGroups(stream);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public void loadGroups(InputStream stream) throws Exception {
        if (stream == null) {
            throw new IllegalArgumentException("Stream is null!");
        }
        for (String groupName : IOUtils.readAllLinesAsList((InputStream)stream, (int)10000)) {
            this.addGroup(groupName);
        }
    }

    public void addGroups(String[] groupClasses) throws Exception {
        if (groupClasses == null) {
            return;
        }
        for (String groupClass : groupClasses) {
            this.addGroup(groupClass);
        }
    }

    public void addGroup(String groupClass) throws Exception {
        if (groupClass == null) {
            return;
        }
        if ((groupClass = groupClass.trim()).length() == 0) {
            return;
        }
        Class clazz = ClassLoaderUtil.loadClass((String)groupClass);
        Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        CmisTestGroup group = null;
        if (o instanceof CmisTestGroup) {
            group = (CmisTestGroup)o;
        } else if (o instanceof CmisTest) {
            group = new WrapperCmisTestGroup((CmisTest)o);
        } else {
            throw new InstantiationException("Not a CmisTestGroup or CmisTest class!");
        }
        this.addGroup(group);
    }

    public void addGroup(CmisTestGroup group) throws Exception {
        if (group != null) {
            group.init(this.parameters);
            this.groups.add(group);
        }
    }

    public List<CmisTestGroup> getGroups() {
        return this.groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CmisTestProgressMonitor monitor) throws Exception {
        AbstractRunner abstractRunner = this;
        synchronized (abstractRunner) {
            this.isCanceled = false;
        }
        for (CmisTestGroup group : this.groups) {
            AbstractRunner abstractRunner2 = this;
            synchronized (abstractRunner2) {
                if (this.isCanceled) {
                    break;
                }
            }
            if (group == null || !group.isEnabled()) continue;
            group.setProgressMonitor(monitor);
            group.run();
        }
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void cancel() {
        this.isCanceled = true;
    }
}

