/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class CreateAndDeleteFolderTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Folder Test");
        this.setDescription("Creates a few folders, checks the newly created folders and their parent and finally deletes the created folders.");
    }

    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            this.testFolderList(session, testFolder, 20);
            this.testDeepHierarchy(session, testFolder, 20);
        }
        finally {
            this.deleteTestFolder();
        }
    }

    private void testFolderList(Session session, Folder testFolder, int numOfFolders) {
        CmisTestResultImpl f;
        HashMap<String, Folder> folders = new HashMap<String, Folder>();
        for (int i = 0; i < numOfFolders; ++i) {
            Folder newFolder = this.createFolder(session, testFolder, "folder" + i);
            folders.put(newFolder.getId(), newFolder);
        }
        this.addResult(this.checkChildren(session, testFolder, "Test folder children check"));
        ItemIterable children = testFolder.getChildren(SELECT_ALL_NO_CACHE_OC);
        ArrayList<String> childrenIds = new ArrayList<String>();
        for (CmisObject child : children) {
            if (child == null) continue;
            childrenIds.add(child.getId());
            Folder folder = (Folder)folders.get(child.getId());
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder and test folder child don't match! Id: " + child.getId());
            this.addResult(this.assertShallowEquals((CmisObject)folder, child, null, f));
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Number of created folders does not match the number of existing folders!");
        this.addResult(this.assertEquals(numOfFolders, childrenIds.size(), null, (CmisTestResult)f));
        for (Folder folder : folders.values()) {
            if (childrenIds.contains(folder.getId())) continue;
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Created folder not found in test folder children! Id: " + folder.getId()));
        }
        for (Folder folder : folders.values()) {
            folder.delete(true);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder should not exist anymore but it is still there! Id: " + folder.getId());
            this.addResult(this.assertIsFalse(this.exists((CmisObject)folder), null, f));
        }
        this.addResult(this.createInfoResult("Tested the creation and deletion of " + numOfFolders + " folders."));
    }

    private void testDeepHierarchy(Session session, Folder testFolder, int depth) {
        String folderName = "depth";
        StringBuilder path = new StringBuilder(testFolder.getPath());
        for (int i = 0; i < depth; ++i) {
            path.append('/');
            path.append(folderName + i);
        }
        ObjectId deepestFolderId = session.createPath((ObjectId)testFolder, path.toString(), this.getFolderTestTypeId());
        Folder deepestFolder = (Folder)session.getObject(deepestFolderId, SELECT_ALL_NO_CACHE_OC);
        String testPath = deepestFolder.getPath();
        for (int i = 0; i < depth; ++i) {
            CmisObject folderObj = session.getObjectByPath(testPath, SELECT_ALL_NO_CACHE_OC);
            if (folderObj instanceof Folder) {
                session.deleteByPath(((Folder)folderObj).getPath());
            } else {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Just created folder is not a folder! Id: " + folderObj.getId()));
            }
            testPath = testPath.substring(0, testPath.lastIndexOf("/"));
        }
        this.addResult(this.createInfoResult("Tested the creation of a folder hierarchy with a depth of " + (depth + 1) + " below the test folder."));
    }
}

