/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class CreateAndDeletePolicyTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create and Delete Policy Test");
        this.setDescription("Creates a policy object, checks the newly created policy object, applys and removes it from a document, and finally deletes the created policy object.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        if (this.hasPolicies(session)) {
            Folder testFolder = this.createTestFolder(session);
            try {
                Policy policy = this.createPolicy(session, testFolder, "testPolicy", "TCK Test Policy");
                Document doc = this.createDocument(session, testFolder, "testDocument", "Policy Test");
                if (Boolean.TRUE.equals(doc.getType().isControllablePolicy())) {
                    doc.applyPolicy(new ObjectId[]{policy});
                    List policies1 = doc.getPolicies();
                    boolean found1 = false;
                    for (Policy p : policies1) {
                        if (!p.getId().equals(policy.getId())) continue;
                        found1 = true;
                        break;
                    }
                    CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Policy has not been applied to document! Policy Id: " + policy.getId() + ", Doc Id: " + doc.getId());
                    this.addResult(this.assertIsTrue(found1, null, f));
                    f = this.createResult(CmisTestResultStatus.WARNING, "Not all policy IDs can be resolved to policy objects.");
                    this.addResult(this.assertEquals(doc.getPolicyIds().size(), doc.getPolicies().size(), null, (CmisTestResult)f));
                    List policiesData2 = session.getBinding().getPolicyService().getAppliedPolicies(session.getRepositoryInfo().getId(), doc.getId(), "*", null);
                    boolean found2 = false;
                    if (policiesData2 != null && !policiesData2.isEmpty()) {
                        for (ObjectData p : policiesData2) {
                            if (!p.getId().equals(policy.getId())) continue;
                            found2 = true;
                            break;
                        }
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Applied policy is not returned by the repository! Policy Id: " + policy.getId() + ", Doc Id: " + doc.getId());
                    this.addResult(this.assertIsTrue(found2, null, f));
                    doc.removePolicy(new ObjectId[]{policy});
                    List policies3 = doc.getPolicies();
                    if (policies3 != null) {
                        boolean found3 = false;
                        for (Policy p : policies3) {
                            if (!p.getId().equals(policy.getId())) continue;
                            found3 = true;
                            break;
                        }
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Policy has not been removed from document! Policy Id: " + policy.getId() + ", Doc Id: " + doc.getId());
                        this.addResult(this.assertIsFalse(found3, null, f));
                    }
                } else {
                    this.addResult(this.createResult(CmisTestResultStatus.INFO, "Document type " + doc.getType().getId() + " does not allow applying and removing policies. Choose a different document type for this test."));
                }
                this.deleteObject((CmisObject)doc);
                this.deleteObject((CmisObject)policy);
            }
            finally {
                this.deleteTestFolder();
            }
        } else {
            this.addResult(this.createResult(CmisTestResultStatus.SKIPPED, "Policies not supported. Test skipped!"));
        }
    }
}

