/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.query;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.tests.query.AbstractQueryTest;

public class InvalidQueryTest
extends AbstractQueryTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Invalid Query Test");
        this.setDescription("Tests invalid queries.");
    }

    @Override
    public void run(Session session) {
        if (this.supportsQuery(session)) {
            this.doInvalidQuery(session, "");
            this.doInvalidQuery(session, "SELECT");
            this.doInvalidQuery(session, "SELECT *");
            this.doInvalidQuery(session, "THIS_IS_NOT_A_SELECT");
            this.doInvalidQuery(session, "SELECT FROM cmis:document");
            this.doInvalidQuery(session, "SELECT ,cmis:name FROM cmis:document");
        } else {
            try {
                this.doQuery(session, "SELECT * FROM cmis:document");
                this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Query capability is set to 'none' but calling query() works."));
            }
            catch (CmisNotSupportedException cmisNotSupportedException) {
            }
            catch (CmisObjectNotFoundException onfe) {
                if (this.getBinding() != BindingType.ATOMPUB) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Query capability is set to 'none' but calling query() throws an exception, which is not a notSupported exception(" + onfe.toString() + ").", onfe, false));
                }
            }
            catch (Exception ex) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Query capability is set to 'none' but calling query() throws an exception, which is not a notSupported exception(" + ex.toString() + ").", ex, false));
            }
        }
    }

    private void doQuery(Session session, String stmt) {
        for (QueryResult qr : session.query(stmt, false)) {
            qr.getPropertyByQueryName("cmis:name");
        }
    }

    private void doInvalidQuery(Session session, String stmt) {
        try {
            this.doQuery(session, stmt);
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "This query is invalid but has been accepted: " + stmt));
        }
        catch (CmisInvalidArgumentException cmisInvalidArgumentException) {
        }
        catch (Exception ex) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "This query is invalid and an unexpected exception (" + ex.toString() + ") has been thrown: \"" + stmt + "\"", ex, false));
        }
    }
}

