/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.comparetovalidator;

import java.util.Comparator;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.shared_tomahawk.util.MessageUtils;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;
import org.apache.myfaces.validator.ValidatorBase;

public class CompareToValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.validator.CompareTo";
    public static final String COMPARE_TO_MESSAGE_ID = "{0} value <{1}> must be {2} {3} value <{4}>";
    protected String _foreignComponentName = null;
    protected String _operator = null;
    protected Object _comparator = null;
    protected String _alternateOperatorName = null;
    public static final String OPERATOR_EQUALS = "eq";
    public static final String OPERATOR_NOT_EQUALS = "ne";
    public static final String OPERATOR_GREATER_THAN = "gt";
    public static final String OPERATOR_LESS_THAN = "lt";
    public static final String OPERATOR_GREATER_THAN_OR_EQUALS = "ge";
    public static final String OPERATOR_LESS_THAN_OR_EQUALS = "le";
    public static final String OPERATOR_EQUALS_ALT = "==";
    public static final String OPERATOR_NOT_EQUALS_ALT = "!=";
    public static final String OPERATOR_GREATER_THAN_ALT = ">";
    public static final String OPERATOR_LESS_THAN_ALT = "<";
    public static final String OPERATOR_GREATER_THAN_OR_EQUALS_ALT = ">=";
    public static final String OPERATOR_LESS_THAN_OR_EQUALS_ALT = "<=";
    public static final String OPERATOR_EQUALS_ALT2 = "=";
    static /* synthetic */ Class class$java$lang$Comparable;
    static /* synthetic */ Class class$java$util$Comparator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    protected String getOperatorForString(String operatorSpecified) {
        if (OPERATOR_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_EQUALS;
        }
        if (OPERATOR_NOT_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_NOT_EQUALS;
        }
        if (OPERATOR_GREATER_THAN.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN;
        }
        if (OPERATOR_LESS_THAN.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN;
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN_OR_EQUALS;
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN_OR_EQUALS;
        }
        if (OPERATOR_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_EQUALS;
        }
        if (OPERATOR_NOT_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_NOT_EQUALS;
        }
        if (OPERATOR_GREATER_THAN_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN;
        }
        if (OPERATOR_LESS_THAN_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN;
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_GREATER_THAN_OR_EQUALS;
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS_ALT.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_LESS_THAN_OR_EQUALS;
        }
        if (OPERATOR_EQUALS_ALT2.equalsIgnoreCase(operatorSpecified)) {
            return OPERATOR_EQUALS;
        }
        throw new IllegalStateException("Operator has unknown value of '" + operatorSpecified + "'");
    }

    protected String nameForOperator(String operator) {
        if (OPERATOR_EQUALS == operator) {
            return "equal to";
        }
        if (OPERATOR_NOT_EQUALS == operator) {
            return "inequal to";
        }
        if (OPERATOR_GREATER_THAN == operator) {
            return "greater than";
        }
        if (OPERATOR_LESS_THAN == operator) {
            return "less than";
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS == operator) {
            return "greater than or equal to";
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS == operator) {
            return "less than or equal to";
        }
        throw new IllegalStateException("Operator has unknown value of '" + operator + "'");
    }

    protected boolean validateOperatorOnComparisonResult(String operator, int result) {
        if (OPERATOR_EQUALS == operator) {
            return result == 0;
        }
        if (OPERATOR_NOT_EQUALS == operator) {
            return result != 0;
        }
        if (OPERATOR_GREATER_THAN == operator) {
            return result > 0;
        }
        if (OPERATOR_LESS_THAN == operator) {
            return result < 0;
        }
        if (OPERATOR_GREATER_THAN_OR_EQUALS == operator) {
            return result >= 0;
        }
        if (OPERATOR_LESS_THAN_OR_EQUALS == operator) {
            return result <= 0;
        }
        throw new IllegalStateException("Operator has unknown value of '" + operator + "'");
    }

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        block18: {
            Comparator comparator;
            if (facesContext == null) {
                throw new NullPointerException("facesContext");
            }
            if (uiComponent == null) {
                throw new NullPointerException("uiComponent");
            }
            if (value == null) {
                return;
            }
            String foreignComponentName = this.getFor();
            UIComponent foreignComponent = uiComponent.getParent().findComponent(foreignComponentName);
            if (foreignComponent == null) {
                throw new FacesException("Unable to find component '" + foreignComponentName + "' (calling findComponent on component '" + uiComponent.getId() + "')");
            }
            if (!(foreignComponent instanceof EditableValueHolder)) {
                throw new FacesException("Component '" + foreignComponent.getId() + "' does not implement EditableValueHolder");
            }
            EditableValueHolder foreignEditableValueHolder = (EditableValueHolder)foreignComponent;
            if (foreignEditableValueHolder.isRequired() && foreignEditableValueHolder.getValue() == null) {
                return;
            }
            Object foreignValue = foreignEditableValueHolder.isValid() ? foreignEditableValueHolder.getValue() : this.getConvertedValueNonValid(facesContext, foreignComponent);
            if (null == foreignValue) {
                return;
            }
            String operator = this.getOperatorForString(this.getOperator());
            String alternateOperatorName = this.getAlternateOperatorName();
            Object[] args = new Object[]{uiComponent.getId(), value.toString(), alternateOperatorName == null ? this.nameForOperator(operator) : alternateOperatorName, foreignComponent.getId(), foreignValue == null ? foreignComponent.getId() : foreignValue.toString()};
            String message = this.getMessage();
            if (null == message) {
                message = COMPARE_TO_MESSAGE_ID;
            }
            if (null != (comparator = this.createComparator())) {
                if (!this.validateOperatorOnComparisonResult(operator, comparator.compare(value, foreignValue))) {
                    throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)message, (Object[])args));
                }
            } else {
                if (value instanceof Comparable && foreignValue instanceof Comparable) {
                    try {
                        if (!this.validateOperatorOnComparisonResult(operator, ((Comparable)value).compareTo(foreignValue))) {
                            throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)message, (Object[])args));
                        }
                        break block18;
                    }
                    catch (RuntimeException exception) {
                        if (exception instanceof ValidatorException) {
                            throw exception;
                        }
                        throw new ValidatorException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)(message + ": " + exception.getLocalizedMessage()), (Object[])args));
                    }
                }
                if (value instanceof Comparable) {
                    throw new ClassCastException(this.getClassCastExceptionMessage(foreignComponent.getId(), class$java$lang$Comparable == null ? (class$java$lang$Comparable = CompareToValidator.class$("java.lang.Comparable")) : class$java$lang$Comparable, foreignValue));
                }
                if (foreignValue instanceof Comparable) {
                    throw new ClassCastException(this.getClassCastExceptionMessage(uiComponent.getId(), class$java$lang$Comparable == null ? (class$java$lang$Comparable = CompareToValidator.class$("java.lang.Comparable")) : class$java$lang$Comparable, value));
                }
            }
        }
    }

    protected String getClassCastExceptionMessage(String name, Class clazz, Object object) {
        if (null == object) {
            return name + " must be type " + clazz + " but is null";
        }
        return name + " must be type " + clazz + " but is type " + object.getClass();
    }

    protected Comparator createComparator() {
        Object comparator = this.getComparator();
        if (null == comparator) {
            return null;
        }
        if (!(comparator instanceof Comparator)) {
            throw new ClassCastException(this.getClassCastExceptionMessage("comparator", class$java$util$Comparator == null ? (class$java$util$Comparator = CompareToValidator.class$("java.util.Comparator")) : class$java$util$Comparator, comparator));
        }
        return (Comparator)comparator;
    }

    public String getFor() {
        if (this._foreignComponentName != null) {
            return this._foreignComponentName;
        }
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? _ComponentUtils.getStringValue((FacesContext)this.getFacesContext(), (ValueBinding)vb) : null;
    }

    public void setFor(String string) {
        this._foreignComponentName = string;
    }

    public String getOperator() {
        if (this._operator != null) {
            return this._operator;
        }
        ValueBinding vb = this.getValueBinding("operator");
        return vb != null ? _ComponentUtils.getStringValue((FacesContext)this.getFacesContext(), (ValueBinding)vb) : null;
    }

    public void setOperator(String operator) {
        this._operator = operator;
    }

    public Object getComparator() {
        if (this._comparator != null) {
            return this._comparator;
        }
        ValueBinding vb = this.getValueBinding("comparator");
        return vb != null ? (Comparator)vb.getValue(this.getFacesContext()) : null;
    }

    public void setComparator(Object comparator) {
        this._comparator = comparator;
    }

    public String getAlternateOperatorName() {
        if (this._alternateOperatorName != null) {
            return this._alternateOperatorName;
        }
        ValueBinding vb = this.getValueBinding("alternateOperatorName");
        return vb != null ? _ComponentUtils.getStringValue((FacesContext)this.getFacesContext(), (ValueBinding)vb) : null;
    }

    public void setAlternateOperatorName(String alternateOperatorName) {
        this._alternateOperatorName = alternateOperatorName;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._foreignComponentName, this._operator, this._comparator, this._alternateOperatorName};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._foreignComponentName = (String)values[1];
        this._operator = (String)values[2];
        this._comparator = values[3];
        this._alternateOperatorName = (String)values[4];
    }

    protected Renderer getRenderer(FacesContext context, UIComponent foreignComponent) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        String rendererType = foreignComponent.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        Renderer renderer = renderKit.getRenderer(foreignComponent.getFamily(), rendererType);
        if (renderer == null) {
            this.getFacesContext().getExternalContext().log("No Renderer found for component " + foreignComponent + " (component-family=" + foreignComponent.getFamily() + ", renderer-type=" + rendererType + ")");
        }
        return renderer;
    }

    protected Converter findUIOutputConverter(FacesContext facesContext, UIComponent component) {
        Converter converter = ((EditableValueHolder)component).getConverter();
        if (converter != null) {
            return converter;
        }
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(facesContext);
        if (valueType == null) {
            return null;
        }
        if ((class$java$lang$String == null ? (class$java$lang$String = CompareToValidator.class$("java.lang.String")) : class$java$lang$String).equals(valueType)) {
            return null;
        }
        if ((class$java$lang$Object == null ? (class$java$lang$Object = CompareToValidator.class$("java.lang.Object")) : class$java$lang$Object).equals(valueType)) {
            return null;
        }
        try {
            return facesContext.getApplication().createConverter(valueType);
        }
        catch (FacesException e) {
            this.getFacesContext().getExternalContext().log("No Converter for type " + valueType.getName() + " found", (Throwable)e);
            return null;
        }
    }

    protected Object getConvertedValueNonValid(FacesContext facesContext, UIComponent component) {
        Object componentValueObject;
        Object submittedValue = ((EditableValueHolder)component).getSubmittedValue();
        if (submittedValue == null) {
            componentValueObject = null;
        } else {
            try {
                Converter converter;
                Renderer renderer = this.getRenderer(facesContext, component);
                if (renderer != null) {
                    componentValueObject = renderer.getConvertedValue(facesContext, component, submittedValue);
                } else if (submittedValue instanceof String && (converter = this.findUIOutputConverter(facesContext, component)) != null) {
                    componentValueObject = converter.getAsObject(facesContext, component, (String)submittedValue);
                }
            }
            catch (ConverterException e) {
                // empty catch block
            }
            componentValueObject = submittedValue;
        }
        return componentValueObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

