/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.conversation;

import java.util.Collection;
import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;
import org.apache.myfaces.custom.conversation.ConversationManager;
import org.apache.myfaces.custom.conversation.ConversationUtils;

public class EndConversationMethodBindingFacade
extends MethodBinding
implements StateHolder {
    private MethodBinding original;
    private String conversationName;
    private Collection onOutcomes;
    private String errorOutcome;
    private Boolean restart;
    private MethodBinding restartAction;
    private boolean _transient = false;

    public EndConversationMethodBindingFacade() {
    }

    public EndConversationMethodBindingFacade(String conversation, Collection onOutcomes, MethodBinding original, String errorOutcome, Boolean restart, MethodBinding restartAction) {
        this.original = original;
        this.conversationName = conversation;
        this.onOutcomes = onOutcomes;
        this.errorOutcome = errorOutcome;
        this.restart = restart;
        this.restartAction = restartAction;
    }

    public String getConversationName() {
        return this.conversationName;
    }

    public String getExpressionString() {
        if (this.original == null) {
            return null;
        }
        return this.original.getExpressionString();
    }

    public Class getType(FacesContext context) throws MethodNotFoundException {
        if (this.original == null) {
            return null;
        }
        return this.original.getType(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(FacesContext context, Object[] values) throws EvaluationException, MethodNotFoundException {
        boolean ok = false;
        Object returnValue = null;
        try {
            try {
                if (this.original != null) {
                    returnValue = this.original.invoke(context, values);
                }
                ok = true;
            }
            catch (Throwable t) {
                ConversationManager conversationManager = ConversationManager.getInstance(context);
                conversationManager.purgePersistence();
                if (this.errorOutcome == null) throw new FacesException(t);
                conversationManager.getMessager().setConversationException(context, t);
                returnValue = this.errorOutcome;
                Object var8_6 = null;
                boolean end = true;
                if (!ok) return returnValue;
                if (this.onOutcomes != null && this.onOutcomes.size() > 0) {
                    end = this.onOutcomes.contains(returnValue);
                }
                if (!end) return returnValue;
                ConversationUtils.endAndRestartConversation(context, this.conversationName, this.restart, this.restartAction);
                return returnValue;
            }
            Object var8_5 = null;
            boolean end = true;
            if (!ok) return returnValue;
            if (this.onOutcomes != null && this.onOutcomes.size() > 0) {
                end = this.onOutcomes.contains(returnValue);
            }
            if (!end) return returnValue;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            boolean end = true;
            if (!ok) throw throwable;
            if (this.onOutcomes != null && this.onOutcomes.size() > 0) {
                end = this.onOutcomes.contains(returnValue);
            }
            if (!end) throw throwable;
            ConversationUtils.endAndRestartConversation(context, this.conversationName, this.restart, this.restartAction);
            throw throwable;
        }
        ConversationUtils.endAndRestartConversation(context, this.conversationName, this.restart, this.restartAction);
        return returnValue;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public void restoreState(FacesContext context, Object states) {
        Object[] state = (Object[])states;
        this.original = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[0]);
        this.conversationName = (String)state[1];
        this.onOutcomes = (Collection)state[2];
        this.errorOutcome = (String)state[3];
        this.restart = (Boolean)state[4];
        this.restartAction = (MethodBinding)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state[5]);
    }

    public Object saveState(FacesContext context) {
        return new Object[]{UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.original), this.conversationName, this.onOutcomes, this.errorOutcome, this.restart, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.restartAction)};
    }
}

