/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.convertboolean;

import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.ConverterTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.myfaces.custom.convertboolean.BooleanConverter;

public class ConvertBooleanTag
extends ConverterTag {
    private static final long serialVersionUID = 1L;
    private String trueValue;
    private String falseValue;

    public ConvertBooleanTag() {
        this.setConverterId(BooleanConverter.CONVERTER_ID);
    }

    public String getFalseValue() {
        return this.falseValue;
    }

    public void setFalseValue(String falseValue) {
        this.falseValue = falseValue;
    }

    public String getTrueValue() {
        return this.trueValue;
    }

    public void setTrueValue(String trueValue) {
        this.trueValue = trueValue;
    }

    public void setPageContext(PageContext context) {
        super.setPageContext(context);
        this.setConverterId(BooleanConverter.CONVERTER_ID);
    }

    protected Converter createConverter() throws JspException {
        BooleanConverter converter = (BooleanConverter)super.createConverter();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ConvertBooleanTag.setConverterTrueValue(facesContext, converter, this.trueValue);
        ConvertBooleanTag.setConverterFalseValue(facesContext, converter, this.falseValue);
        return converter;
    }

    private static void setConverterTrueValue(FacesContext facesContext, BooleanConverter converter, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setTrueValue((String)vb.getValue(facesContext));
        } else {
            converter.setTrueValue(value);
        }
    }

    private static void setConverterFalseValue(FacesContext facesContext, BooleanConverter converter, String value) {
        if (value == null) {
            return;
        }
        if (UIComponentTag.isValueReference((String)value)) {
            ValueBinding vb = facesContext.getApplication().createValueBinding(value);
            converter.setFalseValue((String)vb.getValue(facesContext));
        } else {
            converter.setFalseValue(value);
        }
    }
}

