/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.form;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.custom.clientvalidation.common.CVUtils;
import org.apache.myfaces.custom.form.HtmlForm;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlFormRendererBase;

public class HtmlFormRenderer
extends HtmlFormRendererBase {
    private static String CLIENT_VALIDATON_SCRIPT = "return tomahawk.executeClientLifeCycle();";

    protected String getActionUrl(FacesContext facesContext, UIForm form) {
        String actionUrl = this.getActionUrl(facesContext);
        if (form instanceof HtmlForm) {
            Object request;
            HtmlForm htmlForm = (HtmlForm)form;
            if (htmlForm.getAction() != null) {
                return htmlForm.getAction();
            }
            String scheme = htmlForm.getScheme();
            String serverName = htmlForm.getServerName();
            Integer portObj = htmlForm.getPort();
            if ((scheme != null || serverName != null || portObj != null) && (request = facesContext.getExternalContext().getRequest()) instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                int serverPort = 0;
                serverPort = portObj == null ? httpRequest.getServerPort() : portObj.intValue();
                if (scheme == null) {
                    scheme = httpRequest.getScheme();
                } else if (portObj == null) {
                    serverPort = 0;
                }
                if (serverName == null) {
                    serverName = httpRequest.getServerName();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(scheme);
                sb.append("://");
                sb.append(serverName);
                if (serverPort != 0 && ("http".equals(scheme) && serverPort != 80 || "https".equals(scheme) && serverPort != 443)) {
                    sb.append(":");
                    sb.append(serverPort);
                }
                sb.append(actionUrl);
                actionUrl = sb.toString();
            }
        }
        return actionUrl;
    }

    protected String getMethod(FacesContext facesContext, UIForm form) {
        String method;
        if (form instanceof HtmlForm && (method = ((HtmlForm)form).getMethod()) != null) {
            return method;
        }
        return "post";
    }

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (CVUtils.isCVEnabled() && !this.isDecorated(facesContext, component)) {
            this.decorateOnSubmit(facesContext, component);
        }
        super.encodeBegin(facesContext, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        super.encodeEnd(facesContext, component);
        if (CVUtils.isCVEnabled()) {
            CVUtils.encodeJavascript(facesContext);
            CVUtils.queueCVCalls((UIComponent)facesContext.getViewRoot());
            CVUtils.encodeValidationScript(facesContext);
        }
    }

    private boolean isDecorated(FacesContext facesContext, UIComponent child) {
        String onSubmit = (String)child.getAttributes().get("onsubmit");
        return onSubmit != null && onSubmit.indexOf(CLIENT_VALIDATON_SCRIPT) != -1;
    }

    private void decorateOnSubmit(FacesContext facesContext, UIComponent child) {
        String onSubmitEvent = (String)child.getAttributes().get("onsubmit");
        if (onSubmitEvent == null) {
            child.getAttributes().put("onsubmit", CLIENT_VALIDATON_SCRIPT);
        } else {
            child.getAttributes().put("onsubmit", onSubmitEvent + ";" + CLIENT_VALIDATON_SCRIPT);
        }
    }
}

