/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.ifmessage;

import java.io.IOException;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

public class IfMessage
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.IfMessage";
    public static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.IfMessageRenderer";
    public static final String COMPONENT_FAMILY = "javax.faces.Panel";
    private String _for;

    public IfMessage() {
        super.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public String getFor() {
        if (this._for != null) {
            return this._for;
        }
        ValueBinding vb = this.getValueBinding("for");
        return vb != null ? (String)vb.getValue(FacesContext.getCurrentInstance()) : null;
    }

    public void setFor(String forValue) {
        this._for = forValue;
    }

    private boolean isMessageForId(String id) {
        UIComponent component = this.findComponent(id);
        if (component != null) {
            String clientId = component.getClientId(FacesContext.getCurrentInstance());
            return FacesContext.getCurrentInstance().getMessages(clientId).hasNext();
        }
        return false;
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(this.getFor(), ",");
        while (tokenizer.hasMoreTokens()) {
            if (!this.isMessageForId(tokenizer.nextToken().trim())) continue;
            super.encodeChildren(context);
            break;
        }
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._for};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._for = (String)values[1];
    }
}

