/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.loadbundle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.loadbundle.FacesEventWrapper;
import org.apache.myfaces.custom.loadbundle.LoadBundle;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class LoadBundle
extends UIComponentBase
implements StateHolder {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$custom$loadbundle$LoadBundle == null ? (class$org$apache$myfaces$custom$loadbundle$LoadBundle = LoadBundle.class$("org.apache.myfaces.custom.loadbundle.LoadBundle")) : class$org$apache$myfaces$custom$loadbundle$LoadBundle));
    public static final String COMPONENT_TYPE = "org.apache.myfaces.LoadBundle";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.LoadBundle";
    private String basename;
    private String var;
    private boolean alreadyLoaded = false;
    static /* synthetic */ Class class$org$apache$myfaces$custom$loadbundle$LoadBundle;

    public String getFamily() {
        return "org.apache.myfaces.LoadBundle";
    }

    public String getBasename() {
        if (this.basename != null) {
            return this.basename;
        }
        ValueBinding vb = this.getValueBinding("basename");
        return vb != null ? _ComponentUtils.getStringValue((FacesContext)this.getFacesContext(), (ValueBinding)vb) : null;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public String getVar() {
        if (this.var != null) {
            return this.var;
        }
        ValueBinding vb = this.getValueBinding("var");
        return vb != null ? _ComponentUtils.getStringValue((FacesContext)this.getFacesContext(), (ValueBinding)vb) : null;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.basename = (String)values[0];
        this.var = (String)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.basename, this.var};
        return values;
    }

    public Object processSaveState(FacesContext context) {
        return super.processSaveState(context);
    }

    public void processRestoreState(FacesContext context, Object state) {
        super.processRestoreState(context, state);
    }

    public void processValidators(FacesContext context) {
        this.loadBundle();
        super.processValidators(context);
    }

    public void processDecodes(FacesContext context) {
        this.loadBundle();
        super.processDecodes(context);
    }

    public void processUpdates(FacesContext context) {
        this.loadBundle();
        super.processUpdates(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.loadBundle();
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public void queueEvent(FacesEvent event) {
        super.queueEvent((FacesEvent)new FacesEventWrapper(event, (UIComponent)this));
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        this.loadBundle();
        if (event instanceof FacesEventWrapper) {
            FacesEvent originalEvent = ((FacesEventWrapper)event).getWrappedFacesEvent();
            originalEvent.getComponent().broadcast(originalEvent);
        } else {
            super.broadcast(event);
        }
    }

    public void loadBundle() {
        if (this.alreadyLoaded) {
            return;
        }
        this.resolveBundle(this.getBasename());
        this.alreadyLoaded = true;
    }

    private void resolveBundle(String resolvedBasename) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot == null) {
            throw new IllegalStateException("No view root! LoadBundle must be nested inside <f:view> action.");
        }
        Locale locale = viewRoot.getLocale();
        if (locale == null) {
            locale = facesContext.getApplication().getDefaultLocale();
        }
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(resolvedBasename, locale, Thread.currentThread().getContextClassLoader());
            facesContext.getExternalContext().getRequestMap().put(this.getVar(), new BundleMap(bundle));
        }
        catch (MissingResourceException e) {
            log.error((Object)("Resource bundle '" + resolvedBasename + "' could not be found."));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BundleMap
    implements Map {
        private ResourceBundle _bundle;
        private List _values;

        public BundleMap(ResourceBundle bundle) {
            this._bundle = bundle;
        }

        public Object get(Object key) {
            try {
                return this._bundle.getObject(key.toString());
            }
            catch (Exception e) {
                return "MISSING: " + key + " :MISSING";
            }
        }

        public boolean isEmpty() {
            return !this._bundle.getKeys().hasMoreElements();
        }

        public boolean containsKey(Object key) {
            try {
                return this._bundle.getObject(key.toString()) != null;
            }
            catch (MissingResourceException e) {
                return false;
            }
        }

        public Collection values() {
            if (this._values == null) {
                this._values = new ArrayList();
                Enumeration<String> enumer = this._bundle.getKeys();
                while (enumer.hasMoreElements()) {
                    String v = this._bundle.getString(enumer.nextElement());
                    this._values.add(v);
                }
            }
            return this._values;
        }

        public int size() {
            return this.values().size();
        }

        public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        public Set entrySet() {
            HashSet<1> set = new HashSet<1>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                String k = enumer.nextElement();
                set.add(new Map.Entry(this, k){
                    private final /* synthetic */ String val$k;
                    private final /* synthetic */ BundleMap this$0;
                    {
                        this.this$0 = this$0;
                        this.val$k = val$k;
                    }

                    public Object getKey() {
                        return this.val$k;
                    }

                    public Object getValue() {
                        return BundleMap.access$000(this.this$0).getObject(this.val$k);
                    }

                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
                    }
                });
            }
            return set;
        }

        public Set keySet() {
            HashSet<String> set = new HashSet<String>();
            Enumeration<String> enumer = this._bundle.getKeys();
            while (enumer.hasMoreElements()) {
                set.add(enumer.nextElement());
            }
            return set;
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public void putAll(Map t) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        public void clear() {
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }

        static /* synthetic */ ResourceBundle access$000(BundleMap x0) {
            return x0._bundle;
        }
    }
}

