/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.security;

public abstract class SecurityContext {
    public static final int AUTH_MODE_NONE = -1;
    public static final int AUTH_MODE_SINGLE = 0;
    public static final int AUTH_MODE_ALL = 1;
    public static final int AUTH_MODE_ANY = 2;
    public static final int AUTH_MODE_NOT = 3;
    private String[] roles;
    private int authMode = -1;

    public abstract String getAuthType();

    public abstract String getRemoteUser();

    public abstract boolean ifGranted(String var1);

    public boolean ifSingleGranted() {
        return this.ifGranted(this.roles[0]);
    }

    public boolean ifAllGranted() {
        boolean isAuthorized = false;
        for (int i = 0; i < this.roles.length; ++i) {
            String role = this.roles[i];
            if (!this.ifGranted(role)) {
                isAuthorized = false;
                break;
            }
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public boolean ifAnyGranted() {
        boolean isAuthorized = false;
        for (int i = 0; i < this.roles.length; ++i) {
            String role = this.roles[i];
            if (!this.ifGranted(role)) continue;
            isAuthorized = true;
            break;
        }
        return isAuthorized;
    }

    public boolean ifNotGranted() {
        boolean isAuthorized = false;
        for (int i = 0; i < this.roles.length; ++i) {
            String role = this.roles[i];
            if (this.ifGranted(role)) {
                isAuthorized = false;
                break;
            }
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public boolean inAuthMode() {
        return this.authMode != -1;
    }

    public int getAuthMode() {
        return this.authMode;
    }

    public void setAuthMode(int authMode) {
        this.authMode = authMode;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }
}

