/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.suggest;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItems;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.apache.myfaces.component.html.ext.HtmlInputHidden;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class InputSuggestRenderer
extends Renderer {
    private String NEW_TEXT_KEY = "-1";
    static /* synthetic */ Class class$org$apache$myfaces$custom$suggest$InputSuggestRenderer;

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        if (this.isDisabledOrReadOnly(component)) {
            return;
        }
        Map params = context.getExternalContext().getRequestParameterMap();
        String text = (String)params.get(this.getTextId(component, context));
        String choice = (String)params.get(this.getChoiceId(component, context));
        if (choice != null) {
            ((EditableValueHolder)component).setSubmittedValue((Object)choice);
            if (choice.equals(this.NEW_TEXT_KEY)) {
                Map choices = this.getChoices(component);
                choices.put(this.NEW_TEXT_KEY, text);
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        String value = (String)((EditableValueHolder)component).getSubmittedValue();
        if (value == null) {
            value = (String)((ValueHolder)component).getValue();
        }
        String text = null;
        Map choices = this.getChoices(component);
        if (value != null && choices != null) {
            text = (String)choices.get(value);
        }
        ResponseWriter out = context.getResponseWriter();
        this.renderInputField(out, text, this.getTextId(component, context), component);
        HtmlInputHidden hiddenChoice = new HtmlInputHidden();
        hiddenChoice.setId(this.getChoiceId(component, context));
        hiddenChoice.setValue((Object)value);
        hiddenChoice.getAttributes().put("forceId", Boolean.TRUE);
        hiddenChoice.encodeBegin(context);
        hiddenChoice.encodeEnd(context);
        this.encodeSuggestions(context, out, choices, this.getSuggestionsId(component, context), component);
        this.encodeStyles(component, context);
        this.encodeJavascript(component, context);
    }

    private void renderInputField(ResponseWriter out, String text, String clientId, UIComponent component) throws IOException {
        out.startElement("input", component);
        out.writeAttribute("name", (Object)clientId, null);
        out.writeAttribute("id", (Object)clientId, null);
        if (text != null) {
            out.writeAttribute("value", (Object)text, "value");
        } else {
            out.writeAttribute("value", (Object)"", "value");
        }
        component.getAttributes().put("autocomplete", "off");
        HtmlRendererUtils.renderHTMLAttributes((ResponseWriter)out, (UIComponent)component, (String[])HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (component instanceof HtmlInputText && ((HtmlInputText)component).isDisabled()) {
            out.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        out.endElement("input");
    }

    private void encodeSuggestions(FacesContext context, ResponseWriter out, Map choices, String clientId, UIComponent component) throws IOException {
        out.startElement("div", component);
        out.writeAttribute("id", (Object)clientId, null);
        Iterator i = choices.keySet().iterator();
        while (i.hasNext()) {
            String choice = (String)i.next();
            if (choice.compareTo("-1") == 0) continue;
            String text = (String)choices.get(choice);
            out.startElement("div", null);
            out.writeAttribute("id", (Object)(component.getClientId(context) + "_choice" + choice), null);
            out.writeAttribute("class", (Object)"ACdiv", null);
            out.writeText((Object)text, null);
            out.endElement("div");
        }
        out.endElement("div");
    }

    private boolean isDisabledOrReadOnly(UIComponent component) {
        Object readOnlyAttr;
        boolean disabled = false;
        boolean readOnly = false;
        Object disabledAttr = component.getAttributes().get("disabled");
        if (disabledAttr != null) {
            disabled = disabledAttr.equals(Boolean.TRUE);
        }
        if ((readOnlyAttr = component.getAttributes().get("readonly")) != null) {
            readOnly = readOnlyAttr.equals(Boolean.TRUE);
        }
        return disabled || readOnly;
    }

    private Map getChoices(UIComponent component) {
        Object choices = null;
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            UIComponent kid = (UIComponent)i.next();
            if (!(kid instanceof UISelectItems)) continue;
            choices = ((UISelectItems)kid).getValue();
        }
        return (Map)choices;
    }

    private void encodeStyles(UIComponent component, FacesContext context) throws IOException {
        AddResource addResource = AddResourceFactory.getInstance((FacesContext)context);
        String styleLocation = (String)component.getAttributes().get("org.apache.myfaces.STYLE_LOCATION");
        if (styleLocation == null) {
            addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, class$org$apache$myfaces$custom$suggest$InputSuggestRenderer == null ? (class$org$apache$myfaces$custom$suggest$InputSuggestRenderer = InputSuggestRenderer.class$("org.apache.myfaces.custom.suggest.InputSuggestRenderer")) : class$org$apache$myfaces$custom$suggest$InputSuggestRenderer, "css/suggest.css");
        } else {
            addResource.addStyleSheet(context, AddResource.HEADER_BEGIN, styleLocation + "/suggest.css");
        }
    }

    private void encodeJavascript(UIComponent component, FacesContext context) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        AddResource addResource = AddResourceFactory.getInstance((FacesContext)context);
        String javascriptLocation = (String)component.getAttributes().get("org.apache.myfaces.JAVASCRIPT_LOCATION");
        if (javascriptLocation == null) {
            addResource.addJavaScriptHere(context, class$org$apache$myfaces$custom$suggest$InputSuggestRenderer == null ? (class$org$apache$myfaces$custom$suggest$InputSuggestRenderer = InputSuggestRenderer.class$("org.apache.myfaces.custom.suggest.InputSuggestRenderer")) : class$org$apache$myfaces$custom$suggest$InputSuggestRenderer, "javascript/suggest.js");
        } else {
            addResource.addJavaScriptHere(context, javascriptLocation + "/suggest.js");
        }
        out.startElement("script", null);
        out.writeAttribute("type", (Object)"text/javascript", null);
        String textId = this.getTextId(component, context);
        String choiceId = this.getChoiceId(component, context);
        String suggestionsId = this.getSuggestionsId(component, context);
        String modifiedTextId = textId.replace(':', '_');
        modifiedTextId = modifiedTextId.replace('|', '_');
        modifiedTextId = modifiedTextId.replace('.', '_');
        out.writeText((Object)("\nvar " + modifiedTextId + "Row = -1; // this should always be initialized to -1\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "RowDiv = null; // this should always be initialized to null\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "MinRow = 0; // this should always be initialized to 0\n"), null);
        out.writeText((Object)"var ACrowHeight = 15;\n", null);
        out.writeText((Object)("var ACfield = document.getElementById('" + textId + "');\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "Scroll = true;\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "CaseSensitive = false;\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "DisplayRows = 5;\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "Div = document.getElementById('" + suggestionsId + "');\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "HiddenFldId = '" + choiceId + "';\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "NormalClass = 'ACdiv';\n"), null);
        out.writeText((Object)("var " + modifiedTextId + "HighlightClass = 'AChighlighted';\n"), null);
        out.writeText((Object)("ACfield.onfocus = new Function('" + modifiedTextId + "Div.style.visibility = \"visible\"');\n"), null);
        out.writeText((Object)"ACfield.onblur = new Function('blurACfld(this)');\n", null);
        out.writeText((Object)"ACfield.onkeyup = new Function(\"event\", \"return handleACkeyUp(this, event)\");\n", null);
        out.writeText((Object)"ACfield.onkeydown = new Function(\"event\", \"return handleACkeyDown(this, event)\");\n", null);
        out.writeText((Object)("var " + modifiedTextId + "Options = " + modifiedTextId + "Div.getElementsByTagName(\"DIV\");\n"), null);
        out.writeText((Object)(modifiedTextId + "Div.onscroll = new Function(\"setACfieldFocus('" + textId + "')\");\n"), null);
        out.writeText((Object)("var optLen = " + modifiedTextId + "Options.length;\n"), null);
        out.writeText((Object)"for (var ii=0; ii<optLen; ii++) {\n", null);
        out.writeText((Object)(modifiedTextId + "Options[ii].style.height = ACrowHeight + 'px';\n"), null);
        out.writeText((Object)(modifiedTextId + "Options[ii].onmouseover = new Function(\"highlightACDiv(this, '" + textId + "', \" + ii + \")\");\n"), null);
        out.writeText((Object)(modifiedTextId + "Options[ii].onmouseout = new Function(\"unHighlightACDiv(this, '" + textId + "')\");\n"), null);
        out.writeText((Object)(modifiedTextId + "Options[ii].onmousedown = new Function(\"selectACDiv('" + textId + "')\");\n"), null);
        out.writeText((Object)"}\n", null);
        out.writeText((Object)"if (navigator.appVersion.toLowerCase().indexOf('msie') != -1 && navigator.userAgent.toLowerCase().indexOf('opera') == -1)\n", null);
        out.writeText((Object)("document.writeln('<iframe id=\"" + modifiedTextId + "Shim\" src=\"javascript:false;\" " + "scrolling=\"no\" frameborder=\"0\" style=\"position:absolute; top:0px; left:0px;\">" + "</iframe>');\n"), null);
        out.endElement("script");
    }

    private String getTextId(UIComponent component, FacesContext context) {
        return component.getId() + "_text";
    }

    private String getChoiceId(UIComponent component, FacesContext context) {
        return component.getId() + "_choice";
    }

    private String getSuggestionsId(UIComponent component, FacesContext context) {
        return "AC" + this.getTextId(component, context);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

