/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.template;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlTemplate
extends UIComponentBase {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.tomahawk.XmlTemplate";
    public static final String COMPONENT_FAMILY = "org.apache.myfaces.tomahawk.Template";
    private String content;
    private String contentLocation;
    private Object contentStream;
    private String stylesheet;
    private String stylesheetLocation;
    private Object styleStream;
    static /* synthetic */ Class class$org$apache$myfaces$custom$template$XmlTemplate;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        URL url;
        ClassLoader loader;
        InputStream xmlStream = (InputStream)this.getContentStream();
        String xml = this.getContent();
        String xmlLocation = this.getContentLocation();
        InputStream xslStream = (InputStream)this.getStyleStream();
        String xsl = this.getStylesheet();
        String xslLocation = this.getStylesheetLocation();
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        if (this.getContent() == null && this.getContentLocation() == null && this.getContentStream() == null) {
            throw new NullPointerException("content/contentLocation/contentStream cannot all be null");
        }
        if (xmlLocation != null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = (class$org$apache$myfaces$custom$template$XmlTemplate == null ? (class$org$apache$myfaces$custom$template$XmlTemplate = XmlTemplate.class$("org.apache.myfaces.custom.template.XmlTemplate")) : class$org$apache$myfaces$custom$template$XmlTemplate).getClassLoader();
            }
            url = loader.getResource(xmlLocation);
            xmlStream = new FileInputStream(new File(url.getFile()));
        }
        if (xslLocation != null) {
            loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = (class$org$apache$myfaces$custom$template$XmlTemplate == null ? (class$org$apache$myfaces$custom$template$XmlTemplate = XmlTemplate.class$("org.apache.myfaces.custom.template.XmlTemplate")) : class$org$apache$myfaces$custom$template$XmlTemplate).getClassLoader();
            }
            url = loader.getResource(xslLocation);
            xslStream = new FileInputStream(new File(url.getFile()));
        }
        if (xml != null) {
            xmlStream = new ByteArrayInputStream(xml.getBytes());
        }
        if (xsl != null) {
            xslStream = new ByteArrayInputStream(xsl.getBytes());
        }
        if (xmlStream != null && xslStream != null) {
            this.transformContent(xmlStream, xslStream);
        }
    }

    private void transformContent(InputStream content, InputStream stylesheet) throws IOException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(stylesheet));
            ResponseWriter responseWriter = FacesContext.getCurrentInstance().getResponseWriter();
            transformer.transform(new StreamSource(content), new StreamResult((Writer)responseWriter));
        }
        catch (TransformerException te) {
            throw new IOException("Error while transforming XML: " + te.getMessage());
        }
    }

    public void encodeChildren(FacesContext context) throws IOException {
    }

    public void encodeEnd(FacesContext context) throws IOException {
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.content, this.contentLocation, this.stylesheet, this.stylesheetLocation};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.content = (String)values[1];
        this.contentLocation = (String)values[2];
        this.stylesheet = (String)values[3];
        this.stylesheetLocation = (String)values[4];
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        if (this.content != null) {
            return this.content;
        }
        ValueBinding vb = this.getValueBinding("content");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setContentLocation(String contentLocation) {
        this.contentLocation = contentLocation;
    }

    public String getContentLocation() {
        if (this.contentLocation != null) {
            return this.contentLocation;
        }
        ValueBinding vb = this.getValueBinding("contentLocation");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public String getStylesheet() {
        if (this.stylesheet != null) {
            return this.stylesheet;
        }
        ValueBinding vb = this.getValueBinding("stylesheet");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setContentStream(Object contentStream) {
        this.contentStream = contentStream;
    }

    public Object getContentStream() {
        if (this.contentStream != null) {
            return this.contentStream;
        }
        ValueBinding vb = this.getValueBinding("contentStream");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    public void setStylesheetLocation(String stylesheetLocation) {
        this.stylesheetLocation = stylesheetLocation;
    }

    public String getStylesheetLocation() {
        if (this.stylesheetLocation != null) {
            return this.stylesheetLocation;
        }
        ValueBinding vb = this.getValueBinding("stylesheetLocation");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : null;
    }

    public void setStyleStream(Object styleStream) {
        this.styleStream = styleStream;
    }

    public Object getStyleStream() {
        if (this.styleStream != null) {
            return this.styleStream;
        }
        ValueBinding vb = this.getValueBinding("styleStream");
        return vb != null ? vb.getValue(this.getFacesContext()) : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

