/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.toggle;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.toggle.ToggleGroup;
import org.apache.myfaces.custom.toggle.ToggleLink;
import org.apache.myfaces.custom.toggle.TogglePanel;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlGroupRendererBase;

public class TogglePanelRenderer
extends HtmlGroupRendererBase {
    static /* synthetic */ Class class$org$apache$myfaces$custom$toggle$TogglePanel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$apache$myfaces$custom$toggle$TogglePanelRenderer;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity((FacesContext)context, (UIComponent)component, (Class)(class$org$apache$myfaces$custom$toggle$TogglePanel == null ? (class$org$apache$myfaces$custom$toggle$TogglePanel = TogglePanelRenderer.class$("org.apache.myfaces.custom.toggle.TogglePanel")) : class$org$apache$myfaces$custom$toggle$TogglePanel));
        TogglePanel togglePanel = (TogglePanel)component;
        boolean toggleMode = togglePanel.isToggled();
        this.toggleVisibility(togglePanel.getChildren(), toggleMode);
        ResponseWriter writer = context.getResponseWriter();
        String hiddenFieldId = this.getHiddenFieldId(context, togglePanel);
        writer.startElement("input", component);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenFieldId, null);
        writer.writeAttribute("name", (Object)hiddenFieldId, null);
        writer.writeAttribute("value", (Object)(toggleMode ? "1" : ""), null);
        writer.endElement("input");
        if (!toggleMode) {
            this.writeJavascriptToToggleVisibility(context, togglePanel);
        }
        super.encodeEnd(context, (UIComponent)togglePanel);
    }

    private void toggleVisibility(List children, boolean toggleMode) {
        Iterator it = children.iterator();
        while (it.hasNext()) {
            UIComponent component = (UIComponent)it.next();
            this.setComponentVisibility(component, toggleMode);
        }
    }

    private boolean hasStyleAttribute(UIComponent component) {
        Method[] methods = component.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals("getStyle")) continue;
            return true;
        }
        return false;
    }

    private void setComponentVisibility(UIComponent component, boolean toggleMode) {
        FacesContext context = FacesContext.getCurrentInstance();
        if (!this.hasStyleAttribute(component)) {
            this.getLog().info((Object)("style attribute expected, not found for component " + component.getClientId(context)));
            return;
        }
        try {
            boolean display;
            Class<?> c = component.getClass();
            Method getStyle = c.getMethod("getStyle", new Class[0]);
            Method setStyle = c.getMethod("setStyle", class$java$lang$String == null ? (class$java$lang$String = TogglePanelRenderer.class$("java.lang.String")) : class$java$lang$String);
            String style = (String)getStyle.invoke((Object)component, new Object[0]);
            boolean bl = display = toggleMode != this.isHiddenWhenToggled(component);
            if (display) {
                if (style == null || style.length() == 0) {
                    return;
                }
                int index = style.indexOf(";display:none;");
                if (index == -1) {
                    return;
                }
                style = index == 0 ? null : style.substring(0, index);
            } else if (style == null) {
                style = ";display:none;";
            } else if (style.indexOf("display:none;") == -1) {
                style = style.concat(";display:none;");
            }
            setStyle.invoke((Object)component, style);
        }
        catch (Throwable e) {
            this.getLog().error((Object)("unable to set style attribute on component " + component.getClientId(context)));
        }
    }

    private Log getLog() {
        return LogFactory.getLog((Class)(class$org$apache$myfaces$custom$toggle$TogglePanelRenderer == null ? (class$org$apache$myfaces$custom$toggle$TogglePanelRenderer = TogglePanelRenderer.class$("org.apache.myfaces.custom.toggle.TogglePanelRenderer")) : class$org$apache$myfaces$custom$toggle$TogglePanelRenderer));
    }

    private boolean isHiddenWhenToggled(UIComponent component) {
        return component instanceof ToggleLink || component instanceof ToggleGroup;
    }

    private String getHiddenFieldId(FacesContext context, TogglePanel togglePanel) {
        return togglePanel.getClientId(context) + "_hidden";
    }

    private void writeJavascriptToToggleVisibility(FacesContext context, TogglePanel togglePanel) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        out.startElement("script", null);
        out.writeAttribute("type", (Object)"text/javascript", null);
        String functionName = TogglePanelRenderer.getToggleJavascriptFunctionName(context, togglePanel);
        out.write("function " + functionName + "(idsToShowS){\n");
        StringBuffer idsToHide = new StringBuffer();
        int idsToHideCount = 0;
        Iterator it = togglePanel.getChildren().iterator();
        while (it.hasNext()) {
            UIComponent component = (UIComponent)it.next();
            if (!this.isHiddenWhenToggled(component)) continue;
            if (idsToHideCount > 0) {
                idsToHide.append(',');
            }
            idsToHide.append(component.getClientId(context));
            ++idsToHideCount;
        }
        if (idsToHideCount == 1) {
            out.write("document.getElementById('" + idsToHide.toString() + "').style.display = 'none';\n");
        } else if (idsToHideCount > 1) {
            out.write("var idsToHide = '" + idsToHide.toString() + "'.split(',');\n");
            out.write("for(var i=0;i<idsToHide.length;i++) document.getElementById(idsToHide[i]).style.display = 'none';\n");
        } else {
            this.getLog().warn((Object)("TogglePanel " + togglePanel.getClientId(context) + " has no visible components when toggled."));
        }
        out.write("var idsToShow = idsToShowS.split(',');\n");
        out.write("for(var j=0;j<idsToShow.length;j++) document.getElementById(idsToShow[j]).style.display = 'inline';\n");
        out.write("document.getElementById('" + this.getHiddenFieldId(context, togglePanel) + "').value = '1';\n");
        out.write("}");
        out.endElement("script");
    }

    public static String getToggleJavascriptFunctionName(FacesContext context, TogglePanel togglePanel) {
        String modifiedId = togglePanel.getClientId(context).replaceAll("\\:", "_").replaceAll("-", "_");
        return "toggle_" + modifiedId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

