/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.composer.CommandParamsHelper;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsICommandManager;
import org.eclipsian.swt.internal.mozilla.nsIDOMWindow;

class CommandManagerHelper {
    private nsICommandManager commandManager;

    public CommandManagerHelper(nsICommandManager nsICommandManager2) {
        this.commandManager = nsICommandManager2;
    }

    public void registerCommandObserver(XPCOMObject xPCOMObject, String string) {
        this.commandManager.AddCommandObserver(xPCOMObject.getAddress(), Util.getNSString(string));
    }

    public void removeCommandObserver(XPCOMObject xPCOMObject, String string) {
        int n = this.commandManager.RemoveCommandObserver(xPCOMObject.getAddress(), Util.getNSString(string));
        if (n != 0) {
            this.doError(-2147467259);
        }
    }

    public boolean IsCommandEnabled(nsIDOMWindow nsIDOMWindow2, String string) {
        boolean[] blArray = new boolean[]{true};
        int n = this.commandManager.IsCommandEnabled(Util.getNSString(string), nsIDOMWindow2.getAddress(), blArray);
        if (n != 0) {
            this.doError(-2147467259);
        }
        return blArray[0];
    }

    public void DoCommand(nsIDOMWindow nsIDOMWindow2, CommandParamsHelper commandParamsHelper, String string) {
        int n = this.commandManager.DoCommand(Util.getNSString(string), commandParamsHelper.commandParams.getAddress(), nsIDOMWindow2.getAddress());
        if (n != 0) {
            this.doWarning("execCommand(" + string + ") failed");
        }
    }

    public boolean GetCommandState(nsIDOMWindow nsIDOMWindow2, CommandParamsHelper commandParamsHelper, String string) {
        int n = this.commandManager.GetCommandState(Util.getNSString(string), nsIDOMWindow2.getAddress(), commandParamsHelper.commandParams.getAddress());
        if (n != 0) {
            this.doWarning("queryCommandState(" + string + ") failed");
        }
        return n == 0;
    }

    public void Release() {
        this.commandManager.Release();
    }

    private void doError(int n) {
        MozillaEmbed.doError(n);
    }

    private void doWarning(String string) {
        MozillaEmbed.doWarning(string);
    }
}

