/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.OS;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.PersonalDictionaryHelper;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.mozIPersonalDictionary;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipsian.swt.internal.mozilla.nsIWeakReference;

public class PersonalDictionary {
    private XPCOMObject supportsWeakReference;
    private XPCOMObject weakReference;
    private XPCOMObject personalDictionary;
    private int refCount = 0;

    PersonalDictionary() {
        this.createCOMInterfaces();
    }

    void createCOMInterfaces() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return PersonalDictionary.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return PersonalDictionary.this.AddRef();
            }

            public long method2(long[] lArray) {
                return PersonalDictionary.this.Release();
            }

            public long method3(long[] lArray) {
                return PersonalDictionary.this.GetWeakReference(lArray[0]);
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public long method0(long[] lArray) {
                return PersonalDictionary.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return PersonalDictionary.this.AddRef();
            }

            public long method2(long[] lArray) {
                return PersonalDictionary.this.Release();
            }

            public long method3(long[] lArray) {
                return PersonalDictionary.this.QueryReferent(lArray[0], lArray[1]);
            }
        };
        int[] nArray3 = new int[14];
        nArray3[0] = 2;
        nArray3[5] = 1;
        nArray3[6] = 3;
        nArray3[7] = 2;
        nArray3[8] = 2;
        nArray3[9] = 1;
        nArray3[11] = 3;
        nArray3[12] = 3;
        nArray3[13] = 3;
        this.personalDictionary = new XPCOMObject(nArray3){

            public long method0(long[] lArray) {
                return PersonalDictionary.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return PersonalDictionary.this.AddRef();
            }

            public long method2(long[] lArray) {
                return PersonalDictionary.this.Release();
            }

            public long method3(long[] lArray) {
                return PersonalDictionary.this.Load();
            }

            public long method4(long[] lArray) {
                return PersonalDictionary.this.Save();
            }

            public long method5(long[] lArray) {
                return PersonalDictionary.this.getWordList(lArray[0]);
            }

            public long method6(long[] lArray) {
                return PersonalDictionary.this.Check(lArray[0], lArray[1], lArray[2]);
            }

            public long method7(long[] lArray) {
                return PersonalDictionary.this.AddWord(lArray[0], lArray[1]);
            }

            public long method8(long[] lArray) {
                return PersonalDictionary.this.RemoveWord(lArray[0], lArray[1]);
            }

            public long method9(long[] lArray) {
                return PersonalDictionary.this.IgnoreWord(lArray[0]);
            }

            public long method10(long[] lArray) {
                return PersonalDictionary.this.EndSession();
            }

            public long method11(long[] lArray) {
                return PersonalDictionary.this.AddCorrection(lArray[0], lArray[1], lArray[2]);
            }

            public long method12(long[] lArray) {
                return PersonalDictionary.this.RemoveCorrection(lArray[0], lArray[1], lArray[2]);
            }

            public long method13(long[] lArray) {
                return PersonalDictionary.this.GetCorrection(lArray[0], lArray[1], lArray[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.personalDictionary != null) {
            this.personalDictionary.dispose();
            this.personalDictionary = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
    }

    long getAddress() {
        return this.personalDictionary.getAddress();
    }

    long QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262L;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(l2, new long[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(l2, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(mozIPersonalDictionary.MOZ_PERSONALDICTIONARY_IID)) {
            XPCOM.memmove(l2, new long[]{this.personalDictionary.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        XPCOM.memmove(l2, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    long AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    long Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long QueryReferent(long l, long l2) {
        return this.QueryInterface(l, l2);
    }

    long GetWeakReference(long l) {
        XPCOM.memmove(l, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0L;
    }

    long Load() {
        return 0L;
    }

    long Save() {
        return 0L;
    }

    long getWordList(long l) {
        mozIPersonalDictionary mozIPersonalDictionary2 = PersonalDictionaryHelper.getActiveDictionary();
        if (mozIPersonalDictionary2 == null) {
            return -1041039359L;
        }
        long[] lArray = new long[1];
        int n = mozIPersonalDictionary2.getWordList(lArray);
        XPCOM.memmove(l, lArray, OS.PTR_SIZEOF);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        return n;
    }

    long Check(long l, long l2, long l3) {
        mozIPersonalDictionary mozIPersonalDictionary2 = PersonalDictionaryHelper.getActiveDictionary();
        if (mozIPersonalDictionary2 == null) {
            return -1041039359L;
        }
        long[] lArray = new long[1];
        int n = mozIPersonalDictionary2.Check(l, l2, lArray);
        XPCOM.memmove(l3, new long[]{lArray[0] != 0L ? 1 : 0}, 4);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        return n;
    }

    long AddWord(long l, long l2) {
        mozIPersonalDictionary mozIPersonalDictionary2 = PersonalDictionaryHelper.getActiveDictionary();
        if (mozIPersonalDictionary2 == null) {
            return -1041039359L;
        }
        int n = mozIPersonalDictionary2.AddWord(l, l2);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        return n;
    }

    long RemoveWord(long l, long l2) {
        mozIPersonalDictionary mozIPersonalDictionary2 = PersonalDictionaryHelper.getActiveDictionary();
        if (mozIPersonalDictionary2 == null) {
            return -1041039359L;
        }
        int n = mozIPersonalDictionary2.RemoveWord(l, l2);
        if (n != 0) {
            MozillaEmbed.doError(n);
        }
        return n;
    }

    long IgnoreWord(long l) {
        System.out.println("TODO: PersonalDictionary::IgnoreWord");
        return 0L;
    }

    long EndSession() {
        return 0L;
    }

    long AddCorrection(long l, long l2, long l3) {
        return 0L;
    }

    long RemoveCorrection(long l, long l2, long l3) {
        return 0L;
    }

    long GetCorrection(long l, long l2, long l3) {
        return 0L;
    }
}

