/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.OS;
import org.eclipsian.swt.internal.composer.URIResolveHelper;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsIFileProtocolHandler;
import org.eclipsian.swt.internal.mozilla.nsIProtocolHandler;
import org.eclipsian.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipsian.swt.internal.mozilla.nsIURI;
import org.eclipsian.swt.internal.mozilla.nsIWeakReference;

public class ProtocolHandler {
    private XPCOMObject supportsWeakReference;
    private XPCOMObject weakReference;
    private XPCOMObject protocol;
    private int refCount = 0;
    private nsIProtocolHandler protocolHandler;
    private nsIFileProtocolHandler fileProtocolHandler;
    private boolean fileChecked;

    ProtocolHandler(nsIProtocolHandler nsIProtocolHandler2) {
        this.createCOMInterfaces();
        this.protocolHandler = nsIProtocolHandler2;
    }

    void createCOMInterfaces() {
        int[] nArray = new int[4];
        nArray[0] = 2;
        nArray[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray){

            public long method0(long[] lArray) {
                return ProtocolHandler.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return ProtocolHandler.this.AddRef();
            }

            public long method2(long[] lArray) {
                return ProtocolHandler.this.Release();
            }

            public long method3(long[] lArray) {
                return ProtocolHandler.this.GetWeakReference(lArray[0]);
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public long method0(long[] lArray) {
                return ProtocolHandler.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return ProtocolHandler.this.AddRef();
            }

            public long method2(long[] lArray) {
                return ProtocolHandler.this.Release();
            }

            public long method3(long[] lArray) {
                return ProtocolHandler.this.QueryReferent(lArray[0], lArray[1]);
            }
        };
        int[] nArray3 = new int[12];
        nArray3[0] = 2;
        nArray3[3] = 1;
        nArray3[4] = 1;
        nArray3[5] = 1;
        nArray3[6] = 4;
        nArray3[7] = 2;
        nArray3[8] = 3;
        nArray3[9] = 2;
        nArray3[10] = 2;
        nArray3[11] = 2;
        this.protocol = new XPCOMObject(nArray3){

            public long method0(long[] lArray) {
                return ProtocolHandler.this.QueryInterface(lArray[0], lArray[1]);
            }

            public long method1(long[] lArray) {
                return ProtocolHandler.this.AddRef();
            }

            public long method2(long[] lArray) {
                return ProtocolHandler.this.Release();
            }

            public long method3(long[] lArray) {
                return ProtocolHandler.this.GetScheme(lArray[0]);
            }

            public long method4(long[] lArray) {
                return ProtocolHandler.this.GetDefaultPort(lArray[0]);
            }

            public long method5(long[] lArray) {
                return ProtocolHandler.this.GetProtocolFlags(lArray[0]);
            }

            public long method6(long[] lArray) {
                return ProtocolHandler.this.NewURI(lArray[0], lArray[1], lArray[2], lArray[3]);
            }

            public long method7(long[] lArray) {
                return ProtocolHandler.this.NewChannel(lArray[0], lArray[1]);
            }

            public long method8(long[] lArray) {
                return ProtocolHandler.this.AllowPort(lArray[0], lArray[1], lArray[2]);
            }

            public long method9(long[] lArray) {
                return ProtocolHandler.this.NewFileURI(lArray[0], lArray[1]);
            }

            public long method10(long[] lArray) {
                return ProtocolHandler.this.GetURLSpecFromFile(lArray[0], lArray[1]);
            }

            public long method11(long[] lArray) {
                return ProtocolHandler.this.GetFileFromURLSpec(lArray[0], lArray[1]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.protocol != null) {
            this.protocol.dispose();
            this.protocol = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
        if (this.fileProtocolHandler != null) {
            this.fileProtocolHandler.Release();
            this.fileProtocolHandler = null;
        }
    }

    long getAddress() {
        return this.protocol.getAddress();
    }

    long QueryInterface(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return -2147467262L;
        }
        nsID nsID2 = new nsID();
        XPCOM.memmove(nsID2, l, 16);
        if (nsID2.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(l2, new long[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(l2, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIProtocolHandler.NS_IPROTOCOLHANDLER_IID)) {
            XPCOM.memmove(l2, new long[]{this.protocol.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0L;
        }
        if (nsID2.Equals(nsIFileProtocolHandler.NS_IFILEPROTOCOLHANDLER_IID)) {
            if (!this.fileChecked) {
                this.fileChecked = true;
                long[] lArray = new long[1];
                int n = this.protocolHandler.QueryInterface(nsIFileProtocolHandler.NS_IFILEPROTOCOLHANDLER_IID, lArray);
                if (n == 0) {
                    this.fileProtocolHandler = new nsIFileProtocolHandler(lArray[0]);
                }
            }
            if (this.fileProtocolHandler != null) {
                XPCOM.memmove(l2, new long[]{this.protocol.getAddress()}, OS.PTR_SIZEOF);
                this.AddRef();
                return 0L;
            }
        }
        XPCOM.memmove(l2, new long[1], OS.PTR_SIZEOF);
        return -2147467262L;
    }

    long AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    long Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    long QueryReferent(long l, long l2) {
        return this.QueryInterface(l, l2);
    }

    long GetWeakReference(long l) {
        XPCOM.memmove(l, new long[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0L;
    }

    long GetScheme(long l) {
        return this.protocolHandler.getScheme(l);
    }

    long GetDefaultPort(long l) {
        int[] nArray = new int[1];
        int n = this.protocolHandler.getDefaultPort(nArray);
        XPCOM.memmove(l, nArray, 4);
        return n;
    }

    long GetProtocolFlags(long l) {
        int[] nArray = new int[1];
        int n = this.protocolHandler.getProtocolFlags(nArray);
        XPCOM.memmove(l, nArray, 4);
        return n;
    }

    long NewURI(long l, long l2, long l3, long l4) {
        byte[] byArray = null;
        if (l2 != 0L) {
            byArray = new byte[XPCOM.strlen(l2) + 1];
            XPCOM.memmove(byArray, l2, byArray.length);
        }
        long[] lArray = new long[1];
        int n = this.protocolHandler.NewURI(l, byArray, l3, lArray);
        XPCOM.memmove(l4, lArray, OS.PTR_SIZEOF);
        return n;
    }

    long NewChannel(long l, long l2) {
        long[] lArray = new long[1];
        int n = URIResolveHelper.newChannel(new nsIURI(l), lArray);
        if (n != 0) {
            n = this.protocolHandler.NewChannel(l, lArray);
        }
        XPCOM.memmove(l2, lArray, OS.PTR_SIZEOF);
        return n;
    }

    long AllowPort(long l, long l2, long l3) {
        boolean[] blArray = new boolean[1];
        byte[] byArray = new byte[XPCOM.nsEmbedCString_Length(l2)];
        XPCOM.memmove(byArray, XPCOM.nsEmbedCString_get(l2), byArray.length);
        int n = this.protocolHandler.AllowPort((int)l, byArray, blArray);
        XPCOM.memmove(l3, new long[]{blArray[0] ? 1 : 0}, 4);
        return n;
    }

    long NewFileURI(long l, long l2) {
        long[] lArray = new long[1];
        int n = this.fileProtocolHandler.NewFileURI(l, lArray);
        XPCOM.memmove(l2, lArray, OS.PTR_SIZEOF);
        return n;
    }

    long GetURLSpecFromFile(long l, long l2) {
        int n = this.fileProtocolHandler.GetURLSpecFromFile(l, l2);
        return n;
    }

    long GetFileFromURLSpec(long l, long l2) {
        long[] lArray = new long[1];
        int n = this.fileProtocolHandler.GetFileFromURLSpec(l, lArray);
        XPCOM.memmove(l2, lArray, OS.PTR_SIZEOF);
        return n;
    }
}

