/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsIBaseWindow;
import org.eclipsian.swt.internal.mozilla.nsICommandManager;
import org.eclipsian.swt.internal.mozilla.nsIComponentManager;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsIDOMWindow;
import org.eclipsian.swt.internal.mozilla.nsIDocShell;
import org.eclipsian.swt.internal.mozilla.nsIDocShellTreeItem;
import org.eclipsian.swt.internal.mozilla.nsIEditingSession;
import org.eclipsian.swt.internal.mozilla.nsIInterfaceRequestor;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowser;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowserFind;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowserFocus;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowserPrint;
import org.eclipsian.swt.internal.mozilla.nsIWebNavigation;

final class WebBrowserHelper {
    nsIWebBrowser webBrowser;
    nsIInterfaceRequestor interfaceRequestor;

    public WebBrowserHelper(nsIWebBrowser nsIWebBrowser2) {
        this.webBrowser = nsIWebBrowser2;
        this.interfaceRequestor = this.getInterfaceRequestor();
    }

    private nsIInterfaceRequestor getInterfaceRequestor() {
        long[] lArray = new long[1];
        int n = this.webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIInterfaceRequestor(lArray[0]);
    }

    public void setContainerWindow(XPCOMObject xPCOMObject) {
        int n = this.webBrowser.SetContainerWindow(xPCOMObject.getAddress());
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
    }

    public nsIBaseWindow getBaseWindow() {
        long[] lArray = new long[1];
        int n = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIBaseWindow(lArray[0]);
    }

    public nsIDocShellTreeItem getDocShellTreeItem() {
        long[] lArray = new long[1];
        int n = this.webBrowser.QueryInterface(nsIDocShellTreeItem.NS_IDOCSHELLTREEITEM_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIDocShellTreeItem(lArray[0]);
    }

    public nsIDOMWindow getContentDOMWindow() {
        long[] lArray = new long[1];
        int n = this.webBrowser.GetContentDOMWindow(lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIDOMWindow(lArray[0]);
    }

    public nsICommandManager getCommandManager() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsICommandManager.NS_ICOMMANDMANAGER_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsICommandManager(lArray[0]);
    }

    public nsIEditingSession getEditingSession() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsIEditingSession.NS_IEDITINGSESSION_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIEditingSession(lArray[0]);
    }

    public nsIWebBrowserFocus getWebBrowserFocus() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebBrowserFocus(lArray[0]);
    }

    public nsIWebBrowserPrint getWebBrowserPrint() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebBrowserPrint.NS_IWEBBROWSERPRINT_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebBrowserPrint(lArray[0]);
    }

    public void print(long l) {
        int n = this.getWebBrowserPrint().Print(l, 0L);
        if (n != 0 && n != -2147467260) {
            WebBrowserHelper.doError(n);
        }
    }

    public nsIWebNavigation getWebNavigation() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebNavigation(lArray[0]);
    }

    public nsIWebBrowserFind getWebBrowserFind() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebBrowserFind.NS_IWEBBROWSERFIND_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebBrowserFind(lArray[0]);
    }

    public nsIDocShell getDocShell() {
        long[] lArray = new long[1];
        int n = this.interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIDocShell(lArray[0]);
    }

    public void Release() {
        this.interfaceRequestor.Release();
        this.webBrowser.Release();
    }

    private static void doError(int n) {
        MozillaEmbed.doError(n);
    }

    public static nsIWebBrowser createWebBrowser() {
        nsID nsID2;
        nsIComponentManager nsIComponentManager2;
        long[] lArray = new long[1];
        int n = XPCOM.NS_GetComponentManager(lArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        if ((n = (nsIComponentManager2 = new nsIComponentManager(lArray[0])).CreateInstance(nsID2 = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C"), 0L, nsIWebBrowser.NS_IWEBBROWSER_IID, lArray)) != 0) {
            WebBrowserHelper.doError(n);
        }
        if (lArray[0] == 0L) {
            WebBrowserHelper.doError(-2147467262);
        }
        nsIWebBrowser nsIWebBrowser2 = new nsIWebBrowser(lArray[0]);
        nsIComponentManager2.Release();
        return nsIWebBrowser2;
    }
}

