/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.composer.ITooltipTextProvider;
import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.composer.NodeImpl;
import org.eclipsian.swt.internal.composer.TooltipTextProviderFactory;
import org.eclipsian.swt.internal.composer.Util;
import org.eclipsian.swt.internal.composer.dom.ElementCreator;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.nsIComponentManager;
import org.eclipsian.swt.internal.mozilla.nsIComponentRegistrar;
import org.eclipsian.swt.internal.mozilla.nsIDOMNode;
import org.eclipsian.swt.internal.mozilla.nsITooltipTextProvider;

public class TooltipTextProviderHelper {
    private static ITooltipTextProvider tooltipTextProvider = null;
    private static TooltipTextProviderFactory tooltipTextProviderFactory = null;

    private TooltipTextProviderHelper() {
    }

    public static void setTooltipTextProvider(ITooltipTextProvider iTooltipTextProvider) {
        tooltipTextProvider = iTooltipTextProvider;
    }

    public static String getNodeText(nsIDOMNode nsIDOMNode2) {
        if (tooltipTextProvider != null) {
            return tooltipTextProvider.getNodeText(ElementCreator.createElement(new NodeImpl(null, nsIDOMNode2)));
        }
        return null;
    }

    public static void register() {
        tooltipTextProviderFactory = TooltipTextProviderHelper.registerTooltipTextProviderFactory();
    }

    private static TooltipTextProviderFactory registerTooltipTextProviderFactory() {
        nsIComponentManager nsIComponentManager2;
        int[] nArray = new int[1];
        int n = XPCOM.NS_GetComponentManager(nArray);
        if (n != 0) {
            TooltipTextProviderHelper.doError(n);
        }
        if (nArray[0] == 0) {
            TooltipTextProviderHelper.doError(-2147467262);
        }
        if ((n = (nsIComponentManager2 = new nsIComponentManager(nArray[0])).QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, nArray)) != 0) {
            TooltipTextProviderHelper.doError(n);
        }
        if (nArray[0] == 0) {
            TooltipTextProviderHelper.doError(-2147467262);
        }
        nsIComponentRegistrar nsIComponentRegistrar2 = new nsIComponentRegistrar(nArray[0]);
        TooltipTextProviderFactory tooltipTextProviderFactory = new TooltipTextProviderFactory();
        tooltipTextProviderFactory.AddRef();
        n = nsIComponentRegistrar2.RegisterFactory(nsITooltipTextProvider.NS_ITOOLTIPTEXTPROVIDER_IID, Util.getNSString("TooltipTextProvider Factory"), Util.getNSString("@mozilla.org/embedcomp/tooltiptextprovider;1"), tooltipTextProviderFactory.getAddress());
        if (n != 0) {
            TooltipTextProviderHelper.doError(n);
        }
        tooltipTextProviderFactory.Release();
        nsIComponentRegistrar2.Release();
        nsIComponentManager2.Release();
        return tooltipTextProviderFactory;
    }

    public static void Release() {
        if (tooltipTextProviderFactory != null) {
            tooltipTextProviderFactory.Release();
            tooltipTextProviderFactory = null;
        }
    }

    private static void doError(int n) {
        MozillaEmbed.doError(n);
    }
}

