/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer;

import org.eclipsian.swt.internal.composer.MozillaEmbed;
import org.eclipsian.swt.internal.mozilla.XPCOM;
import org.eclipsian.swt.internal.mozilla.XPCOMObject;
import org.eclipsian.swt.internal.mozilla.nsIBaseWindow;
import org.eclipsian.swt.internal.mozilla.nsICommandManager;
import org.eclipsian.swt.internal.mozilla.nsIComponentManager;
import org.eclipsian.swt.internal.mozilla.nsID;
import org.eclipsian.swt.internal.mozilla.nsIDOMWindow;
import org.eclipsian.swt.internal.mozilla.nsIDocShell;
import org.eclipsian.swt.internal.mozilla.nsIDocShellTreeItem;
import org.eclipsian.swt.internal.mozilla.nsIEditingSession;
import org.eclipsian.swt.internal.mozilla.nsIInterfaceRequestor;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowser;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowserFind;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowserFocus;
import org.eclipsian.swt.internal.mozilla.nsIWebBrowserPrint;
import org.eclipsian.swt.internal.mozilla.nsIWebNavigation;

final class WebBrowserHelper {
    nsIWebBrowser webBrowser;
    nsIInterfaceRequestor interfaceRequestor;

    public WebBrowserHelper(nsIWebBrowser nsIWebBrowser2) {
        this.webBrowser = nsIWebBrowser2;
        this.interfaceRequestor = this.getInterfaceRequestor();
    }

    private nsIInterfaceRequestor getInterfaceRequestor() {
        int[] nArray = new int[1];
        int n = this.webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIInterfaceRequestor(nArray[0]);
    }

    public void setContainerWindow(XPCOMObject xPCOMObject) {
        int n = this.webBrowser.SetContainerWindow(xPCOMObject.getAddress());
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
    }

    public nsIBaseWindow getBaseWindow() {
        int[] nArray = new int[1];
        int n = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIBaseWindow(nArray[0]);
    }

    public nsIDocShellTreeItem getDocShellTreeItem() {
        int[] nArray = new int[1];
        int n = this.webBrowser.QueryInterface(nsIDocShellTreeItem.NS_IDOCSHELLTREEITEM_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIDocShellTreeItem(nArray[0]);
    }

    public nsIDOMWindow getContentDOMWindow() {
        int[] nArray = new int[1];
        int n = this.webBrowser.GetContentDOMWindow(nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIDOMWindow(nArray[0]);
    }

    public nsICommandManager getCommandManager() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsICommandManager.NS_ICOMMANDMANAGER_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsICommandManager(nArray[0]);
    }

    public nsIEditingSession getEditingSession() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsIEditingSession.NS_IEDITINGSESSION_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIEditingSession(nArray[0]);
    }

    public nsIWebBrowserFocus getWebBrowserFocus() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebBrowserFocus(nArray[0]);
    }

    public nsIWebBrowserPrint getWebBrowserPrint() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebBrowserPrint.NS_IWEBBROWSERPRINT_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebBrowserPrint(nArray[0]);
    }

    public void print(int n) {
        int n2 = this.getWebBrowserPrint().Print(n, 0);
        if (n2 != 0 && n2 != -2147467260) {
            WebBrowserHelper.doError(n2);
        }
    }

    public nsIWebNavigation getWebNavigation() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebNavigation(nArray[0]);
    }

    public nsIWebBrowserFind getWebBrowserFind() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsIWebBrowserFind.NS_IWEBBROWSERFIND_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIWebBrowserFind(nArray[0]);
    }

    public nsIDocShell getDocShell() {
        int[] nArray = new int[1];
        int n = this.interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        return new nsIDocShell(nArray[0]);
    }

    public void Release() {
        this.interfaceRequestor.Release();
        this.webBrowser.Release();
    }

    private static void doError(int n) {
        MozillaEmbed.doError(n);
    }

    public static nsIWebBrowser createWebBrowser() {
        nsID nsID2;
        nsIComponentManager nsIComponentManager2;
        int[] nArray = new int[1];
        int n = XPCOM.NS_GetComponentManager(nArray);
        if (n != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        if ((n = (nsIComponentManager2 = new nsIComponentManager(nArray[0])).CreateInstance(nsID2 = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C"), 0, nsIWebBrowser.NS_IWEBBROWSER_IID, nArray)) != 0) {
            WebBrowserHelper.doError(n);
        }
        if (nArray[0] == 0) {
            WebBrowserHelper.doError(-2147467262);
        }
        nsIWebBrowser nsIWebBrowser2 = new nsIWebBrowser(nArray[0]);
        nsIComponentManager2.Release();
        return nsIWebBrowser2;
    }
}

