/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.dom;

import java.util.ArrayList;
import java.util.Stack;
import org.eclipsian.composer.dom.RangeWrapper;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ranges.Range;

public class DOMUtil {
    private DOMUtil() {
    }

    public static Node getNodeAtPosition(Node node, int n) {
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return node.getFirstChild();
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        if (n < n2) {
            return nodeList.item(n);
        }
        return null;
    }

    public static int getNodePosition(Node node) {
        int n = -1;
        while (node != null) {
            ++n;
            node = node.getPreviousSibling();
        }
        return n;
    }

    public static Node[] getNodesInRange(Range range) {
        Node node;
        RangeWrapper rangeWrapper = new RangeWrapper(range);
        Node node2 = rangeWrapper.getStartContainer();
        int n = rangeWrapper.getStartOffset();
        Node node3 = rangeWrapper.getEndContainer();
        int n2 = rangeWrapper.getEndOffset();
        Node node4 = DOMUtil.getNodeAtPosition(node2, n);
        if (node4 == null && node2 instanceof CharacterData) {
            node4 = node2;
        }
        if ((node = DOMUtil.getNodeAtPosition(node3, n2)) == null && node3 instanceof CharacterData) {
            node = node3;
        }
        if (node4 == null || node == null) {
            return new Node[0];
        }
        return DOMUtil.getNodesInRange(node4, node);
    }

    public static Node[] getNodesInRange(Node node, Node node2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node3 = node;
        Stack<Node> stack = new Stack<Node>();
        while (node3 != null || !stack.isEmpty()) {
            if (node3 == null) {
                node3 = (Node)stack.pop();
            }
            arrayList.add(node3);
            if (node3.isSameNode(node2)) break;
            Node node4 = node3.getFirstChild();
            Node node5 = node3.getNextSibling();
            if (node4 != null) {
                node3 = node4;
                if (node5 == null) continue;
                stack.push(node5);
                continue;
            }
            node3 = node5;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    public static String dumpTree(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        Stack<Node> stack = new Stack<Node>();
        int n = 0;
        while (node != null || !stack.isEmpty()) {
            if (node == null) {
                do {
                    node = (Node)stack.pop();
                    --n;
                } while (node == null && !stack.isEmpty());
                continue;
            }
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append(node.getNodeName()).append(" <").append(node.getNodeValue()).append(">\n");
            stack.push(node.getNextSibling());
            node = node.getFirstChild();
            ++n;
        }
        return stringBuffer.toString();
    }
}

