/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.internal.ui.spell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipsian.composer.ui.spell.BaseDictionary;
import org.eclipsian.composer.ui.spell.ISpellCheckManager;
import org.eclipsian.composer.ui.spell.ISpellDictionary;
import org.eclipsian.swt.composer.ISpellCheck;

public class SpellCheckManager
implements ISpellCheckManager {
    private static final Map NAMES = new HashMap();
    private ISpellCheck spellCheck;
    private List dictionaries;
    private ISpellDictionary currentDictionary;

    static {
        NAMES.put("en_US", "English (US)");
        NAMES.put("en_GB", "English (GB)");
        NAMES.put("fr_FR", "French (FR)");
        NAMES.put("de_DE", "German (DE)");
        NAMES.put("it_IT", "Italian (IT)");
    }

    public SpellCheckManager(ISpellCheck iSpellCheck) {
        this.spellCheck = iSpellCheck;
        this.loadDictionaries();
    }

    public boolean isEnabled() {
        return this.spellCheck.isSpellCheckEnabled();
    }

    public void setEnabled(boolean bl) {
        this.spellCheck.enableSpellCheck(bl);
    }

    public boolean hasCurrentMisspelledWord() {
        return this.spellCheck.getMisspelledWord() != null;
    }

    public String getCurrentMisspelledWord() {
        return this.spellCheck.getMisspelledWord();
    }

    private void loadDictionaries() {
        if (this.dictionaries == null) {
            this.dictionaries = new ArrayList();
            String[] stringArray = this.spellCheck.getDictionariesAvailable();
            String string = this.spellCheck.getCurrentDictionary();
            if (string == null) {
                string = (String)NAMES.keySet().iterator().next();
            }
            int n = 0;
            while (n < stringArray.length) {
                String string2 = (String)NAMES.get(stringArray[n]);
                if (string2 == null) {
                    string2 = stringArray[n];
                }
                this.dictionaries.add(new InternalDictionary(stringArray[n], string2));
                if (stringArray[n].equals(string)) {
                    this.currentDictionary = (ISpellDictionary)this.dictionaries.get(this.dictionaries.size() - 1);
                }
                ++n;
            }
        }
    }

    public BaseDictionary[] getBaseDictionaries() {
        return this.dictionaries.toArray(new BaseDictionary[this.dictionaries.size()]);
    }

    public ISpellDictionary getCurrentDictionary() {
        return this.currentDictionary;
    }

    public void setCurrentDictionary(ISpellDictionary iSpellDictionary) {
        String[] stringArray;
        if (this.currentDictionary == iSpellDictionary) {
            return;
        }
        this.currentDictionary = iSpellDictionary;
        InternalDictionary internalDictionary = null;
        if (iSpellDictionary instanceof InternalDictionary) {
            internalDictionary = (InternalDictionary)iSpellDictionary;
        } else {
            BaseDictionary baseDictionary = iSpellDictionary.getBaseDictionary();
            if (baseDictionary instanceof InternalDictionary) {
                internalDictionary = (InternalDictionary)baseDictionary;
            }
        }
        int n = this.dictionaries.indexOf(internalDictionary);
        if (n >= 0 && internalDictionary instanceof InternalDictionary && !(stringArray = internalDictionary.getLocale()).equals(this.spellCheck.getCurrentDictionary())) {
            this.spellCheck.setCurrentDictionary((String)stringArray);
        }
        this.spellCheck.clearPersonalDictionary();
        stringArray = iSpellDictionary.getWords();
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.spellCheck.addToPersonalDictionary(stringArray[n2]);
                ++n2;
            }
        }
    }

    public void addToDictionary(String string) {
        if (!(this.currentDictionary instanceof BaseDictionary)) {
            this.currentDictionary.addWord(string);
            this.spellCheck.addToPersonalDictionary(string);
        }
    }

    public void replaceMisspelledWord(String string) {
        String string2 = this.spellCheck.getMisspelledWord();
        if (string2 != null) {
            this.spellCheck.replaceMisspelledWord(string);
            if (!(this.currentDictionary instanceof BaseDictionary)) {
                this.currentDictionary.addSuggestions(string2, new String[]{string});
            }
        }
    }

    public String[] getSuggestions(String string) {
        String[] stringArray = null;
        if (this.currentDictionary instanceof InternalDictionary || this.currentDictionary.getBaseDictionary() instanceof InternalDictionary) {
            stringArray = this.spellCheck.getSuggestedWords(string);
        }
        if (!(this.currentDictionary instanceof InternalDictionary)) {
            stringArray = SpellCheckManager.merge(stringArray, this.currentDictionary.getSuggestions(string));
        }
        if (stringArray != null) {
            return stringArray;
        }
        return new String[0];
    }

    private static String[] merge(String[] stringArray, String[] stringArray2) {
        if (!(stringArray != null && stringArray.length != 0 || stringArray2 != null && stringArray2.length != 0)) {
            return null;
        }
        if (stringArray == null || stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        n = 0;
        while (n < stringArray2.length) {
            if (!arrayList.contains(stringArray2[n])) {
                arrayList.add(stringArray2[n]);
            }
            ++n;
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void ignoreAllOccurrences(String string) {
        this.spellCheck.ignoreWord(string);
    }

    private class InternalDictionary
    extends BaseDictionary {
        public InternalDictionary(String string, String string2) {
            super(string, string2);
        }
    }
}

