/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public abstract class BaseColorAction
extends Action
implements IActionDelegate,
ISelectionChangedListener {
    private static final PaletteData PALETTE = new PaletteData(0xFF0000, 65280, 255);

    public BaseColorAction() {
    }

    public BaseColorAction(String string, ImageDescriptor imageDescriptor) {
        super(string, imageDescriptor);
    }

    public BaseColorAction(String string, int n) {
        super(string, n);
    }

    public BaseColorAction(String string) {
        super(string);
    }

    public void runWithEvent(Event event) {
        this.openColorDialog((IAction)this, event.display.getActiveShell());
    }

    public void run(IAction iAction) {
        this.openColorDialog(iAction, Display.getCurrent().getActiveShell());
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        RGB rGB;
        ImageDescriptor imageDescriptor;
        ImageDescriptor imageDescriptor2 = iAction.getImageDescriptor();
        if (imageDescriptor2 != null && (imageDescriptor = BaseColorAction.getImageDescriptor(imageDescriptor2, rGB = BaseColorAction.parseColor(this.getColor(iAction)))) != null) {
            iAction.setImageDescriptor(imageDescriptor);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.selectionChanged((IAction)this, selectionChangedEvent.getSelection());
    }

    protected void openColorDialog(IAction iAction, Shell shell) {
        ColorDialog colorDialog = new ColorDialog(shell);
        colorDialog.setRGB(BaseColorAction.parseColor(this.getColor(iAction)));
        RGB rGB = colorDialog.open();
        if (rGB != null) {
            this.setColor(iAction, BaseColorAction.buildColor(rGB));
            ImageDescriptor imageDescriptor = iAction.getImageDescriptor();
            ImageDescriptor imageDescriptor2 = BaseColorAction.getImageDescriptor(imageDescriptor, rGB);
            if (imageDescriptor2 != null) {
                iAction.setImageDescriptor(imageDescriptor2);
            }
        }
    }

    protected abstract String getColor(IAction var1);

    protected abstract void setColor(IAction var1, String var2);

    private static RGB parseColor(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("#")) {
            string = string.substring(1);
        }
        int n = 0;
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        return PALETTE.getRGB(n);
    }

    private static String buildColor(RGB rGB) {
        if (rGB != null) {
            StringBuffer stringBuffer = new StringBuffer("#");
            if (rGB.red < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(rGB.red));
            if (rGB.green < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(rGB.green));
            if (rGB.blue < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toHexString(rGB.blue));
            return stringBuffer.toString();
        }
        return "";
    }

    private static ImageDescriptor getImageDescriptor(ImageDescriptor imageDescriptor, RGB rGB) {
        Object object;
        ColorImageDescriptor colorImageDescriptor;
        if (imageDescriptor instanceof ColorImageDescriptor) {
            colorImageDescriptor = (ColorImageDescriptor)imageDescriptor;
            object = colorImageDescriptor.proxy;
        } else if (imageDescriptor instanceof ProxyImageDescriptor) {
            colorImageDescriptor = (ColorImageDescriptor)((ProxyImageDescriptor)imageDescriptor).src;
            object = colorImageDescriptor;
        } else {
            return new ColorImageDescriptor(imageDescriptor, rGB);
        }
        if (colorImageDescriptor.rgb != null && !colorImageDescriptor.rgb.equals((Object)rGB) || rGB != null && !rGB.equals((Object)colorImageDescriptor.rgb)) {
            colorImageDescriptor.rgb = rGB;
            return object;
        }
        return null;
    }

    private static class ColorImageDescriptor
    extends CompositeImageDescriptor {
        private static final int FILL_SIZE = 4;
        private static final int DEPTH = 24;
        private ImageDescriptor base;
        private ImageData baseData;
        private ImageData colorData;
        protected RGB rgb;
        protected ProxyImageDescriptor proxy;

        public ColorImageDescriptor(ImageDescriptor imageDescriptor, RGB rGB) {
            this.base = imageDescriptor;
            this.rgb = rGB;
            this.baseData = imageDescriptor.getImageData();
            this.colorData = new ImageData(this.baseData.width, 4, 24, PALETTE);
            this.proxy = new ProxyImageDescriptor((ImageDescriptor)this);
        }

        public ColorImageDescriptor(ColorImageDescriptor colorImageDescriptor, RGB rGB) {
            this.base = colorImageDescriptor.base;
            this.baseData = colorImageDescriptor.baseData;
            this.colorData = colorImageDescriptor.colorData;
            this.rgb = rGB;
        }

        protected void drawCompositeImage(int n, int n2) {
            this.drawImage(this.baseData, 0, 0);
            if (this.rgb != null) {
                int[] nArray = new int[this.baseData.width];
                int n3 = PALETTE.getPixel(this.rgb);
                int n4 = 0;
                while (n4 < nArray.length) {
                    nArray[n4] = n3;
                    ++n4;
                }
                n4 = 0;
                while (n4 < 4) {
                    this.colorData.setPixels(0, n4, nArray.length, nArray, 0);
                    ++n4;
                }
                this.drawImage(this.colorData, 0, this.baseData.height - 4);
            }
        }

        protected Point getSize() {
            return new Point(this.baseData.width, this.baseData.height);
        }
    }

    private static class ProxyImageDescriptor
    extends ImageDescriptor {
        protected ImageDescriptor src;

        public ProxyImageDescriptor(ImageDescriptor imageDescriptor) {
            this.src = imageDescriptor;
        }

        public ImageData getImageData() {
            return this.src.getImageData();
        }
    }
}

