/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.ui.editors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipsian.composer.internal.ui.Activator;
import org.eclipsian.composer.ui.actions.SimpleAction;
import org.eclipsian.composer.ui.viewers.Document;
import org.eclipsian.composer.ui.viewers.HTMLViewer;
import org.eclipsian.composer.ui.viewers.IDocument;
import org.eclipsian.composer.ui.viewers.IDocumentListener;
import org.eclipsian.composer.ui.viewers.IHTMLEditor;
import org.eclipsian.swt.composer.HyperComposer;
import org.eclipsian.swt.composer.ITransactionManager;
import org.eclipsian.swt.composer.IUndoStackListener;

public abstract class AbstractHTMLEditor
extends EditorPart {
    private SimpleAction undoAction;
    private SimpleAction redoAction;
    private Action printAction = new Action("print"){

        public void run() {
            ((HyperComposer)AbstractHTMLEditor.this.viewer.getControl()).print();
        }
    };
    private HTMLViewer viewer;
    private boolean dirty;
    private IPartListener partListener;
    private Image fTitleImage;
    private Menu fContextMenu;
    private Map actions = new HashMap();
    static /* synthetic */ Class class$0;

    protected HTMLViewer getViewer() {
        return this.viewer;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipsian.composer.ui.viewers.IHTMLEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.viewer;
        }
        return super.getAdapter(clazz);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput instanceof IPathEditorInput) {
            File file = ((IPathEditorInput)iEditorInput).getPath().toFile();
            if (!file.exists()) {
                this.performSaveAs(iProgressMonitor);
            } else {
                this.performSave(iProgressMonitor);
            }
        } else {
            this.performSaveAs(iProgressMonitor);
        }
    }

    public void doSaveAs() {
        this.performSaveAs(this.getProgressMonitor());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performSave(IProgressMonitor iProgressMonitor) {
        block8: {
            IEditorInput iEditorInput = this.getEditorInput();
            if (!(iEditorInput instanceof IPathEditorInput)) return;
            File file = ((IPathEditorInput)iEditorInput).getPath().toFile();
            FileWriter fileWriter = null;
            try {
                try {
                    fileWriter = new FileWriter(file);
                    fileWriter.write(this.viewer.getDocument().get());
                }
                catch (IOException iOException) {
                    MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Save Error", (String)iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (fileWriter == null) throw throwable;
                try {
                    fileWriter.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (fileWriter == null) break block8;
            }
            try {}
            catch (IOException iOException) {}
            fileWriter.close();
        }
        this.dirty = false;
        this.firePropertyChange(257);
    }

    protected abstract void performSaveAs(IProgressMonitor var1);

    private IProgressMonitor getProgressMonitor() {
        IProgressMonitor iProgressMonitor = null;
        IStatusLineManager iStatusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        if (iStatusLineManager != null) {
            iProgressMonitor = iStatusLineManager.getProgressMonitor();
        }
        return iProgressMonitor != null ? iProgressMonitor : new NullProgressMonitor();
    }

    protected void doResetDirty() {
        this.dirty = false;
        this.firePropertyChange(257);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.internalInit(iEditorSite.getWorkbenchWindow(), iEditorSite, iEditorInput);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart iWorkbenchPart) {
                if (iWorkbenchPart == AbstractHTMLEditor.this) {
                    AbstractHTMLEditor.this.viewer.setSelection(AbstractHTMLEditor.this.viewer.getSelection(), false);
                }
            }

            public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
            }

            public void partClosed(IWorkbenchPart iWorkbenchPart) {
            }

            public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
            }

            public void partOpened(IWorkbenchPart iWorkbenchPart) {
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
    }

    private void internalInit(IWorkbenchWindow iWorkbenchWindow, IEditorSite iEditorSite, final IEditorInput iEditorInput) throws PartInitException {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    AbstractHTMLEditor.this.doSetInput(iEditorInput);
                }
                catch (CoreException coreException) {
                    throw new InvocationTargetException(coreException);
                }
            }
        };
        try {
            iWorkbenchWindow.run(false, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof CoreException) {
                throw new PartInitException(((CoreException)throwable).getStatus());
            }
            throw new PartInitException((IStatus)new Status(4, "org.eclipsian.composer.ui", 0, "Editor initialization error", throwable));
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void doSetInput(IEditorInput iEditorInput) throws CoreException {
        super.setInput(iEditorInput);
        this.initializeTitle(iEditorInput);
        this.initializeViewerInput(iEditorInput);
    }

    protected void initializeTitle(IEditorInput iEditorInput) {
        Image image = this.fTitleImage;
        this.fTitleImage = null;
        String string = "";
        if (iEditorInput != null) {
            IEditorRegistry iEditorRegistry = this.getEditorSite().getPage().getWorkbenchWindow().getWorkbench().getEditorRegistry();
            IEditorDescriptor iEditorDescriptor = iEditorRegistry.findEditor(this.getSite().getId());
            ImageDescriptor imageDescriptor = iEditorDescriptor != null ? iEditorDescriptor.getImageDescriptor() : null;
            this.fTitleImage = imageDescriptor != null ? imageDescriptor.createImage() : null;
            string = iEditorInput.getName();
        }
        this.setTitleImage(this.fTitleImage);
        this.setPartName(string);
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeViewerInput(IEditorInput iEditorInput) throws CoreException {
        FileReader fileReader;
        this.dirty = false;
        if (!(iEditorInput instanceof IPathEditorInput)) return;
        try {
            fileReader = new FileReader(((IPathEditorInput)iEditorInput).getPath().toFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipsian.composer.ui", 0, "Could not open file", (Throwable)fileNotFoundException));
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[2048];
        try {
            try {
                int n;
                while ((n = fileReader.read(cArray)) != -1) {
                    stringBuffer.append(cArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipsian.composer.ui", 0, "File read error", (Throwable)iOException));
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                fileReader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        try {}
        catch (IOException iOException) {}
        fileReader.close();
        if (this.viewer == null) return;
        this.viewer.getDocument().set(stringBuffer.toString());
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.fTitleImage != null) {
            this.fTitleImage.dispose();
        }
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.actions.clear();
        super.dispose();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite composite) {
        this.viewer = new HTMLViewer(composite, 0);
        this.createActions();
        this.createContextMenu();
        this.initializeViewer();
    }

    protected void initializeViewer() {
        Document document = new Document();
        this.viewer.setDocument(document);
        document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(IDocument iDocument) {
                AbstractHTMLEditor.this.dirty = true;
                AbstractHTMLEditor.this.firePropertyChange(257);
            }
        });
        IEditorInput iEditorInput = this.getEditorInput();
        if (iEditorInput != null) {
            try {
                this.initializeViewerInput(iEditorInput);
            }
            catch (CoreException coreException) {
                Activator.log(coreException.getStatus());
            }
        }
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.viewer);
        ((HyperComposer)this.viewer.getControl()).getTransactionManager().addUndoStackListener(new IUndoStackListener(){

            public void undoStackChanged(ITransactionManager iTransactionManager) {
                AbstractHTMLEditor.this.undoAction.setEnabled(iTransactionManager.canUndo());
            }

            public void redoStackChanged(ITransactionManager iTransactionManager) {
                AbstractHTMLEditor.this.redoAction.setEnabled(iTransactionManager.canRedo());
            }
        });
        IActionBars iActionBars = this.getEditorSite().getActionBars();
        iActionBars.setGlobalActionHandler("undo", this.getAction("undo"));
        iActionBars.setGlobalActionHandler("redo", this.getAction("redo"));
        iActionBars.setGlobalActionHandler("cut", this.getAction("cut"));
        iActionBars.setGlobalActionHandler("copy", this.getAction("copy"));
        iActionBars.setGlobalActionHandler("paste", this.getAction("paste"));
        iActionBars.setGlobalActionHandler("delete", this.getAction("delete"));
        iActionBars.setGlobalActionHandler("selectAll", this.getAction("selectAll"));
        iActionBars.setGlobalActionHandler("print", this.getAction("print"));
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                AbstractHTMLEditor.this.fillContextMenu(iMenuManager);
            }
        });
        this.fContextMenu = menuManager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(this.fContextMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager iMenuManager) {
    }

    protected final void addAction(String string, IAction iAction) {
        if (string != null) {
            this.actions.put(string, iAction);
        }
        if ((string = iAction.getActionDefinitionId()) != null) {
            this.actions.put(string, iAction);
        }
    }

    protected IAction getAction(String string) {
        return (IAction)this.actions.get(string);
    }

    protected final void addAction(IMenuManager iMenuManager, String string, String string2) {
        IAction iAction = this.getAction(string2);
        if (iAction != null) {
            IMenuManager iMenuManager2;
            if (iAction instanceof SimpleAction) {
                ((SimpleAction)iAction).selectionChanged(new SelectionChangedEvent((ISelectionProvider)this.viewer, this.viewer.getSelection()));
            }
            if ((iMenuManager2 = iMenuManager.findMenuUsingPath(string)) != null) {
                iMenuManager2.add(iAction);
            } else {
                iMenuManager.appendToGroup(string, iAction);
            }
        }
    }

    private void createActions() {
        this.undoAction = new SimpleAction((IHTMLEditor)this.viewer, "Undo", "org.eclipse.ui.edit.undo", "undo");
        this.addAction("undo", (IAction)this.undoAction);
        this.redoAction = new SimpleAction((IHTMLEditor)this.viewer, "Redo", "org.eclipse.ui.edit.redo", "redo");
        this.addAction("redo", (IAction)this.redoAction);
        this.addAction("cut", (IAction)new SimpleAction((IHTMLEditor)this.viewer, "Cut", "org.eclipse.ui.edit.cut", "cut"));
        this.addAction("copy", (IAction)new SimpleAction((IHTMLEditor)this.viewer, "Copy", "org.eclipse.ui.edit.copy", "copy"));
        this.addAction("paste", (IAction)new SimpleAction((IHTMLEditor)this.viewer, "Paste", "org.eclipse.ui.edit.paste", "paste"));
        this.addAction("delete", (IAction)new SimpleAction((IHTMLEditor)this.viewer, "delete", "org.eclipse.ui.edit.delete", "delete"));
        this.addAction("selectAll", (IAction)new SimpleAction(this.viewer, "selectAll"));
        this.addAction("print", (IAction)this.printAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

