/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.composer.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipsian.composer.dom.DOMUtil;
import org.eclipsian.composer.internal.ui.Activator;
import org.eclipsian.composer.ui.viewers.IHTMLSelection;
import org.eclipsian.swt.composer.ISelection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLSelection
implements IHTMLSelection {
    private boolean isCollapsed = true;
    private Element selectionContainer;
    private Node focusNode;
    private int focusOffset;
    private Node[] elements;
    private String string;

    HTMLSelection(ISelection iSelection) {
        if (iSelection == null) {
            return;
        }
        this.isCollapsed = iSelection.isCollapsed();
        this.focusNode = iSelection.getFocusNode();
        this.focusOffset = iSelection.getFocusOffset();
        this.selectionContainer = iSelection.getSelectionContainer();
        this.string = iSelection.toString();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (!this.isCollapsed) {
            try {
                int n = iSelection.rangeCount();
                int n2 = 0;
                while (n2 < n) {
                    Node[] nodeArray = DOMUtil.getNodesInRange(iSelection.getRangeAt(n2));
                    int n3 = 0;
                    while (n3 < nodeArray.length) {
                        arrayList.add(nodeArray[n3]);
                        ++n3;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                Activator.log(exception);
            }
        } else if (this.focusNode != null) {
            arrayList.add(this.focusNode);
        }
        this.elements = arrayList.toArray(new Node[arrayList.size()]);
    }

    public HTMLSelection(Element element) {
        this.selectionContainer = element;
    }

    public HTMLSelection(Node[] nodeArray) {
        this.elements = nodeArray;
    }

    public boolean isCollapsed() {
        return this.isCollapsed;
    }

    public Node getFocusNode() {
        return this.focusNode;
    }

    public Element getContainer() {
        return this.selectionContainer;
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.length == 0;
    }

    public Object getFirstElement() {
        return this.isEmpty() ? null : this.elements[0];
    }

    public Iterator iterator() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements).iterator();
    }

    public int size() {
        return this.elements == null ? 0 : this.elements.length;
    }

    public Object[] toArray() {
        return this.elements == null ? new Object[]{} : (Object[])this.elements.clone();
    }

    public List toList() {
        return Arrays.asList(this.elements == null ? new Object[]{} : this.elements);
    }

    public String toString() {
        return this.string != null ? this.string : "";
    }
}

