/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsian.swt.internal.composer.dom;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipsian.swt.internal.composer.AttrImpl;
import org.eclipsian.swt.internal.composer.CDATASectionImpl;
import org.eclipsian.swt.internal.composer.CommentImpl;
import org.eclipsian.swt.internal.composer.DocumentFragmentImpl;
import org.eclipsian.swt.internal.composer.DocumentTypeImpl;
import org.eclipsian.swt.internal.composer.EntityReferenceImpl;
import org.eclipsian.swt.internal.composer.HTMLDocumentImpl;
import org.eclipsian.swt.internal.composer.NodeImpl;
import org.eclipsian.swt.internal.composer.TextImpl;
import org.eclipsian.swt.internal.composer.dom.HTMLElementImpl;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLElement;

public class ElementCreator {
    private static final Map TAGS = new HashMap(50);
    private static final String CLASS_PREFIX = "org.eclipsian.swt.internal.composer.dom.HTML";
    private static final String CLASS_POSTFIX = "ElementImpl";
    static /* synthetic */ Class class$0;

    static {
        ElementCreator.addTag("A", "Anchor");
        ElementCreator.addTag("Applet");
        ElementCreator.addTag("Area");
        ElementCreator.addTag("Base");
        ElementCreator.addTag("Body");
        ElementCreator.addTag("BR");
        ElementCreator.addTag("DIR", "Directory");
        ElementCreator.addTag("Div");
        ElementCreator.addTag("DL", "DList");
        ElementCreator.addTag("Font");
        ElementCreator.addTag("Form");
        ElementCreator.addTag("Head");
        ElementCreator.addTag("H1", "Heading");
        ElementCreator.addTag("H2", "Heading");
        ElementCreator.addTag("H3", "Heading");
        ElementCreator.addTag("H4", "Heading");
        ElementCreator.addTag("H5", "Heading");
        ElementCreator.addTag("H6", "Heading");
        ElementCreator.addTag("HR");
        ElementCreator.addTag("Html");
        ElementCreator.addTag("IMG", "Image");
        ElementCreator.addTag("Input");
        ElementCreator.addTag("Label");
        ElementCreator.addTag("LI");
        ElementCreator.addTag("Meta");
        ElementCreator.addTag("Object");
        ElementCreator.addTag("OL", "OList");
        ElementCreator.addTag("Option");
        ElementCreator.addTag("P", "Paragraph");
        ElementCreator.addTag("Param");
        ElementCreator.addTag("Pre");
        ElementCreator.addTag("Q", "Quote");
        ElementCreator.addTag("BLOCKQUOTE", "Quote");
        ElementCreator.addTag("Script");
        ElementCreator.addTag("Select");
        ElementCreator.addTag("Style");
        ElementCreator.addTag("CAPTION", "TableCaption");
        ElementCreator.addTag("TD", "TableCell");
        ElementCreator.addTag("TH", "TableCell");
        ElementCreator.addTag("COL", "TableCol");
        ElementCreator.addTag("COLGROUP", "TableCol");
        ElementCreator.addTag("Table");
        ElementCreator.addTag("TR", "TableRow");
        ElementCreator.addTag("THEAD", "TableSection");
        ElementCreator.addTag("TBODY", "TableSection");
        ElementCreator.addTag("TFOOT", "TableSection");
        ElementCreator.addTag("TextArea");
        ElementCreator.addTag("Title");
        ElementCreator.addTag("UL", "UList");
    }

    private static void addTag(String string) {
        ElementCreator.addTag(string.toUpperCase(), string);
    }

    private static void addTag(String string, String string2) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipsian.swt.internal.composer.dom.HTMLElementImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        try {
            TAGS.put(string, Class.forName(CLASS_PREFIX + string2 + CLASS_POSTFIX).getDeclaredConstructor(classArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Node createElement(NodeImpl nodeImpl) {
        if (nodeImpl != null && nodeImpl.getNodeType() == 1) {
            HTMLElementImpl hTMLElementImpl = new HTMLElementImpl(nodeImpl);
            String string = hTMLElementImpl.getTagName();
            Constructor constructor = (Constructor)TAGS.get(string);
            if (constructor != null) {
                Object[] objectArray = new Object[]{hTMLElementImpl};
                try {
                    return (HTMLElement)constructor.newInstance(objectArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return hTMLElementImpl;
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 9) {
            return new HTMLDocumentImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 10) {
            return new DocumentTypeImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 11) {
            return new DocumentFragmentImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 3) {
            return new TextImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 4) {
            return new CDATASectionImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 8) {
            return new CommentImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 5) {
            return new EntityReferenceImpl(nodeImpl);
        }
        if (nodeImpl != null && nodeImpl.getNodeType() == 2) {
            return new AttrImpl(nodeImpl);
        }
        return nodeImpl;
    }
}

