/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeClassInterceptors;
import javax.interceptor.ExcludeDefaultInterceptors;
import org.jboss.aop.Advisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodJoinpoint;
import org.jboss.ejb3.interceptors.aop.AbstractInterceptorFactory;
import org.jboss.ejb3.interceptors.aop.BusinessMethodBeanMethodInterceptor;
import org.jboss.ejb3.interceptors.aop.EJB3InterceptorInterceptor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisor;
import org.jboss.ejb3.interceptors.aop.ExtendedAdvisorHelper;
import org.jboss.ejb3.interceptors.aop.InterceptorSequencer;
import org.jboss.ejb3.interceptors.aop.InterceptorsFactory;
import org.jboss.ejb3.interceptors.aop.NopInterceptor;
import org.jboss.ejb3.interceptors.container.AbstractContainer;
import org.jboss.ejb3.interceptors.container.ManagedObjectAdvisor;
import org.jboss.ejb3.interceptors.lang.ClassHelper;
import org.jboss.logging.Logger;

public class InjectInterceptorsFactory
extends AbstractInterceptorFactory {
    private static final Logger log = Logger.getLogger(InjectInterceptorsFactory.class);

    public InjectInterceptorsFactory() {
        log.debug((Object)"new InjectInterceptorsFactory");
    }

    public Object createPerJoinpoint(Advisor advisor, InstanceAdvisor instanceAdvisor, Joinpoint jp) {
        assert (advisor != null);
        assert (instanceAdvisor != null);
        assert (jp instanceof MethodJoinpoint || jp instanceof ConstructorJoinpoint);
        log.debug((Object)("Create interceptor chain for " + instanceAdvisor.getClass().getName() + "@" + System.identityHashCode(instanceAdvisor) + " on " + jp));
        if (jp instanceof MethodJoinpoint) {
            Method method = ((MethodJoinpoint)jp).getMethod();
            if (advisor instanceof ManagedObjectAdvisor) {
                Object container = AbstractContainer.getContainer(advisor);
                List<Class<?>> interceptorClasses = ((AbstractContainer)container).getInterceptorRegistry().getApplicableInterceptorClasses(method);
                ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
                if (interceptorClasses != null) {
                    for (Class<?> interceptorClass : interceptorClasses) {
                        ExtendedAdvisor interceptorAdvisor = ExtendedAdvisorHelper.getExtendedAdvisor(advisor);
                        for (Method interceptorMethod : ClassHelper.getAllMethods(interceptorClass)) {
                            if (ClassHelper.isOverridden(interceptorClass, interceptorMethod) || !interceptorAdvisor.isAnnotationPresent(interceptorClass, interceptorMethod, AroundInvoke.class)) continue;
                            interceptors.add(new EJB3InterceptorInterceptor(interceptorClass, interceptorMethod));
                        }
                    }
                }
                Class beanClass = advisor.getClazz();
                for (Method beanMethod : ClassHelper.getAllMethods(beanClass)) {
                    if (ClassHelper.isOverridden(beanClass, beanMethod) || !advisor.hasAnnotation(beanMethod, AroundInvoke.class)) continue;
                    interceptors.add(new BusinessMethodBeanMethodInterceptor(beanMethod));
                }
                return new InterceptorSequencer(interceptors);
            }
            ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean addAll(Collection<? extends Interceptor> c) {
                    if (c == null) {
                        return false;
                    }
                    return super.addAll(c);
                }
            };
            if (!InjectInterceptorsFactory.isExcludeDefaultInterceptors(advisor, method)) {
                interceptors.addAll(InterceptorsFactory.getDefaultInterceptors(instanceAdvisor));
            }
            if (!InjectInterceptorsFactory.isExcludeClassInterceptors(advisor, method)) {
                interceptors.addAll(InterceptorsFactory.getClassInterceptors(instanceAdvisor));
            }
            interceptors.addAll(InterceptorsFactory.getBusinessMethodInterceptors(instanceAdvisor, method));
            interceptors.addAll(InterceptorsFactory.getBeanInterceptors(instanceAdvisor));
            log.debug((Object)("interceptors " + interceptors));
            return new InterceptorSequencer((List<Interceptor>)interceptors);
        }
        if (advisor instanceof ManagedObjectAdvisor) {
            log.warn((Object)"EJBTHREE-1246: Do not use InjectInterceptorsFactory with a ManagedObjectAdvisor for lifecycle callbacks, should be done by the container");
            return new NopInterceptor();
        }
        List<Interceptor> interceptors = InterceptorsFactory.getLifeCycleInterceptors(instanceAdvisor, PostConstruct.class);
        log.debug((Object)("PostConstruct interceptors " + interceptors));
        return new InterceptorSequencer(interceptors);
    }

    public Object createPerJoinpoint(Advisor advisor, Joinpoint jp) {
        log.warn((Object)("WEIRDNESS IN AOP: advisor " + advisor));
        return new InterceptorSequencer(new Interceptor[0]);
    }

    private static final boolean isExcludeClassInterceptors(Advisor advisor, Method method) {
        return advisor.hasAnnotation(method, ExcludeClassInterceptors.class) || advisor.resolveAnnotation(ExcludeClassInterceptors.class) != null;
    }

    private static final boolean isExcludeDefaultInterceptors(Advisor advisor, Method method) {
        return advisor.hasAnnotation(method, ExcludeDefaultInterceptors.class) || advisor.resolveAnnotation(ExcludeDefaultInterceptors.class) != null;
    }
}

